/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.ring.license;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Date;
import jetbrains.ring.license.License;
import jetbrains.ring.license.reader.LicenseReadException;
import jetbrains.ring.license.reader.LicenseReader;

public class LicensePrinter {
    public static void main(String[] args) throws IOException {
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        System.out.print("License Name: ");
        String licenseName = in.readLine();
        System.out.print("License Key: ");
        String licenseKey = in.readLine();
        licenseKey = licenseKey.replaceAll("[^\\dA-Fa-f]", "");
        try {
            LicenseReader reader = new LicenseReader();
            License license = reader.read(licenseName, licenseKey);
            LicensePrinter.printField("Product", license.getProduct().toString());
            LicensePrinter.printField("Deployment", license.isHosted() ? "Hosted" : "Stand-alone");
            LicensePrinter.printField("Major Version", license.getMajorVersion(), Integer.MAX_VALUE);
            LicensePrinter.printField("Minor Version", license.getMinorVersion(), Integer.MAX_VALUE);
            LicensePrinter.printField("Build", license.getBuildNumber(), Integer.MAX_VALUE);
            LicensePrinter.printField("Type", license.getLicenseType().toString());
            LicensePrinter.printDateField("Generation Time", license.getGenerationTime());
            LicensePrinter.printDateField("Expiration Time", license.getExpirationTime());
            LicensePrinter.printDateField("Upgrade Expiration Time", license.getUpgradeExpirationTime());
            LicensePrinter.printFlagField("Logo Change", !license.isLogoChangeForbidden());
            LicensePrinter.printFlagField("Guest Ban", !license.isGuestBanForbidden());
            LicensePrinter.printFlagField("Https", license.isHttpsAllowed());
            LicensePrinter.printField("Users", license.getUserCount(), Integer.MAX_VALUE);
            LicensePrinter.printField("Projects", license.getProjectCount(), Integer.MAX_VALUE);
            LicensePrinter.printField("Disk (Mb)", license.getDiskSpace(), Integer.MAX_VALUE);
            LicensePrinter.printField("Reporters", license.getReporterCount(), Integer.MAX_VALUE);
            LicensePrinter.printField("Issues", license.getIssueCount(), Long.MAX_VALUE);
            LicensePrinter.printFlagField("LDAP", license.isLdapEnabled());
            LicensePrinter.printFlagField("Tracker", !license.isTrackerDisabled());
            LicensePrinter.printFlagField("Agile", !license.isAgileDisabled());
        }
        catch (LicenseReadException e) {
            e.printStackTrace();
        }
    }

    private static void printDateField(String name, long value) {
        LicensePrinter.printField(name, value == Long.MAX_VALUE ? "Never" : new Date(value).toString());
    }

    private static void printFlagField(String name, boolean enabled) {
        LicensePrinter.printField(name, enabled ? "Enabled" : "Disabled");
    }

    private static void printField(String name, long value, long broadcastValue) {
        LicensePrinter.printField(name, value == broadcastValue ? "*" : String.valueOf(value));
    }

    private static void printField(String name, String value) {
        System.out.println(name + ": " + value);
    }
}

