/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.services.s3.model.GlacierJobParameters;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RestoreRequest
implements ToCopyableBuilder<Builder, RestoreRequest> {
    private final Integer days;
    private final GlacierJobParameters glacierJobParameters;

    private RestoreRequest(BuilderImpl builder) {
        this.days = builder.days;
        this.glacierJobParameters = builder.glacierJobParameters;
    }

    public Integer days() {
        return this.days;
    }

    public GlacierJobParameters glacierJobParameters() {
        return this.glacierJobParameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.days());
        hashCode = 31 * hashCode + Objects.hashCode(this.glacierJobParameters());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RestoreRequest)) {
            return false;
        }
        RestoreRequest other = (RestoreRequest)obj;
        return Objects.equals(this.days(), other.days()) && Objects.equals(this.glacierJobParameters(), other.glacierJobParameters());
    }

    public String toString() {
        return ToString.builder((String)"RestoreRequest").add("Days", (Object)this.days()).add("GlacierJobParameters", (Object)this.glacierJobParameters()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Days": {
                return Optional.ofNullable(clazz.cast(this.days()));
            }
            case "GlacierJobParameters": {
                return Optional.ofNullable(clazz.cast(this.glacierJobParameters()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private Integer days;
        private GlacierJobParameters glacierJobParameters;

        private BuilderImpl() {
        }

        private BuilderImpl(RestoreRequest model) {
            this.days(model.days);
            this.glacierJobParameters(model.glacierJobParameters);
        }

        public final Integer getDays() {
            return this.days;
        }

        @Override
        public final Builder days(Integer days) {
            this.days = days;
            return this;
        }

        public final void setDays(Integer days) {
            this.days = days;
        }

        public final GlacierJobParameters.Builder getGlacierJobParameters() {
            return this.glacierJobParameters != null ? this.glacierJobParameters.toBuilder() : null;
        }

        @Override
        public final Builder glacierJobParameters(GlacierJobParameters glacierJobParameters) {
            this.glacierJobParameters = glacierJobParameters;
            return this;
        }

        public final void setGlacierJobParameters(GlacierJobParameters.BuilderImpl glacierJobParameters) {
            this.glacierJobParameters = glacierJobParameters != null ? glacierJobParameters.build() : null;
        }

        public RestoreRequest build() {
            return new RestoreRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, RestoreRequest> {
        public Builder days(Integer var1);

        public Builder glacierJobParameters(GlacierJobParameters var1);

        default public Builder glacierJobParameters(Consumer<GlacierJobParameters.Builder> glacierJobParameters) {
            return this.glacierJobParameters((GlacierJobParameters)((GlacierJobParameters.Builder)GlacierJobParameters.builder().applyMutation(glacierJobParameters)).build());
        }
    }
}

