/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.PathMarshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.s3.model.DeleteObjectRequest;

public class DeleteObjectRequestMarshaller
implements Marshaller<Request<DeleteObjectRequest>, DeleteObjectRequest> {
    public Request<DeleteObjectRequest> marshall(DeleteObjectRequest deleteObjectRequest) {
        if (deleteObjectRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)deleteObjectRequest, "S3Client");
        request.setHttpMethod(HttpMethodName.DELETE);
        if (deleteObjectRequest.mfa() != null) {
            request.addHeader("x-amz-mfa", StringConversion.fromString((String)deleteObjectRequest.mfa()));
        }
        if (deleteObjectRequest.requestPayerAsString() != null) {
            request.addHeader("x-amz-request-payer", StringConversion.fromString((String)deleteObjectRequest.requestPayerAsString()));
        }
        String uriResourcePath = "/{Bucket}/{Key+}";
        uriResourcePath = PathMarshaller.NON_GREEDY.marshall(uriResourcePath, "Bucket", deleteObjectRequest.bucket());
        uriResourcePath = PathMarshaller.GREEDY.marshall(uriResourcePath, "Key", deleteObjectRequest.key());
        request.setResourcePath(uriResourcePath);
        if (deleteObjectRequest.versionId() != null) {
            request.addParameter("versionId", StringConversion.fromString((String)deleteObjectRequest.versionId()));
        }
        return request;
    }
}

