/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.PathMarshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.core.util.UriResourcePathUtils;
import software.amazon.awssdk.core.util.xml.XmlWriter;
import software.amazon.awssdk.services.s3.model.Delete;
import software.amazon.awssdk.services.s3.model.DeleteObjectsRequest;
import software.amazon.awssdk.services.s3.model.ObjectIdentifier;
import software.amazon.awssdk.utils.Md5Utils;
import software.amazon.awssdk.utils.StringInputStream;

public class DeleteObjectsRequestMarshaller
implements Marshaller<Request<DeleteObjectsRequest>, DeleteObjectsRequest> {
    public Request<DeleteObjectsRequest> marshall(DeleteObjectsRequest deleteObjectsRequest) {
        if (deleteObjectsRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)deleteObjectsRequest, "S3Client");
        request.setHttpMethod(HttpMethodName.POST);
        if (deleteObjectsRequest.mfa() != null) {
            request.addHeader("x-amz-mfa", StringConversion.fromString((String)deleteObjectsRequest.mfa()));
        }
        if (deleteObjectsRequest.requestPayerAsString() != null) {
            request.addHeader("x-amz-request-payer", StringConversion.fromString((String)deleteObjectsRequest.requestPayerAsString()));
        }
        String uriResourcePath = "/{Bucket}?delete";
        uriResourcePath = UriResourcePathUtils.addStaticQueryParametersToRequest((Request)request, (String)uriResourcePath);
        uriResourcePath = PathMarshaller.NON_GREEDY.marshall(uriResourcePath, "Bucket", deleteObjectsRequest.bucket());
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = null;
            Delete delete = deleteObjectsRequest.delete();
            if (delete != null) {
                stringWriter = new StringWriter();
                XmlWriter xmlWriter = new XmlWriter((Writer)stringWriter, "http://s3.amazonaws.com/doc/2006-03-01/");
                xmlWriter.startElement("Delete");
                List<ObjectIdentifier> deleteObjectsList = delete.objects();
                if (!deleteObjectsList.isEmpty() || !(deleteObjectsList instanceof SdkAutoConstructList)) {
                    for (ObjectIdentifier deleteObjectsListValue : deleteObjectsList) {
                        xmlWriter.startElement("Object");
                        if (deleteObjectsListValue.key() != null) {
                            xmlWriter.startElement("Key").value(deleteObjectsListValue.key()).endElement();
                        }
                        if (deleteObjectsListValue.versionId() != null) {
                            xmlWriter.startElement("VersionId").value(deleteObjectsListValue.versionId()).endElement();
                        }
                        xmlWriter.endElement();
                    }
                }
                if (delete.quiet() != null) {
                    xmlWriter.startElement("Quiet").value((Object)delete.quiet()).endElement();
                }
                xmlWriter.endElement();
            }
            if (stringWriter != null) {
                if (!request.getHeaders().containsKey("Content-MD5")) {
                    request.addHeader("Content-MD5", Md5Utils.md5AsBase64((byte[])stringWriter.getBuffer().toString().getBytes(StandardCharsets.UTF_8)));
                }
                request.setContent((InputStream)new StringInputStream(stringWriter.getBuffer().toString()));
                request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(StandardCharsets.UTF_8).length));
            }
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        }
        catch (Throwable t) {
            throw SdkClientException.builder().message("Unable to marshall request to XML: " + t.getMessage()).cause(t).build();
        }
        return request;
    }
}

