/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.PathMarshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.core.util.UriResourcePathUtils;
import software.amazon.awssdk.services.s3.model.GetObjectTaggingRequest;

public class GetObjectTaggingRequestMarshaller
implements Marshaller<Request<GetObjectTaggingRequest>, GetObjectTaggingRequest> {
    public Request<GetObjectTaggingRequest> marshall(GetObjectTaggingRequest getObjectTaggingRequest) {
        if (getObjectTaggingRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)getObjectTaggingRequest, "S3Client");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/{Bucket}/{Key+}?tagging";
        uriResourcePath = UriResourcePathUtils.addStaticQueryParametersToRequest((Request)request, (String)uriResourcePath);
        uriResourcePath = PathMarshaller.NON_GREEDY.marshall(uriResourcePath, "Bucket", getObjectTaggingRequest.bucket());
        uriResourcePath = PathMarshaller.GREEDY.marshall(uriResourcePath, "Key", getObjectTaggingRequest.key());
        request.setResourcePath(uriResourcePath);
        if (getObjectTaggingRequest.versionId() != null) {
            request.addParameter("versionId", StringConversion.fromString((String)getObjectTaggingRequest.versionId()));
        }
        return request;
    }
}

