/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.PathMarshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.core.util.UriResourcePathUtils;
import software.amazon.awssdk.core.util.xml.XmlWriter;
import software.amazon.awssdk.services.s3.model.Condition;
import software.amazon.awssdk.services.s3.model.ErrorDocument;
import software.amazon.awssdk.services.s3.model.IndexDocument;
import software.amazon.awssdk.services.s3.model.PutBucketWebsiteRequest;
import software.amazon.awssdk.services.s3.model.Redirect;
import software.amazon.awssdk.services.s3.model.RedirectAllRequestsTo;
import software.amazon.awssdk.services.s3.model.RoutingRule;
import software.amazon.awssdk.services.s3.model.WebsiteConfiguration;
import software.amazon.awssdk.utils.Md5Utils;
import software.amazon.awssdk.utils.StringInputStream;

public class PutBucketWebsiteRequestMarshaller
implements Marshaller<Request<PutBucketWebsiteRequest>, PutBucketWebsiteRequest> {
    public Request<PutBucketWebsiteRequest> marshall(PutBucketWebsiteRequest putBucketWebsiteRequest) {
        if (putBucketWebsiteRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)putBucketWebsiteRequest, "S3Client");
        request.setHttpMethod(HttpMethodName.PUT);
        if (putBucketWebsiteRequest.contentMD5() != null) {
            request.addHeader("Content-MD5", StringConversion.fromString((String)putBucketWebsiteRequest.contentMD5()));
        }
        String uriResourcePath = "/{Bucket}?website";
        uriResourcePath = UriResourcePathUtils.addStaticQueryParametersToRequest((Request)request, (String)uriResourcePath);
        uriResourcePath = PathMarshaller.NON_GREEDY.marshall(uriResourcePath, "Bucket", putBucketWebsiteRequest.bucket());
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = null;
            WebsiteConfiguration websiteConfiguration = putBucketWebsiteRequest.websiteConfiguration();
            if (websiteConfiguration != null) {
                List<RoutingRule> websiteConfigurationRoutingRulesList;
                RedirectAllRequestsTo redirectAllRequestsTo;
                IndexDocument indexDocument;
                stringWriter = new StringWriter();
                XmlWriter xmlWriter = new XmlWriter((Writer)stringWriter, "http://s3.amazonaws.com/doc/2006-03-01/");
                xmlWriter.startElement("WebsiteConfiguration");
                ErrorDocument errorDocument = websiteConfiguration.errorDocument();
                if (errorDocument != null) {
                    xmlWriter.startElement("ErrorDocument");
                    if (errorDocument.key() != null) {
                        xmlWriter.startElement("Key").value(errorDocument.key()).endElement();
                    }
                    xmlWriter.endElement();
                }
                if ((indexDocument = websiteConfiguration.indexDocument()) != null) {
                    xmlWriter.startElement("IndexDocument");
                    if (indexDocument.suffix() != null) {
                        xmlWriter.startElement("Suffix").value(indexDocument.suffix()).endElement();
                    }
                    xmlWriter.endElement();
                }
                if ((redirectAllRequestsTo = websiteConfiguration.redirectAllRequestsTo()) != null) {
                    xmlWriter.startElement("RedirectAllRequestsTo");
                    if (redirectAllRequestsTo.hostName() != null) {
                        xmlWriter.startElement("HostName").value(redirectAllRequestsTo.hostName()).endElement();
                    }
                    if (redirectAllRequestsTo.protocolAsString() != null) {
                        xmlWriter.startElement("Protocol").value(redirectAllRequestsTo.protocolAsString()).endElement();
                    }
                    xmlWriter.endElement();
                }
                if (!(websiteConfigurationRoutingRulesList = websiteConfiguration.routingRules()).isEmpty() || !(websiteConfigurationRoutingRulesList instanceof SdkAutoConstructList)) {
                    xmlWriter.startElement("RoutingRules");
                    for (RoutingRule websiteConfigurationRoutingRulesListValue : websiteConfigurationRoutingRulesList) {
                        Redirect redirect;
                        xmlWriter.startElement("RoutingRule");
                        Condition condition = websiteConfigurationRoutingRulesListValue.condition();
                        if (condition != null) {
                            xmlWriter.startElement("Condition");
                            if (condition.httpErrorCodeReturnedEquals() != null) {
                                xmlWriter.startElement("HttpErrorCodeReturnedEquals").value(condition.httpErrorCodeReturnedEquals()).endElement();
                            }
                            if (condition.keyPrefixEquals() != null) {
                                xmlWriter.startElement("KeyPrefixEquals").value(condition.keyPrefixEquals()).endElement();
                            }
                            xmlWriter.endElement();
                        }
                        if ((redirect = websiteConfigurationRoutingRulesListValue.redirect()) != null) {
                            xmlWriter.startElement("Redirect");
                            if (redirect.hostName() != null) {
                                xmlWriter.startElement("HostName").value(redirect.hostName()).endElement();
                            }
                            if (redirect.httpRedirectCode() != null) {
                                xmlWriter.startElement("HttpRedirectCode").value(redirect.httpRedirectCode()).endElement();
                            }
                            if (redirect.protocolAsString() != null) {
                                xmlWriter.startElement("Protocol").value(redirect.protocolAsString()).endElement();
                            }
                            if (redirect.replaceKeyPrefixWith() != null) {
                                xmlWriter.startElement("ReplaceKeyPrefixWith").value(redirect.replaceKeyPrefixWith()).endElement();
                            }
                            if (redirect.replaceKeyWith() != null) {
                                xmlWriter.startElement("ReplaceKeyWith").value(redirect.replaceKeyWith()).endElement();
                            }
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }
                    xmlWriter.endElement();
                }
                xmlWriter.endElement();
            }
            if (stringWriter != null) {
                if (!request.getHeaders().containsKey("Content-MD5")) {
                    request.addHeader("Content-MD5", Md5Utils.md5AsBase64((byte[])stringWriter.getBuffer().toString().getBytes(StandardCharsets.UTF_8)));
                }
                request.setContent((InputStream)new StringInputStream(stringWriter.getBuffer().toString()));
                request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(StandardCharsets.UTF_8).length));
            }
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        }
        catch (Throwable t) {
            throw SdkClientException.builder().message("Unable to marshall request to XML: " + t.getMessage()).cause(t).build();
        }
        return request;
    }
}

