/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.PathMarshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.core.util.UriResourcePathUtils;
import software.amazon.awssdk.core.util.xml.XmlWriter;
import software.amazon.awssdk.services.s3.model.AccessControlPolicy;
import software.amazon.awssdk.services.s3.model.Grant;
import software.amazon.awssdk.services.s3.model.Grantee;
import software.amazon.awssdk.services.s3.model.Owner;
import software.amazon.awssdk.services.s3.model.PutObjectAclRequest;
import software.amazon.awssdk.utils.Md5Utils;
import software.amazon.awssdk.utils.StringInputStream;

public class PutObjectAclRequestMarshaller
implements Marshaller<Request<PutObjectAclRequest>, PutObjectAclRequest> {
    public Request<PutObjectAclRequest> marshall(PutObjectAclRequest putObjectAclRequest) {
        if (putObjectAclRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)putObjectAclRequest, "S3Client");
        request.setHttpMethod(HttpMethodName.PUT);
        if (putObjectAclRequest.aclAsString() != null) {
            request.addHeader("x-amz-acl", StringConversion.fromString((String)putObjectAclRequest.aclAsString()));
        }
        if (putObjectAclRequest.contentMD5() != null) {
            request.addHeader("Content-MD5", StringConversion.fromString((String)putObjectAclRequest.contentMD5()));
        }
        if (putObjectAclRequest.grantFullControl() != null) {
            request.addHeader("x-amz-grant-full-control", StringConversion.fromString((String)putObjectAclRequest.grantFullControl()));
        }
        if (putObjectAclRequest.grantRead() != null) {
            request.addHeader("x-amz-grant-read", StringConversion.fromString((String)putObjectAclRequest.grantRead()));
        }
        if (putObjectAclRequest.grantReadACP() != null) {
            request.addHeader("x-amz-grant-read-acp", StringConversion.fromString((String)putObjectAclRequest.grantReadACP()));
        }
        if (putObjectAclRequest.grantWrite() != null) {
            request.addHeader("x-amz-grant-write", StringConversion.fromString((String)putObjectAclRequest.grantWrite()));
        }
        if (putObjectAclRequest.grantWriteACP() != null) {
            request.addHeader("x-amz-grant-write-acp", StringConversion.fromString((String)putObjectAclRequest.grantWriteACP()));
        }
        if (putObjectAclRequest.requestPayerAsString() != null) {
            request.addHeader("x-amz-request-payer", StringConversion.fromString((String)putObjectAclRequest.requestPayerAsString()));
        }
        String uriResourcePath = "/{Bucket}/{Key+}?acl";
        uriResourcePath = UriResourcePathUtils.addStaticQueryParametersToRequest((Request)request, (String)uriResourcePath);
        uriResourcePath = PathMarshaller.NON_GREEDY.marshall(uriResourcePath, "Bucket", putObjectAclRequest.bucket());
        uriResourcePath = PathMarshaller.GREEDY.marshall(uriResourcePath, "Key", putObjectAclRequest.key());
        request.setResourcePath(uriResourcePath);
        if (putObjectAclRequest.versionId() != null) {
            request.addParameter("versionId", StringConversion.fromString((String)putObjectAclRequest.versionId()));
        }
        try {
            StringWriter stringWriter = null;
            AccessControlPolicy accessControlPolicy = putObjectAclRequest.accessControlPolicy();
            if (accessControlPolicy != null) {
                Owner owner;
                stringWriter = new StringWriter();
                XmlWriter xmlWriter = new XmlWriter((Writer)stringWriter, "http://s3.amazonaws.com/doc/2006-03-01/");
                xmlWriter.startElement("AccessControlPolicy");
                List<Grant> accessControlPolicyGrantsList = accessControlPolicy.grants();
                if (!accessControlPolicyGrantsList.isEmpty() || !(accessControlPolicyGrantsList instanceof SdkAutoConstructList)) {
                    xmlWriter.startElement("AccessControlList");
                    for (Grant accessControlPolicyGrantsListValue : accessControlPolicyGrantsList) {
                        xmlWriter.startElement("Grant");
                        Grantee grantee = accessControlPolicyGrantsListValue.grantee();
                        if (grantee != null) {
                            xmlWriter.startElement("Grantee");
                            if (grantee.displayName() != null) {
                                xmlWriter.startElement("DisplayName").value(grantee.displayName()).endElement();
                            }
                            if (grantee.emailAddress() != null) {
                                xmlWriter.startElement("EmailAddress").value(grantee.emailAddress()).endElement();
                            }
                            if (grantee.id() != null) {
                                xmlWriter.startElement("ID").value(grantee.id()).endElement();
                            }
                            if (grantee.typeAsString() != null) {
                                xmlWriter.startElement("xsi:type").value(grantee.typeAsString()).endElement();
                            }
                            if (grantee.uri() != null) {
                                xmlWriter.startElement("URI").value(grantee.uri()).endElement();
                            }
                            xmlWriter.endElement();
                        }
                        if (accessControlPolicyGrantsListValue.permissionAsString() != null) {
                            xmlWriter.startElement("Permission").value(accessControlPolicyGrantsListValue.permissionAsString()).endElement();
                        }
                        xmlWriter.endElement();
                    }
                    xmlWriter.endElement();
                }
                if ((owner = accessControlPolicy.owner()) != null) {
                    xmlWriter.startElement("Owner");
                    if (owner.displayName() != null) {
                        xmlWriter.startElement("DisplayName").value(owner.displayName()).endElement();
                    }
                    if (owner.id() != null) {
                        xmlWriter.startElement("ID").value(owner.id()).endElement();
                    }
                    xmlWriter.endElement();
                }
                xmlWriter.endElement();
            }
            if (stringWriter != null) {
                if (!request.getHeaders().containsKey("Content-MD5")) {
                    request.addHeader("Content-MD5", Md5Utils.md5AsBase64((byte[])stringWriter.getBuffer().toString().getBytes(StandardCharsets.UTF_8)));
                }
                request.setContent((InputStream)new StringInputStream(stringWriter.getBuffer().toString()));
                request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(StandardCharsets.UTF_8).length));
            }
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        }
        catch (Throwable t) {
            throw SdkClientException.builder().message("Unable to marshall request to XML: " + t.getMessage()).cause(t).build();
        }
        return request;
    }
}

