/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import java.time.Instant;
import java.util.Map;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.PathMarshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;

public class PutObjectRequestMarshaller
implements Marshaller<Request<PutObjectRequest>, PutObjectRequest> {
    public Request<PutObjectRequest> marshall(PutObjectRequest putObjectRequest) {
        if (putObjectRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)putObjectRequest, "S3Client");
        request.setHttpMethod(HttpMethodName.PUT);
        if (putObjectRequest.aclAsString() != null) {
            request.addHeader("x-amz-acl", StringConversion.fromString((String)putObjectRequest.aclAsString()));
        }
        if (putObjectRequest.cacheControl() != null) {
            request.addHeader("Cache-Control", StringConversion.fromString((String)putObjectRequest.cacheControl()));
        }
        if (putObjectRequest.contentDisposition() != null) {
            request.addHeader("Content-Disposition", StringConversion.fromString((String)putObjectRequest.contentDisposition()));
        }
        if (putObjectRequest.contentEncoding() != null) {
            request.addHeader("Content-Encoding", StringConversion.fromString((String)putObjectRequest.contentEncoding()));
        }
        if (putObjectRequest.contentLanguage() != null) {
            request.addHeader("Content-Language", StringConversion.fromString((String)putObjectRequest.contentLanguage()));
        }
        if (putObjectRequest.contentLength() != null) {
            request.addHeader("Content-Length", StringConversion.fromLong((Long)putObjectRequest.contentLength()));
        }
        if (putObjectRequest.contentMD5() != null) {
            request.addHeader("Content-MD5", StringConversion.fromString((String)putObjectRequest.contentMD5()));
        }
        if (putObjectRequest.contentType() != null) {
            request.addHeader("Content-Type", StringConversion.fromString((String)putObjectRequest.contentType()));
        }
        if (putObjectRequest.expires() != null) {
            request.addHeader("Expires", StringConversion.fromInstant((Instant)putObjectRequest.expires()));
        }
        if (putObjectRequest.grantFullControl() != null) {
            request.addHeader("x-amz-grant-full-control", StringConversion.fromString((String)putObjectRequest.grantFullControl()));
        }
        if (putObjectRequest.grantRead() != null) {
            request.addHeader("x-amz-grant-read", StringConversion.fromString((String)putObjectRequest.grantRead()));
        }
        if (putObjectRequest.grantReadACP() != null) {
            request.addHeader("x-amz-grant-read-acp", StringConversion.fromString((String)putObjectRequest.grantReadACP()));
        }
        if (putObjectRequest.grantWriteACP() != null) {
            request.addHeader("x-amz-grant-write-acp", StringConversion.fromString((String)putObjectRequest.grantWriteACP()));
        }
        if (putObjectRequest.serverSideEncryptionAsString() != null) {
            request.addHeader("x-amz-server-side-encryption", StringConversion.fromString((String)putObjectRequest.serverSideEncryptionAsString()));
        }
        if (putObjectRequest.storageClassAsString() != null) {
            request.addHeader("x-amz-storage-class", StringConversion.fromString((String)putObjectRequest.storageClassAsString()));
        }
        if (putObjectRequest.websiteRedirectLocation() != null) {
            request.addHeader("x-amz-website-redirect-location", StringConversion.fromString((String)putObjectRequest.websiteRedirectLocation()));
        }
        if (putObjectRequest.sseCustomerAlgorithm() != null) {
            request.addHeader("x-amz-server-side-encryption-customer-algorithm", StringConversion.fromString((String)putObjectRequest.sseCustomerAlgorithm()));
        }
        if (putObjectRequest.sseCustomerKey() != null) {
            request.addHeader("x-amz-server-side-encryption-customer-key", StringConversion.fromString((String)putObjectRequest.sseCustomerKey()));
        }
        if (putObjectRequest.sseCustomerKeyMD5() != null) {
            request.addHeader("x-amz-server-side-encryption-customer-key-MD5", StringConversion.fromString((String)putObjectRequest.sseCustomerKeyMD5()));
        }
        if (putObjectRequest.ssekmsKeyId() != null) {
            request.addHeader("x-amz-server-side-encryption-aws-kms-key-id", StringConversion.fromString((String)putObjectRequest.ssekmsKeyId()));
        }
        if (putObjectRequest.requestPayerAsString() != null) {
            request.addHeader("x-amz-request-payer", StringConversion.fromString((String)putObjectRequest.requestPayerAsString()));
        }
        if (putObjectRequest.tagging() != null) {
            request.addHeader("x-amz-tagging", StringConversion.fromString((String)putObjectRequest.tagging()));
        }
        if (putObjectRequest.metadata() != null) {
            putObjectRequest.metadata().entrySet().forEach(arg_0 -> PutObjectRequestMarshaller.lambda$marshall$0((Request)request, arg_0));
        }
        String uriResourcePath = "/{Bucket}/{Key+}";
        uriResourcePath = PathMarshaller.NON_GREEDY.marshall(uriResourcePath, "Bucket", putObjectRequest.bucket());
        uriResourcePath = PathMarshaller.GREEDY.marshall(uriResourcePath, "Key", putObjectRequest.key());
        request.setResourcePath(uriResourcePath);
        return request;
    }

    private static /* synthetic */ void lambda$marshall$0(Request request, Map.Entry e) {
        if (((String)e.getKey()).startsWith("x-amz-meta-")) {
            request.addHeader((String)e.getKey(), (String)e.getValue());
        } else {
            request.addHeader("x-amz-meta-" + (String)e.getKey(), (String)e.getValue());
        }
    }
}

