/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.s3.model.TargetGrant;
import software.amazon.awssdk.services.s3.transform.GranteeUnmarshaller;

public class TargetGrantUnmarshaller
implements Unmarshaller<TargetGrant, StaxUnmarshallerContext> {
    private static final TargetGrantUnmarshaller INSTANCE = new TargetGrantUnmarshaller();

    public TargetGrant unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        TargetGrant.Builder targetGrant = TargetGrant.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Grantee", targetDepth)) {
                    targetGrant.grantee(GranteeUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("Permission", targetDepth)) continue;
                targetGrant.permission(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (TargetGrant)targetGrant.build();
    }

    public static TargetGrantUnmarshaller getInstance() {
        return INSTANCE;
    }
}

