/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import jetbrains.exodus.core.dataStructures.hash.HashMap;
import jetbrains.exodus.core.dataStructures.hash.HashSet;
import jetbrains.exodus.core.dataStructures.hash.IntHashMap;
import jetbrains.exodus.core.dataStructures.hash.ObjectProcedure;
import jetbrains.exodus.core.dataStructures.hash.PairProcedure;
import jetbrains.exodus.core.dataStructures.persistent.EvictListener;
import jetbrains.exodus.entitystore.EntityIterableCacheAdapter;
import jetbrains.exodus.entitystore.EntityIterableHandle;
import jetbrains.exodus.entitystore.PersistentEntityStoreConfig;
import jetbrains.exodus.entitystore.PersistentStoreTransaction;
import jetbrains.exodus.entitystore.Updatable;
import jetbrains.exodus.entitystore.iterate.CachedInstanceIterable;
import org.jetbrains.annotations.NotNull;

public final class EntityIterableCacheAdapterMutable
extends EntityIterableCacheAdapter {
    private final HandlesDistribution handlesDistribution;

    private EntityIterableCacheAdapterMutable(@NotNull PersistentEntityStoreConfig config, @NotNull HandlesDistribution handlesDistribution, @NotNull HashMap<EntityIterableHandle, Updatable> stickyObjects) {
        super(config, handlesDistribution.cache, stickyObjects);
        this.handlesDistribution = handlesDistribution;
    }

    @NotNull
    EntityIterableCacheAdapter endWrite() {
        return new EntityIterableCacheAdapter(this.config, this.cache.endWrite(), (HashMap<EntityIterableHandle, Updatable>)this.stickyObjects);
    }

    void update(final @NotNull PersistentStoreTransaction.HandleCheckerAdapter checker) {
        ObjectProcedure<EntityIterableHandle> procedure = new ObjectProcedure<EntityIterableHandle>(){

            public boolean execute(EntityIterableHandle object) {
                if (checker.checkHandle(object)) {
                    EntityIterableCacheAdapterMutable.this.remove(object);
                }
                return true;
            }
        };
        int linkId = checker.getLinkId();
        if (linkId >= 0) {
            this.handlesDistribution.byLink.forEachHandle(linkId, procedure);
        } else {
            int propertyId = checker.getPropertyId();
            if (propertyId >= 0) {
                this.handlesDistribution.byProp.forEachHandle(propertyId, procedure);
            } else {
                int typeIdAffectingCreation = checker.getTypeIdAffectingCreation();
                if (typeIdAffectingCreation >= 0) {
                    this.handlesDistribution.byTypeIdAffectingCreation.forEachHandle(typeIdAffectingCreation, procedure);
                } else {
                    int typeId = checker.getTypeId();
                    if (typeId >= 0) {
                        this.handlesDistribution.byTypeId.forEachHandle(typeId, procedure);
                        this.handlesDistribution.byTypeId.forEachHandle(Integer.MIN_VALUE, procedure);
                    } else {
                        this.forEachKey(procedure);
                    }
                }
            }
        }
        for (EntityIterableHandle handle : this.stickyObjects.keySet()) {
            checker.checkHandle(handle);
        }
    }

    @Override
    void cacheObject(@NotNull EntityIterableHandle key, @NotNull CachedInstanceIterable it) {
        super.cacheObject(key, it);
        this.handlesDistribution.addHandle(key);
    }

    void registerStickyObject(@NotNull EntityIterableHandle handle, Updatable object) {
        this.stickyObjects.put((Object)handle, (Object)object);
    }

    @Override
    void remove(@NotNull EntityIterableHandle key) {
        if (key.isSticky()) {
            throw new IllegalStateException("Cannot remove sticky object");
        }
        super.remove(key);
        this.handlesDistribution.removeHandle(key);
    }

    @Override
    void clear() {
        super.clear();
        this.handlesDistribution.clear();
    }

    void cacheObjectNotAffectingHandleDistribution(@NotNull EntityIterableHandle handle, CachedInstanceIterable it) {
        super.cacheObject(handle, it);
    }

    static EntityIterableCacheAdapterMutable create(@NotNull EntityIterableCacheAdapter source) {
        HandlesDistribution handlesDistribution = new HandlesDistribution(source.cache);
        return new EntityIterableCacheAdapterMutable(source.config, handlesDistribution, (HashMap<EntityIterableHandle, Updatable>)new HashMap(source.stickyObjects));
    }

    private static class FieldIdGroupedHandles
    extends IntHashMap<List<EntityIterableHandle>> {
        private final Set<EntityIterableHandle> removed;

        FieldIdGroupedHandles(int capacity, @NotNull Set<EntityIterableHandle> removed) {
            super(capacity);
            this.removed = removed;
        }

        void add(@NotNull EntityIterableHandle handle, int fieldId) {
            ArrayList<EntityIterableHandle> handles = (ArrayList<EntityIterableHandle>)this.get(fieldId);
            if (handles == null) {
                handles = new ArrayList<EntityIterableHandle>(4);
                this.put(fieldId, handles);
            }
            handles.add(handle);
        }

        void add(@NotNull EntityIterableHandle handle, @NotNull int[] fieldIds) {
            for (int fieldId : fieldIds) {
                if (fieldId < 0) continue;
                this.add(handle, fieldId);
            }
        }

        void forEachHandle(int fieldId, ObjectProcedure<EntityIterableHandle> procedure) {
            block4: {
                List handles = (List)this.get(fieldId);
                if (handles == null) break block4;
                if (this.removed.isEmpty()) {
                    for (EntityIterableHandle handle : handles) {
                        procedure.execute((Object)handle);
                    }
                } else {
                    for (EntityIterableHandle handle : handles) {
                        if (this.removed.contains(handle)) continue;
                        procedure.execute((Object)handle);
                    }
                }
            }
        }
    }

    private static class HandlesDistribution
    implements EvictListener<EntityIterableHandle, EntityIterableCacheAdapter.CacheItem> {
        private final EntityIterableCacheAdapter.NonAdjustablePersistentObjectCache<EntityIterableHandle, EntityIterableCacheAdapter.CacheItem> cache;
        private final Set<EntityIterableHandle> removed;
        private final FieldIdGroupedHandles byLink;
        private final FieldIdGroupedHandles byProp;
        private final FieldIdGroupedHandles byTypeId;
        private final FieldIdGroupedHandles byTypeIdAffectingCreation;

        HandlesDistribution(@NotNull EntityIterableCacheAdapter.NonAdjustablePersistentObjectCache<EntityIterableHandle, EntityIterableCacheAdapter.CacheItem> cache) {
            this.cache = cache.getClone(this);
            int count = cache.count();
            this.removed = new HashSet(10, 0.33f);
            this.byLink = new FieldIdGroupedHandles(count / 16, this.removed);
            this.byProp = new FieldIdGroupedHandles(count / 16, this.removed);
            this.byTypeId = new FieldIdGroupedHandles(count / 16, this.removed);
            this.byTypeIdAffectingCreation = new FieldIdGroupedHandles(count / 16, this.removed);
            cache.forEachEntry((PairProcedure)new PairProcedure<EntityIterableHandle, EntityIterableCacheAdapter.CacheItem>(){

                public boolean execute(EntityIterableHandle handle, EntityIterableCacheAdapter.CacheItem value) {
                    CachedInstanceIterable iterable = EntityIterableCacheAdapter.getCachedValue(value);
                    if (iterable != null) {
                        HandlesDistribution.this.addHandle(handle);
                    }
                    return true;
                }
            });
        }

        public void onEvict(@NotNull EntityIterableHandle key, EntityIterableCacheAdapter.CacheItem value) {
            this.removeHandle(key);
        }

        void removeHandle(@NotNull EntityIterableHandle handle) {
            this.removed.add(handle);
        }

        void addHandle(@NotNull EntityIterableHandle handle) {
            if (!this.removed.isEmpty()) {
                this.removed.remove(handle);
            }
            this.byLink.add(handle, handle.getLinkIds());
            this.byProp.add(handle, handle.getPropertyIds());
            this.byTypeId.add(handle, handle.getEntityTypeId());
            this.byTypeIdAffectingCreation.add(handle, handle.getTypeIdsAffectingCreation());
        }

        void clear() {
            this.removed.clear();
            this.byLink.clear();
            this.byProp.clear();
            this.byTypeId.clear();
            this.byTypeIdAffectingCreation.clear();
        }
    }
}

