/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore.iterate;

import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.entitystore.iterate.EntityIterableBase;
import jetbrains.exodus.entitystore.iterate.EntityIteratorBase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityIteratorFixingDecorator
extends EntityIteratorBase {
    private final EntityIteratorBase iterator;
    private boolean hasNext;
    private boolean hasNextValid;

    public EntityIteratorFixingDecorator(@NotNull EntityIterableBase iterable, @NotNull EntityIteratorBase iterator) {
        super(iterable);
        this.iterator = iterator;
    }

    @Override
    protected boolean hasNextImpl() {
        if (!this.hasNextValid) {
            this.hasNext = this.iterator.hasNextImpl();
            this.hasNextValid = true;
        }
        return this.hasNext;
    }

    @Override
    @Nullable
    public EntityId nextIdImpl() {
        EntityId result = this.hasNextImpl() ? this.iterator.nextIdImpl() : null;
        this.hasNextValid = false;
        return result;
    }

    @Override
    public boolean shouldBeDisposed() {
        return this.iterator.shouldBeDisposed();
    }

    @Override
    public boolean dispose() {
        return this.iterator.dispose();
    }
}

