/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore.iterate;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;
import jetbrains.exodus.entitystore.ComparableGetter;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.entitystore.EntityIterable;
import jetbrains.exodus.entitystore.EntityIterableHandle;
import jetbrains.exodus.entitystore.EntityIterableType;
import jetbrains.exodus.entitystore.EntityIterator;
import jetbrains.exodus.entitystore.PersistentEntityStoreImpl;
import jetbrains.exodus.entitystore.PersistentStoreTransaction;
import jetbrains.exodus.entitystore.iterate.EntityIterableBase;
import jetbrains.exodus.entitystore.iterate.EntityIterableHandleBase;
import jetbrains.exodus.entitystore.iterate.EntityIterableInstantiator;
import jetbrains.exodus.entitystore.iterate.EntityIteratorBase;
import jetbrains.exodus.entitystore.iterate.NonDisposableEntityIterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MergeSortedIterableWithValueGetter
extends EntityIterableBase {
    @NotNull
    private final List<EntityIterable> sorted;
    @NotNull
    private final ComparableGetter valueGetter;
    @NotNull
    private final Comparator<Comparable<Object>> comparator;

    public MergeSortedIterableWithValueGetter(@Nullable PersistentStoreTransaction txn, @NotNull List<EntityIterable> sorted, @NotNull ComparableGetter valueGetter, @NotNull Comparator<Comparable<Object>> comparator) {
        super(txn);
        this.sorted = sorted;
        this.valueGetter = valueGetter;
        this.comparator = comparator;
    }

    public static EntityIterableType getType() {
        return EntityIterableType.MERGE_SORTED;
    }

    @Override
    public boolean isSortedById() {
        return false;
    }

    @Override
    public boolean canBeCached() {
        return false;
    }

    @Override
    protected long countImpl(@NotNull PersistentStoreTransaction txn) {
        long result = 0L;
        for (EntityIterable it : this.sorted) {
            result += ((EntityIterableBase)it).getSource().countImpl(txn);
        }
        return result;
    }

    @Override
    @NotNull
    public EntityIteratorBase getIteratorImpl(@NotNull PersistentStoreTransaction txn) {
        return new MergeSortedIterator();
    }

    @Override
    @NotNull
    protected EntityIterableHandle getHandleImpl() {
        return new EntityIterableHandleBase(this.getStore(), MergeSortedIterableWithValueGetter.getType()){

            @Override
            public boolean isMatchedLinkAdded(@NotNull EntityId source, @NotNull EntityId target, int linkId) {
                return false;
            }

            @Override
            public boolean isMatchedLinkDeleted(@NotNull EntityId source, @NotNull EntityId target, int linkId) {
                return false;
            }

            @Override
            public void toString(@NotNull StringBuilder builder) {
                super.toString(builder);
                builder.append(MergeSortedIterableWithValueGetter.this.sorted.size());
                for (EntityIterable it : MergeSortedIterableWithValueGetter.this.sorted) {
                    builder.append('-');
                    ((EntityIterableHandleBase)((EntityIterableBase)it).getSource().getHandle()).toString(builder);
                }
            }

            @Override
            public void hashCode(@NotNull EntityIterableHandleBase.EntityIterableHandleHash hash) {
                hash.apply(MergeSortedIterableWithValueGetter.this.sorted.size());
                for (EntityIterable it : MergeSortedIterableWithValueGetter.this.sorted) {
                    hash.applyDelimiter();
                    hash.apply(((EntityIterableBase)it).getSource().getHandle());
                }
            }
        };
    }

    static {
        MergeSortedIterableWithValueGetter.registerType(MergeSortedIterableWithValueGetter.getType(), new EntityIterableInstantiator(){

            @Override
            public EntityIterableBase instantiate(PersistentStoreTransaction txn, PersistentEntityStoreImpl store, Object[] parameters) {
                int size = Integer.valueOf((String)parameters[0]);
                ArrayList<EntityIterable> sorted = new ArrayList<EntityIterable>(size);
                for (int i = 0; i < size; ++i) {
                    sorted.add((EntityIterable)parameters[i + 1]);
                }
                return new MergeSortedIterableWithValueGetter(txn, sorted, new ComparableGetter(){

                    public Comparable select(Entity entity) {
                        return entity.getId();
                    }
                }, new Comparator<Comparable<Object>>(){

                    @Override
                    public int compare(Comparable<Object> o1, Comparable<Object> o2) {
                        return o1.compareTo(o2);
                    }
                });
            }
        });
    }

    private final class MergeSortedIterator
    extends NonDisposableEntityIterator {
        private final PriorityQueue<EntityWithSource> queue;

        private MergeSortedIterator() {
            super(MergeSortedIterableWithValueGetter.this);
            this.queue = new PriorityQueue<EntityWithSource>(MergeSortedIterableWithValueGetter.this.sorted.size(), new Comparator<EntityWithSource>(){

                @Override
                public int compare(EntityWithSource o1, EntityWithSource o2) {
                    return MergeSortedIterableWithValueGetter.this.comparator.compare(o1.value, o2.value);
                }
            });
            for (EntityIterable it : MergeSortedIterableWithValueGetter.this.sorted) {
                EntityId id;
                EntityIterator i = it.iterator();
                if (!i.hasNext() || (id = i.nextId()) == null) continue;
                this.queue.add(new EntityWithSource(id, i));
            }
        }

        @Override
        protected boolean hasNextImpl() {
            return !this.queue.isEmpty();
        }

        @Override
        public EntityId nextIdImpl() {
            EntityWithSource pair = this.queue.poll();
            EntityId result = pair.id;
            EntityIterator i = pair.source;
            if (i.hasNext()) {
                this.queue.offer(new EntityWithSource(i.nextId(), i));
            }
            return result;
        }

        private final class EntityWithSource {
            private final EntityId id;
            private final EntityIterator source;
            private final Comparable value;

            private EntityWithSource(EntityId id, EntityIterator source) {
                this.id = id;
                this.source = source;
                this.value = id == null ? null : MergeSortedIterableWithValueGetter.this.valueGetter.select(MergeSortedIterableWithValueGetter.this.getEntity(id));
            }
        }
    }
}

