/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore.iterate.binop;

import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.entitystore.EntityIterableType;
import jetbrains.exodus.entitystore.PersistentEntityStoreImpl;
import jetbrains.exodus.entitystore.PersistentStoreTransaction;
import jetbrains.exodus.entitystore.iterate.EntityIterableBase;
import jetbrains.exodus.entitystore.iterate.EntityIterableInstantiator;
import jetbrains.exodus.entitystore.iterate.EntityIteratorBase;
import jetbrains.exodus.entitystore.iterate.EntityIteratorFixingDecorator;
import jetbrains.exodus.entitystore.iterate.NonDisposableEntityIterator;
import jetbrains.exodus.entitystore.iterate.binop.BinaryOperatorEntityIterable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ConcatenationIterable
extends BinaryOperatorEntityIterable {
    public ConcatenationIterable(@Nullable PersistentStoreTransaction txn, @NotNull EntityIterableBase iterable1, @NotNull EntityIterableBase iterable2) {
        super(txn, iterable1, iterable2, false);
    }

    @Override
    public long size() {
        return this.iterable1.size() + this.iterable2.size();
    }

    @Override
    public boolean isSortedById() {
        return false;
    }

    @Override
    protected long countImpl(@NotNull PersistentStoreTransaction txn) {
        return this.iterable1.size() + this.iterable2.size();
    }

    @Override
    protected EntityIterableType getIterableType() {
        return EntityIterableType.CONCAT;
    }

    @Override
    @NotNull
    public EntityIteratorBase getIteratorImpl(@NotNull PersistentStoreTransaction txn) {
        return new EntityIteratorFixingDecorator(this, new ConcatenationIterator(this.iterable1, this.iterable2));
    }

    static {
        ConcatenationIterable.registerType(EntityIterableType.CONCAT, new EntityIterableInstantiator(){

            @Override
            public EntityIterableBase instantiate(PersistentStoreTransaction txn, PersistentEntityStoreImpl store, Object[] parameters) {
                return new ConcatenationIterable(txn, (EntityIterableBase)parameters[0], (EntityIterableBase)parameters[1]);
            }
        });
    }

    private final class ConcatenationIterator
    extends NonDisposableEntityIterator {
        private final EntityIterableBase iterable1;
        private final EntityIterableBase iterable2;
        private EntityIteratorBase iterator1;
        private EntityIteratorBase iterator2;

        private ConcatenationIterator(@NotNull EntityIterableBase iterable1, EntityIterableBase iterable2) {
            super(ConcatenationIterable.this);
            this.iterable1 = iterable1;
            this.iterable2 = iterable2;
            this.iterator1 = this;
            this.iterator2 = this;
        }

        @Override
        protected boolean hasNextImpl() {
            if (this.iterator1 == this) {
                this.iterator1 = (EntityIteratorBase)this.iterable1.iterator();
            }
            if (this.iterator1 != null) {
                if (this.iterator1.hasNext()) {
                    return true;
                }
                this.iterator1 = null;
                this.iterator2 = (EntityIteratorBase)this.iterable2.iterator();
            }
            if (this.iterator2 != null) {
                if (this.iterator2.hasNext()) {
                    return true;
                }
                this.iterator2 = null;
            }
            return false;
        }

        @Override
        @Nullable
        public EntityId nextIdImpl() {
            if (this.iterator1 != null) {
                return this.iterator1.nextId();
            }
            if (this.iterator2 != null) {
                return this.iterator2.nextId();
            }
            return null;
        }
    }
}

