/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore.util;

import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import jetbrains.exodus.core.dataStructures.hash.LongSet;
import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.entitystore.iterate.EntityIdSet;
import jetbrains.exodus.entitystore.util.SingleTypeEntityIdSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class EmptyEntityIdSet
implements EntityIdSet {
    private static final Set<EntityId> NOTHING = Collections.emptySet();

    EmptyEntityIdSet() {
    }

    public EntityIdSet add(@Nullable EntityId id) {
        return new SingleTypeEntityIdSet(id);
    }

    public EntityIdSet add(int typeId, long localId) {
        return new SingleTypeEntityIdSet(typeId, localId);
    }

    public boolean contains(@Nullable EntityId id) {
        return false;
    }

    public boolean contains(int typeId, long localId) {
        return false;
    }

    public boolean remove(@Nullable EntityId id) {
        return false;
    }

    public boolean remove(int typeId, long localId) {
        return false;
    }

    public int count() {
        return 0;
    }

    @NotNull
    public LongSet getTypeSetSnapshot(int typeId) {
        return LongSet.EMPTY;
    }

    public Iterator<EntityId> iterator() {
        return NOTHING.iterator();
    }
}

