/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.env.management;

import jetbrains.exodus.core.dataStructures.ObjectCacheBase;
import jetbrains.exodus.env.Environment;
import jetbrains.exodus.env.EnvironmentImpl;
import jetbrains.exodus.env.EnvironmentStatistics;
import jetbrains.exodus.env.management.EnvironmentStatisticsMBean;
import jetbrains.exodus.management.MBeanBase;
import jetbrains.exodus.management.Statistics;
import org.jetbrains.annotations.NotNull;

public class EnvironmentStatistics
extends MBeanBase
implements EnvironmentStatisticsMBean {
    @NotNull
    private final EnvironmentImpl env;
    @NotNull
    private final Statistics<EnvironmentStatistics.Type> statistics;

    public EnvironmentStatistics(@NotNull EnvironmentImpl env) {
        super(EnvironmentStatistics.getObjectName(env));
        this.env = env;
        this.statistics = env.getStatistics();
    }

    static String getObjectName(@NotNull Environment env) {
        return "jetbrains.exodus.env: type=EnvironmentStatistics, location=" + EnvironmentStatistics.escapeLocation((String)env.getLocation());
    }

    @Override
    public long getBytesWritten() {
        return this.getTotal(EnvironmentStatistics.Type.BYTES_WRITTEN);
    }

    @Override
    public double getBytesWrittenPerSecond() {
        return this.getMean(EnvironmentStatistics.Type.BYTES_WRITTEN);
    }

    @Override
    public long getBytesRead() {
        return this.getTotal(EnvironmentStatistics.Type.BYTES_READ);
    }

    @Override
    public double getBytesReadPerSecond() {
        return this.getMean(EnvironmentStatistics.Type.BYTES_READ);
    }

    @Override
    public long getBytesMovedByGC() {
        return this.getTotal(EnvironmentStatistics.Type.BYTES_MOVED_BY_GC);
    }

    @Override
    public double getBytesMovedByGCPerSecond() {
        return this.getMean(EnvironmentStatistics.Type.BYTES_MOVED_BY_GC);
    }

    @Override
    public String getLogCacheHitRate() {
        return ObjectCacheBase.formatHitRate((float)((float)this.getMean(EnvironmentStatistics.Type.LOG_CACHE_HIT_RATE)));
    }

    @Override
    public long getNumberOfTransactions() {
        return this.getTotal(EnvironmentStatistics.Type.TRANSACTIONS);
    }

    @Override
    public double getNumberOfTransactionsPerSecond() {
        return this.getMean(EnvironmentStatistics.Type.TRANSACTIONS);
    }

    @Override
    public long getNumberOfReadonlyTransactions() {
        return this.getTotal(EnvironmentStatistics.Type.READONLY_TRANSACTIONS);
    }

    @Override
    public double getNumberOfReadonlyTransactionsPerSecond() {
        return this.getMean(EnvironmentStatistics.Type.READONLY_TRANSACTIONS);
    }

    @Override
    public int getActiveTransactions() {
        return (int)this.getTotal(EnvironmentStatistics.Type.ACTIVE_TRANSACTIONS);
    }

    @Override
    public long getNumberOfFlushedTransactions() {
        return this.getTotal(EnvironmentStatistics.Type.FLUSHED_TRANSACTIONS);
    }

    @Override
    public double getNumberOfFlushedTransactionsPerSecond() {
        return this.getMean(EnvironmentStatistics.Type.FLUSHED_TRANSACTIONS);
    }

    @Override
    public long getDiskUsage() {
        return this.getTotal(EnvironmentStatistics.Type.DISK_USAGE);
    }

    @Override
    public int getUtilizationPercent() {
        return (int)this.getTotal(EnvironmentStatistics.Type.UTILIZATION_PERCENT);
    }

    @Override
    public String getStoreGetCacheHitRate() {
        return ObjectCacheBase.formatHitRate((float)((float)this.getMean(EnvironmentStatistics.Type.STORE_GET_CACHE_HIT_RATE)));
    }

    @Override
    public int getStuckTransactionCount() {
        return this.env.getStuckTransactionCount();
    }

    private long getTotal(@NotNull EnvironmentStatistics.Type statisticsName) {
        return this.statistics.getStatisticsItem((Enum)statisticsName).getTotal();
    }

    private double getMean(@NotNull EnvironmentStatistics.Type statisticsName) {
        return this.statistics.getStatisticsItem((Enum)statisticsName).getMean();
    }
}

