/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.gc;

import java.io.File;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import jetbrains.exodus.ExodusException;
import jetbrains.exodus.core.dataStructures.LongArrayList;
import jetbrains.exodus.core.dataStructures.Priority;
import jetbrains.exodus.core.dataStructures.hash.IntHashMap;
import jetbrains.exodus.core.dataStructures.hash.LongIterator;
import jetbrains.exodus.core.dataStructures.hash.PackedLongHashSet;
import jetbrains.exodus.core.execution.Job;
import jetbrains.exodus.core.execution.JobProcessorAdapter;
import jetbrains.exodus.env.EnvironmentConfig;
import jetbrains.exodus.env.EnvironmentImpl;
import jetbrains.exodus.env.ReadWriteTransaction;
import jetbrains.exodus.env.StoreImpl;
import jetbrains.exodus.env.TransactionAcquireTimeoutException;
import jetbrains.exodus.env.TransactionBase;
import jetbrains.exodus.gc.BackgroundCleaner;
import jetbrains.exodus.gc.GarbageCollector;
import jetbrains.exodus.gc.GcJob;
import jetbrains.exodus.gc.UtilizationProfile;
import jetbrains.exodus.io.Block;
import jetbrains.exodus.io.DataReader;
import jetbrains.exodus.io.DataWriter;
import jetbrains.exodus.io.RemoveBlockType;
import jetbrains.exodus.log.AbstractBlockListener;
import jetbrains.exodus.log.ExpiredLoggableInfo;
import jetbrains.exodus.log.Log;
import jetbrains.exodus.log.LogUtil;
import jetbrains.exodus.log.LoggableIterator;
import jetbrains.exodus.log.RandomAccessLoggable;
import jetbrains.exodus.runtime.OOMGuard;
import jetbrains.exodus.util.DeferredIO;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import mu.KLogger;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010(\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 T2\u00020\u0001:\u0001TB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010,\u001a\u00020-J\u001b\u0010.\u001a\u00020\u00112\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u000b00H\u0000\u00a2\u0006\u0002\b1J\u0018\u00102\u001a\u00020-2\u0006\u00103\u001a\u00020\u000b2\u0006\u00104\u001a\u000205H\u0002J\u0006\u00106\u001a\u00020-J\r\u00107\u001a\u00020-H\u0000\u00a2\u0006\u0002\b8J\u000e\u00109\u001a\u00020\u00112\u0006\u00103\u001a\u00020\u000bJ\u0016\u0010:\u001a\u00020\u00112\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u000b00H\u0002J\u0014\u0010;\u001a\u00020-2\f\u0010<\u001a\b\u0012\u0004\u0012\u00020>0=J\u0006\u0010?\u001a\u00020-J\u000e\u0010@\u001a\u00020\u000b2\u0006\u00103\u001a\u00020\u000bJ\u0015\u0010A\u001a\u00020\u00112\u0006\u0010B\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\bCJ\u0010\u0010D\u001a\u00020-2\u0006\u0010E\u001a\u00020#H\u0002J\r\u0010F\u001a\u00020-H\u0000\u00a2\u0006\u0002\bGJ\u0006\u0010H\u001a\u00020-J\u000e\u0010I\u001a\u00020-2\u0006\u0010J\u001a\u00020KJ\u0015\u0010L\u001a\u00020-2\u0006\u0010'\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\bMJ\u0006\u0010N\u001a\u00020-J\u0006\u0010O\u001a\u00020-J\u0006\u0010P\u001a\u00020-J\u0015\u0010Q\u001a\u00020-2\u0006\u0010R\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\bSR\u0014\u0010\u0005\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00118@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00158@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u00198@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\u00198@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001bR\u000e\u0010\u001e\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010$\u001a\u00020\u000b8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u000e\u0010'\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010(\u001a\u00020)\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+\u00a8\u0006U"}, d2={"Ljetbrains/exodus/gc/GarbageCollector;", "", "environment", "Ljetbrains/exodus/env/EnvironmentImpl;", "(Ljetbrains/exodus/env/EnvironmentImpl;)V", "cleaner", "Ljetbrains/exodus/gc/BackgroundCleaner;", "getCleaner$xodus_environment", "()Ljetbrains/exodus/gc/BackgroundCleaner;", "deletionQueue", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "", "ec", "Ljetbrains/exodus/env/EnvironmentConfig;", "getEnvironment$xodus_environment", "()Ljetbrains/exodus/env/EnvironmentImpl;", "isTooMuchFreeSpace", "", "isTooMuchFreeSpace$xodus_environment", "()Z", "log", "Ljetbrains/exodus/log/Log;", "getLog$xodus_environment", "()Ljetbrains/exodus/log/Log;", "maximumFreeSpacePercent", "", "getMaximumFreeSpacePercent$xodus_environment", "()I", "minFileAge", "getMinFileAge$xodus_environment", "newFiles", "openStoresCache", "Ljetbrains/exodus/core/dataStructures/hash/IntHashMap;", "Ljetbrains/exodus/env/StoreImpl;", "pendingFilesToDelete", "Ljetbrains/exodus/core/dataStructures/hash/PackedLongHashSet;", "startTime", "getStartTime$xodus_environment", "()J", "useRegularTxn", "utilizationProfile", "Ljetbrains/exodus/gc/UtilizationProfile;", "getUtilizationProfile", "()Ljetbrains/exodus/gc/UtilizationProfile;", "cleanEntireLog", "", "cleanFiles", "fragmentedFiles", "", "cleanFiles$xodus_environment", "cleanSingleFile", "fileAddress", "txn", "Ljetbrains/exodus/env/ReadWriteTransaction;", "clear", "deletePendingFiles", "deletePendingFiles$xodus_environment", "doCleanFile", "doCleanFiles", "fetchExpiredLoggables", "loggables", "", "Ljetbrains/exodus/log/ExpiredLoggableInfo;", "finish", "getFileFreeBytes", "isFileCleaned", "file", "isFileCleaned$xodus_environment", "queueDeletionOfFiles", "cleanedFiles", "resetNewFiles", "resetNewFiles$xodus_environment", "resume", "setCleanerJobProcessor", "processor", "Ljetbrains/exodus/core/execution/JobProcessorAdapter;", "setUseRegularTxn", "setUseRegularTxn$xodus_environment", "suspend", "testDeletePendingFiles", "wake", "wakeAt", "millis", "wakeAt$xodus_environment", "Companion", "xodus-environment"})
public final class GarbageCollector {
    private final EnvironmentConfig ec;
    @NotNull
    private final UtilizationProfile utilizationProfile;
    private final PackedLongHashSet pendingFilesToDelete;
    private final ConcurrentLinkedQueue<Long> deletionQueue;
    @NotNull
    private final BackgroundCleaner cleaner;
    private volatile int newFiles;
    private final IntHashMap<StoreImpl> openStoresCache;
    private boolean useRegularTxn;
    @NotNull
    private final EnvironmentImpl environment;
    @NotNull
    public static final String UTILIZATION_PROFILE_STORE_NAME = "exodus.gc.up";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final UtilizationProfile getUtilizationProfile() {
        return this.utilizationProfile;
    }

    @NotNull
    public final BackgroundCleaner getCleaner$xodus_environment() {
        return this.cleaner;
    }

    public final int getMaximumFreeSpacePercent$xodus_environment() {
        return 100 - this.ec.getGcMinUtilization();
    }

    public final boolean isTooMuchFreeSpace$xodus_environment() {
        return this.utilizationProfile.totalFreeSpacePercent$xodus_environment() > this.getMaximumFreeSpacePercent$xodus_environment();
    }

    public final int getMinFileAge$xodus_environment() {
        return this.ec.getGcFileMinAge();
    }

    @NotNull
    public final Log getLog$xodus_environment() {
        Log log = this.environment.getLog();
        Intrinsics.checkExpressionValueIsNotNull((Object)log, (String)"environment.log");
        return log;
    }

    public final long getStartTime$xodus_environment() {
        return this.environment.getCreated() + (long)this.ec.getGcStartIn();
    }

    public final void clear() {
        this.utilizationProfile.clear$xodus_environment();
        this.pendingFilesToDelete.clear();
        this.deletionQueue.clear();
        this.openStoresCache.clear();
        this.resetNewFiles$xodus_environment();
    }

    public final void setCleanerJobProcessor(@NotNull JobProcessorAdapter processor) {
        Intrinsics.checkParameterIsNotNull((Object)processor, (String)"processor");
        this.cleaner.getJobProcessor().queue(new Job(this, processor){
            final /* synthetic */ GarbageCollector this$0;
            final /* synthetic */ JobProcessorAdapter $processor;

            protected void execute() {
                this.this$0.getCleaner$xodus_environment().setJobProcessor(this.$processor);
            }
            {
                this.this$0 = $outer;
                this.$processor = $captured_local_variable$1;
            }
        }, Priority.highest);
    }

    public final void wake() {
        if (this.ec.isGcEnabled()) {
            this.environment.executeTransactionSafeTask(new Runnable(this){
                final /* synthetic */ GarbageCollector this$0;

                public final void run() {
                    this.this$0.getCleaner$xodus_environment().queueCleaningJob();
                }
                {
                    this.this$0 = garbageCollector;
                }
            });
        }
    }

    public final void wakeAt$xodus_environment(long millis) {
        if (this.ec.isGcEnabled()) {
            this.cleaner.queueCleaningJobAt(millis);
        }
    }

    public final void fetchExpiredLoggables(@NotNull Iterable<? extends ExpiredLoggableInfo> loggables) {
        Intrinsics.checkParameterIsNotNull(loggables, (String)"loggables");
        this.utilizationProfile.fetchExpiredLoggables$xodus_environment(loggables);
    }

    public final long getFileFreeBytes(long fileAddress) {
        return this.utilizationProfile.getFileFreeBytes$xodus_environment(fileAddress);
    }

    public final void suspend() {
        this.cleaner.suspend();
    }

    public final void resume() {
        this.cleaner.resume();
    }

    public final void finish() {
        this.cleaner.finish();
    }

    public final boolean doCleanFile(long fileAddress) {
        return this.doCleanFiles(SetsKt.setOf((Object)fileAddress).iterator());
    }

    public final boolean cleanFiles$xodus_environment(@NotNull Iterator<Long> fragmentedFiles2) {
        Intrinsics.checkParameterIsNotNull(fragmentedFiles2, (String)"fragmentedFiles");
        this.cleaner.checkThread();
        return this.doCleanFiles(fragmentedFiles2);
    }

    public final boolean isFileCleaned$xodus_environment(long file) {
        return this.pendingFilesToDelete.contains((Object)file);
    }

    public final void resetNewFiles$xodus_environment() {
        this.newFiles = 0;
    }

    public final void setUseRegularTxn$xodus_environment(boolean useRegularTxn) {
        this.useRegularTxn = useRegularTxn;
    }

    public final void cleanEntireLog() {
        this.cleaner.cleanEntireLog();
    }

    public final void testDeletePendingFiles() {
        long[] files = this.pendingFilesToDelete.toLongArray();
        boolean aFileWasDeleted = false;
        long[] currentFile = new long[1];
        for (long file : files) {
            this.utilizationProfile.removeFile$xodus_environment(file);
            currentFile[0] = file;
            this.environment.removeFiles(currentFile, this.ec.getGcRenameFiles() ? RemoveBlockType.Rename : RemoveBlockType.Delete);
            aFileWasDeleted = true;
        }
        if (aFileWasDeleted) {
            this.pendingFilesToDelete.clear();
            this.utilizationProfile.estimateTotalBytes$xodus_environment();
        }
    }

    public final void deletePendingFiles$xodus_environment() {
        if (!this.cleaner.isCurrentThread()) {
            this.cleaner.getJobProcessor().queue((Job)new GcJob(this, (Function0<Unit>)((Function0)new Function0<Unit>(this){
                final /* synthetic */ GarbageCollector this$0;

                public final void invoke() {
                    this.this$0.deletePendingFiles$xodus_environment();
                }
                {
                    this.this$0 = garbageCollector;
                    super(0);
                }
            })));
        } else {
            LongArrayList filesToDelete = new LongArrayList();
            while (true) {
                long l;
                Long l2 = this.deletionQueue.poll();
                if (l2 == null) {
                    break;
                }
                long $receiver = l = l2.longValue();
                if (this.pendingFilesToDelete.remove((Object)$receiver)) {
                    filesToDelete.add($receiver);
                }
            }
            if (!filesToDelete.isEmpty()) {
                long[] $receiver$iv;
                this.environment.flushAndSync();
                long[] filesArray = filesToDelete.toArray();
                this.environment.removeFiles(filesArray, this.ec.getGcRenameFiles() ? RemoveBlockType.Rename : RemoveBlockType.Delete);
                Intrinsics.checkExpressionValueIsNotNull((Object)filesArray, (String)"filesArray");
                long[] lArray = $receiver$iv = filesArray;
                int n = lArray.length;
                for (int j = 0; j < n; ++j) {
                    long element$iv;
                    long it = element$iv = lArray[j];
                    this.utilizationProfile.removeFile$xodus_environment(it);
                }
                this.utilizationProfile.estimateTotalBytesAndWakeGcIfNecessary$xodus_environment();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean doCleanFiles(Iterator<Long> fragmentedFiles2) {
        ReadWriteTransaction txn;
        if (!fragmentedFiles2.hasNext()) {
            return true;
        }
        PackedLongHashSet cleanedFiles = new PackedLongHashSet(null, 1, null);
        try {
            TransactionBase tx;
            TransactionBase transactionBase = tx = this.useRegularTxn ? this.environment.beginTransaction() : (TransactionBase)this.environment.beginGCTransaction();
            Intrinsics.checkExpressionValueIsNotNull((Object)transactionBase, (String)"tx");
            if (transactionBase.isReadonly()) {
                tx.abort();
                return false;
            }
            txn = (ReadWriteTransaction)tx;
        }
        catch (TransactionAcquireTimeoutException ignore) {
            return false;
        }
        boolean isTxnExclusive = txn.isExclusive();
        try {
            OOMGuard guard = new OOMGuard(0, 1, null);
            long started = System.currentTimeMillis();
            while (fragmentedFiles2.hasNext()) {
                Long l = fragmentedFiles2.next();
                long $receiver = ((Number)l).longValue();
                this.cleanSingleFile($receiver, txn);
                cleanedFiles.add($receiver);
                if (isTxnExclusive && started + (long)this.ec.getGcTransactionTimeout() >= System.currentTimeMillis() && !guard.isItCloseToOOM()) continue;
                break;
            }
            if (!txn.forceFlush()) {
                if (isTxnExclusive) {
                    throw (Throwable)new ExodusException("Can't be: exclusive txn should be successfully flushed");
                }
                boolean bl = false;
                return bl;
            }
        }
        catch (Throwable e) {
            RuntimeException runtimeException = ExodusException.toExodusException((Throwable)e);
            Intrinsics.checkExpressionValueIsNotNull((Object)runtimeException, (String)"ExodusException.toExodusException(e)");
            throw (Throwable)runtimeException;
        }
        finally {
            txn.abort();
        }
        if (!cleanedFiles.isEmpty()) {
            LongIterator longIterator = cleanedFiles.iterator();
            while (longIterator.hasNext()) {
                Long file;
                Long l = file = (Long)longIterator.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)l, (String)"file");
                this.pendingFilesToDelete.add(l.longValue());
                this.utilizationProfile.resetFile$xodus_environment(file);
            }
            this.utilizationProfile.estimateTotalBytes$xodus_environment();
            this.environment.executeTransactionSafeTask(new Runnable(this, cleanedFiles){
                final /* synthetic */ GarbageCollector this$0;
                final /* synthetic */ PackedLongHashSet $cleanedFiles;

                public final void run() {
                    int filesDeletionDelay = GarbageCollector.access$getEc$p(this.this$0).getGcFilesDeletionDelay();
                    if (filesDeletionDelay == 0) {
                        GarbageCollector.access$queueDeletionOfFiles(this.this$0, this.$cleanedFiles);
                    } else {
                        DeferredIO.getJobProcessor().queueIn(new Job(this){
                            final /* synthetic */ doCleanFiles.2 this$0;

                            protected void execute() {
                                GarbageCollector.access$queueDeletionOfFiles(this.this$0.this$0, this.this$0.$cleanedFiles);
                            }
                            {
                                this.this$0 = $outer;
                            }
                        }, (long)filesDeletionDelay);
                    }
                }
                {
                    this.this$0 = garbageCollector;
                    this.$cleanedFiles = packedLongHashSet;
                }
            });
        }
        return true;
    }

    private final void queueDeletionOfFiles(PackedLongHashSet cleanedFiles) {
        for (Long file : cleanedFiles) {
            this.deletionQueue.offer(file);
        }
        this.deletePendingFiles$xodus_environment();
    }

    private final void cleanSingleFile(long fileAddress, ReadWriteTransaction txn) {
        Object object;
        if (this.isFileCleaned$xodus_environment(fileAddress)) {
            throw (Throwable)new ExodusException("Attempt to clean already cleaned file");
        }
        Companion.loggingInfo$xodus_environment((Function0<String>)((Function0)new Function0<String>(this, fileAddress){
            final /* synthetic */ GarbageCollector this$0;
            final /* synthetic */ long $fileAddress;

            @NotNull
            public final String invoke() {
                return "start cleanFile(" + this.this$0.getEnvironment$xodus_environment().getLocation() + File.separatorChar + LogUtil.getLogFilename(this.$fileAddress) + ')' + ", free bytes = " + GarbageCollector.Companion.formatBytes$xodus_environment(this.this$0.getFileFreeBytes(this.$fileAddress));
            }
            {
                this.this$0 = garbageCollector;
                this.$fileAddress = l;
                super(0);
            }
        }));
        Log log = this.getLog$xodus_environment();
        if (Companion.getLogger().isDebugEnabled()) {
            long high = log.getHighAddress();
            long highFile = log.getHighFileAddress();
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "Cleaner acquired txn when log high address was: %d (%s@%d) when cleaning file %s";
            object = new Object[]{high, LogUtil.getLogFilename(highFile), high - highFile, LogUtil.getLogFilename(fileAddress)};
            KLogger kLogger = Companion.getLogger();
            String string2 = String.format(string, Arrays.copyOf(object, ((Object[])object).length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
            String string3 = string2;
            kLogger.debug(string3);
        }
        try {
            RandomAccessLoggable loggable;
            long nextFileAddress = fileAddress + log.getFileLengthBound();
            LoggableIterator loggables = log.getLoggableIterator(fileAddress);
            while (loggables.hasNext() && (loggable = loggables.next()) != null && loggable.getAddress() < nextFileAddress) {
                int structureId = loggable.getStructureId();
                if (structureId == 0 || structureId == 1) continue;
                StoreImpl store = (StoreImpl)this.openStoresCache.get(structureId);
                if (store == null) {
                    store = txn.openStoreByStructureId(structureId);
                    object = (Map)this.openStoresCache;
                    Integer n = structureId;
                    StoreImpl storeImpl = store;
                    object.put(n, storeImpl);
                }
                store.reclaim(txn, loggable, loggables);
            }
        }
        catch (Throwable e) {
            Companion.getLogger().error("cleanFile(" + LogUtil.getLogFilename(fileAddress) + ")", e);
            throw e;
        }
    }

    @NotNull
    public final EnvironmentImpl getEnvironment$xodus_environment() {
        return this.environment;
    }

    public GarbageCollector(@NotNull EnvironmentImpl environment) {
        Intrinsics.checkParameterIsNotNull((Object)environment, (String)"environment");
        this.environment = environment;
        EnvironmentConfig environmentConfig = this.environment.getEnvironmentConfig();
        Intrinsics.checkExpressionValueIsNotNull((Object)environmentConfig, (String)"environment.environmentConfig");
        this.ec = environmentConfig;
        this.utilizationProfile = new UtilizationProfile(this.environment, this);
        this.pendingFilesToDelete = new PackedLongHashSet(null, 1, null);
        this.deletionQueue = new ConcurrentLinkedQueue();
        this.cleaner = new BackgroundCleaner(this);
        this.newFiles = this.ec.getGcFilesInterval() + 1;
        this.openStoresCache = new IntHashMap();
        this.environment.getLog().addBlockListener(new AbstractBlockListener(){

            @Override
            public void blockCreated(@NotNull Block block, @NotNull DataReader reader, @NotNull DataWriter writer) {
                Intrinsics.checkParameterIsNotNull((Object)block, (String)"block");
                Intrinsics.checkParameterIsNotNull((Object)reader, (String)"reader");
                Intrinsics.checkParameterIsNotNull((Object)writer, (String)"writer");
                int newFiles = newFiles + 1;
                newFiles = newFiles;
                this.getUtilizationProfile().estimateTotalBytes$xodus_environment();
                if (!this.getCleaner$xodus_environment().isCleaning() && newFiles > ec.getGcFilesInterval() && this.isTooMuchFreeSpace$xodus_environment()) {
                    this.wake();
                }
            }
        });
    }

    public static final /* synthetic */ void access$queueDeletionOfFiles(GarbageCollector $this, @NotNull PackedLongHashSet cleanedFiles) {
        $this.queueDeletionOfFiles(cleanedFiles);
    }

    @JvmStatic
    public static final boolean isUtilizationProfile(@NotNull String storeName) {
        return Companion.isUtilizationProfile(storeName);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0004H\u0007J'\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u000f2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0000\u00a2\u0006\u0002\b\u0012J\u001b\u0010\u0013\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u000fH\u0000\u00a2\u0006\u0002\b\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Ljetbrains/exodus/gc/GarbageCollector$Companion;", "Lmu/KLogging;", "()V", "UTILIZATION_PROFILE_STORE_NAME", "", "formatBytes", "bytes", "", "formatBytes$xodus_environment", "isUtilizationProfile", "", "storeName", "loggingError", "", "message", "Lkotlin/Function0;", "t", "", "loggingError$xodus_environment", "loggingInfo", "loggingInfo$xodus_environment", "xodus-environment"})
    public static final class Companion
    extends KLogging {
        @JvmStatic
        public final boolean isUtilizationProfile(@NotNull String storeName) {
            Intrinsics.checkParameterIsNotNull((Object)storeName, (String)"storeName");
            return Intrinsics.areEqual((Object)GarbageCollector.UTILIZATION_PROFILE_STORE_NAME, (Object)storeName);
        }

        public final void loggingInfo$xodus_environment(@NotNull Function0<String> message) {
            Intrinsics.checkParameterIsNotNull(message, (String)"message");
            this.getLogger().info((Function0)new Function0<String>(message){
                final /* synthetic */ Function0 $message;

                @NotNull
                public final String invoke() {
                    return (String)this.$message.invoke();
                }
                {
                    this.$message = function0;
                    super(0);
                }
            });
        }

        public final void loggingError$xodus_environment(@NotNull Function0<String> message, @Nullable Throwable t) {
            Intrinsics.checkParameterIsNotNull(message, (String)"message");
            if (t == null) {
                this.getLogger().error((Function0)new Function0<String>(message){
                    final /* synthetic */ Function0 $message;

                    @NotNull
                    public final String invoke() {
                        return (String)this.$message.invoke();
                    }
                    {
                        this.$message = function0;
                        super(0);
                    }
                });
            } else {
                this.getLogger().error(t, (Function0)new Function0<String>(message){
                    final /* synthetic */ Function0 $message;

                    @NotNull
                    public final String invoke() {
                        return (String)this.$message.invoke();
                    }
                    {
                        this.$message = function0;
                        super(0);
                    }
                });
            }
        }

        public static /* synthetic */ void loggingError$xodus_environment$default(Companion companion, Function0 function0, Throwable throwable, int n, Object object) {
            if ((n & 2) != 0) {
                throwable = null;
            }
            companion.loggingError$xodus_environment((Function0<String>)function0, throwable);
        }

        @NotNull
        public final String formatBytes$xodus_environment(long bytes) {
            return bytes == Long.MAX_VALUE ? "Unknown" : bytes / (long)1000 + "Kb";
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

