/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.io;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.file.OpenOption;
import jetbrains.exodus.ExodusException;
import jetbrains.exodus.OutOfDiskSpaceException;
import jetbrains.exodus.io.AbstractDataWriter;
import jetbrains.exodus.io.Block;
import jetbrains.exodus.io.FileDataReader;
import jetbrains.exodus.io.LockingManager;
import jetbrains.exodus.io.RemoveBlockType;
import jetbrains.exodus.io.SharedMappedFilesCache;
import jetbrains.exodus.io.SharedOpenFilesCache;
import jetbrains.exodus.log.LogUtil;
import jetbrains.exodus.system.JVMConstants;
import jetbrains.exodus.util.SharedRandomAccessFile;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0016\u0018\u0000 ,2\u00020\u0001:\u0001,B\u001b\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0011\u001a\u00020\u0012H\u0014J\b\u0010\u0013\u001a\u00020\u0012H\u0014J\u0010\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\n\u0010\u0017\u001a\u0004\u0018\u00010\u0005H\u0016J\u0018\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u0016H\u0014J\b\u0010\u001b\u001a\u00020\u0010H\u0016J\u0018\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020!H\u0002J\b\u0010\"\u001a\u00020\u0012H\u0016J\b\u0010#\u001a\u00020\u0012H\u0014J\u0018\u0010$\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u0016H\u0016J\b\u0010%\u001a\u00020\u0012H\u0002J \u0010&\u001a\u00020\b2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020*H\u0016R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Ljetbrains/exodus/io/FileDataWriter;", "Ljetbrains/exodus/io/AbstractDataWriter;", "reader", "Ljetbrains/exodus/io/FileDataReader;", "lockId", "", "(Ljetbrains/exodus/io/FileDataReader;Ljava/lang/String;)V", "block", "Ljetbrains/exodus/io/Block;", "dirChannel", "Ljava/nio/channels/FileChannel;", "file", "Ljava/io/RandomAccessFile;", "lockingManager", "Ljetbrains/exodus/io/LockingManager;", "useNio", "", "clearImpl", "", "closeImpl", "lock", "timeout", "", "lockInfo", "openOrCreateBlockImpl", "address", "length", "release", "removeBlock", "blockAddress", "rbt", "Ljetbrains/exodus/io/RemoveBlockType;", "removeFileFromFileCache", "Ljava/io/File;", "syncDirectory", "syncImpl", "truncateBlock", "warnCantFsyncDirectory", "write", "b", "", "off", "", "len", "Companion", "xodus-environment"})
public class FileDataWriter
extends AbstractDataWriter {
    private FileChannel dirChannel;
    private final LockingManager lockingManager;
    private RandomAccessFile file;
    private Block block;
    private boolean useNio;
    private final FileDataReader reader;
    private static final String DELETED_FILE_EXTENSION = ".del";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public Block write(@NotNull byte[] b, int off, int len) {
        Intrinsics.checkParameterIsNotNull((Object)b, (String)"b");
        try {
            RandomAccessFile randomAccessFile = this.file;
            if (randomAccessFile == null) {
                throw (Throwable)new ExodusException("Can't write, FileDataWriter is closed");
            }
            randomAccessFile.write(b, off, len);
        }
        catch (IOException ioe) {
            if (this.lockingManager.getUsableSpace() < (long)len) {
                throw (Throwable)new OutOfDiskSpaceException((Throwable)ioe);
            }
            throw (Throwable)new ExodusException("Can't write", (Throwable)ioe);
        }
        Block block = this.block;
        if (block == null) {
            throw (Throwable)new ExodusException("Can't write, FileDataWriter is closed");
        }
        return block;
    }

    public boolean lock(long timeout) {
        return this.lockingManager.lock(timeout);
    }

    public boolean release() {
        return this.lockingManager.release();
    }

    @Nullable
    public String lockInfo() {
        return this.lockingManager.lockInfo();
    }

    @Override
    protected void syncImpl() {
        block0: {
            RandomAccessFile randomAccessFile;
            RandomAccessFile randomAccessFile2 = this.file;
            if (randomAccessFile2 == null) break block0;
            RandomAccessFile it = randomAccessFile = randomAccessFile2;
            FileDataWriter.Companion.forceSync(it);
        }
    }

    @Override
    protected void closeImpl() {
        try {
            RandomAccessFile randomAccessFile = this.file;
            if (randomAccessFile == null) {
                throw (Throwable)new ExodusException("Can't close already closed FileDataWriter");
            }
            randomAccessFile.close();
            this.file = null;
            FileChannel fileChannel = this.dirChannel;
            if (fileChannel != null) {
                fileChannel.close();
            }
            this.dirChannel = null;
            this.block = null;
        }
        catch (IOException e) {
            throw (Throwable)new ExodusException("Can't close FileDataWriter", (Throwable)e);
        }
    }

    @Override
    protected void clearImpl() {
        for (File file : LogUtil.listFiles(this.reader.getDir())) {
            if (!file.canWrite()) {
                File file2 = file;
                Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"file");
                FileDataWriter.Companion.setWritable(file2);
            }
            if (!file.exists() || file.delete()) continue;
            throw (Throwable)new ExodusException("Failed to delete " + file);
        }
    }

    @Override
    @NotNull
    protected Block openOrCreateBlockImpl(long address, long length) {
        FileDataReader.FileBlock result = new FileDataReader.FileBlock(address, this.reader);
        try {
            RandomAccessFile randomAccessFile;
            FileDataReader.FileBlock fileBlock = result;
            RandomAccessFile randomAccessFile2 = randomAccessFile;
            RandomAccessFile randomAccessFile3 = randomAccessFile;
            FileDataReader.FileBlock $receiver = fileBlock;
            if (!$receiver.canWrite()) {
                FileDataWriter.Companion.setWritable($receiver);
            }
            FileDataReader.FileBlock fileBlock2 = fileBlock;
            randomAccessFile2(fileBlock2, "rw");
            RandomAccessFile f = randomAccessFile3;
            f.seek(length);
            if (length != f.length()) {
                f.setLength(length);
                FileDataWriter.Companion.forceSync(f);
            }
            this.file = f;
            this.block = result;
            return result;
        }
        catch (IOException ioe) {
            throw (Throwable)new ExodusException((Throwable)ioe);
        }
    }

    @Override
    public void syncDirectory() {
        block2: {
            FileChannel fileChannel;
            FileChannel fileChannel2 = this.dirChannel;
            if (fileChannel2 == null) break block2;
            FileChannel $receiver = fileChannel = fileChannel2;
            try {
                $receiver.force(false);
            }
            catch (IOException e) {
                this.warnCantFsyncDirectory();
            }
        }
    }

    public void removeBlock(long blockAddress, @NotNull RemoveBlockType rbt) {
        boolean deleted;
        Intrinsics.checkParameterIsNotNull((Object)rbt, (String)"rbt");
        FileDataReader.FileBlock file = new FileDataReader.FileBlock(blockAddress, this.reader);
        this.removeFileFromFileCache(file);
        FileDataWriter.Companion.setWritable(file);
        boolean bl = deleted = rbt == RemoveBlockType.Delete ? file.delete() : FileDataWriter.Companion.renameFile(file);
        if (!deleted) {
            throw (Throwable)new ExodusException("Failed to delete " + file.getAbsolutePath());
        }
        if (FileDataReader.Companion.getLogger().isInfoEnabled()) {
            FileDataReader.Companion.getLogger().info("Deleted file " + file.getAbsolutePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void truncateBlock(long blockAddress, long length) {
        FileDataReader.FileBlock file = new FileDataReader.FileBlock(blockAddress, this.reader);
        this.removeFileFromFileCache(file);
        FileDataWriter.Companion.setWritable(file);
        try {
            Closeable closeable = (Closeable)new SharedRandomAccessFile((File)file, "rw");
            Throwable throwable = null;
            try {
                SharedRandomAccessFile f = (SharedRandomAccessFile)closeable;
                f.setLength(length);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            if (FileDataReader.Companion.getLogger().isInfoEnabled()) {
                FileDataReader.Companion.getLogger().info("Truncated file " + file.getAbsolutePath() + " to length = " + length);
            }
        }
        catch (IOException e) {
            throw (Throwable)new ExodusException("Failed to truncate file " + file.getAbsolutePath(), (Throwable)e);
        }
    }

    private final void warnCantFsyncDirectory() {
        this.dirChannel = null;
        Companion.getLogger().warn("Can't open directory channel. Log directory fsync won't be performed.");
    }

    private final void removeFileFromFileCache(File file) {
        try {
            SharedOpenFilesCache.getInstance().removeFile(file);
            if (this.useNio) {
                SharedMappedFilesCache.getInstance().removeFileBuffer(file);
            }
        }
        catch (IOException e) {
            throw (Throwable)new ExodusException((Throwable)e);
        }
    }

    @JvmOverloads
    public FileDataWriter(@NotNull FileDataReader reader, @Nullable String lockId) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)reader), (String)"reader");
        this.reader = reader;
        FileChannel channel = null;
        if (!JVMConstants.INSTANCE.getIS_ANDROID()) {
            try {
                channel = FileChannel.open(this.reader.getDir().toPath(), new OpenOption[0]);
                channel.force(false);
            }
            catch (IOException e) {
                channel = null;
                this.warnCantFsyncDirectory();
            }
        }
        this.dirChannel = channel;
        this.lockingManager = new LockingManager(this.reader.getDir(), lockId);
    }

    @JvmOverloads
    public /* synthetic */ FileDataWriter(FileDataReader fileDataReader, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = null;
        }
        this(fileDataReader, string);
    }

    @JvmOverloads
    public FileDataWriter(@NotNull FileDataReader reader) {
        this(reader, null, 2, null);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u000bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Ljetbrains/exodus/io/FileDataWriter$Companion;", "Lmu/KLogging;", "()V", "DELETED_FILE_EXTENSION", "", "forceSync", "", "file", "Ljava/io/RandomAccessFile;", "renameFile", "", "Ljava/io/File;", "setWritable", "xodus-environment"})
    public static final class Companion
    extends KLogging {
        private final boolean renameFile(File file) {
            File file2;
            String name = file.getName();
            String string = file.getParent();
            StringBuilder stringBuilder = new StringBuilder();
            String string2 = name;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"name");
            String string3 = string2;
            int n = 0;
            int n2 = StringsKt.indexOf$default((CharSequence)name, (String)".xd", (int)0, (boolean)false, (int)6, null);
            StringBuilder stringBuilder2 = stringBuilder;
            String string4 = string;
            File file3 = file2;
            File file4 = file2;
            File file5 = file;
            String string5 = string3;
            if (string5 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string6 = string5.substring(n, n2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String string7 = string6;
            file3(string4, stringBuilder2.append(string7).append(FileDataWriter.DELETED_FILE_EXTENSION).toString());
            return file5.renameTo(file4);
        }

        private final void forceSync(RandomAccessFile file) {
            block3: {
                try {
                    FileChannel channel = file.getChannel();
                    channel.force(false);
                }
                catch (ClosedChannelException channel) {
                }
                catch (IOException ioe) {
                    FileChannel fileChannel = file.getChannel();
                    Intrinsics.checkExpressionValueIsNotNull((Object)fileChannel, (String)"file.channel");
                    if (!fileChannel.isOpen()) break block3;
                    throw (Throwable)new ExodusException((Throwable)ioe);
                }
            }
        }

        private final void setWritable(File file) {
            if (file.exists() && !file.setWritable(true)) {
                throw (Throwable)new ExodusException("Failed to set writable " + file.getAbsolutePath());
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

