/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.io;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import jetbrains.exodus.ExodusException;
import jetbrains.exodus.core.dataStructures.ObjectCache;
import jetbrains.exodus.core.dataStructures.ObjectCacheBase;
import jetbrains.exodus.util.SharedRandomAccessFile;
import org.jetbrains.annotations.NotNull;

public final class SharedOpenFilesCache {
    private static final Object syncObject = new Object();
    private static int cacheSize = 0;
    private static volatile SharedOpenFilesCache theCache = null;
    private final ObjectCache<File, SharedRandomAccessFile> cache;

    private SharedOpenFilesCache(int openFiles) {
        this.cache = new ObjectCache(openFiles);
    }

    public static void setSize(int cacheSize) {
        if (cacheSize <= 0) {
            throw new IllegalArgumentException("Cache size must be a positive integer value");
        }
        SharedOpenFilesCache.cacheSize = cacheSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static SharedOpenFilesCache getInstance() {
        if (cacheSize == 0) {
            throw new ExodusException("Size of SharedOpenFilesCache is not set");
        }
        SharedOpenFilesCache result = theCache;
        if (result == null) {
            Object object = syncObject;
            synchronized (object) {
                result = theCache;
                if (result == null) {
                    result = theCache = new SharedOpenFilesCache(cacheSize);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void invalidate() throws IOException {
        SharedOpenFilesCache obsolete;
        Object object = syncObject;
        synchronized (object) {
            obsolete = theCache;
            theCache = null;
        }
        if (obsolete != null) {
            obsolete.clear();
        }
    }

    @NotNull
    SharedRandomAccessFile getCachedFile(@NotNull File file) throws IOException {
        SharedRandomAccessFile result;
        try (ObjectCacheBase.CriticalSection ignored = this.cache.newCriticalSection();){
            result = (SharedRandomAccessFile)this.cache.tryKey((Object)file);
            if (result != null && result.employ() > 1) {
                result.close();
                result = null;
            }
        }
        if (result == null) {
            result = new SharedRandomAccessFile(file, "r");
            SharedRandomAccessFile obsolete = null;
            try (ObjectCacheBase.CriticalSection ignored = this.cache.newCriticalSection();){
                if (this.cache.getObject((Object)file) == null) {
                    result.employ();
                    obsolete = (SharedRandomAccessFile)this.cache.cacheObject((Object)file, (Object)result);
                }
            }
            if (obsolete != null) {
                obsolete.close();
            }
        }
        return result;
    }

    void removeFile(@NotNull File file) throws IOException {
        SharedRandomAccessFile result;
        try (ObjectCacheBase.CriticalSection ignored = this.cache.newCriticalSection();){
            result = (SharedRandomAccessFile)this.cache.remove((Object)file);
        }
        if (result != null) {
            result.close();
        }
    }

    void removeDirectory(@NotNull File dir) throws IOException {
        ArrayList<Object> result = new ArrayList<Object>();
        ArrayList<File> obsoleteFiles = new ArrayList<File>();
        Throwable throwable = null;
        try (ObjectCacheBase.CriticalSection ignored = this.cache.newCriticalSection();){
            Iterator keys = this.cache.keys();
            while (keys.hasNext()) {
                File file = (File)keys.next();
                if (!file.getParentFile().equals(dir)) continue;
                obsoleteFiles.add(file);
                result.add(this.cache.getObject((Object)file));
            }
            for (File file : obsoleteFiles) {
                this.cache.remove((Object)file);
            }
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            throw throwable2;
        }
        for (SharedRandomAccessFile sharedRandomAccessFile : result) {
            sharedRandomAccessFile.close();
        }
    }

    private void clear() throws IOException {
        ArrayList openFiles = new ArrayList();
        try (ObjectCacheBase.CriticalSection ignored = this.cache.newCriticalSection();){
            Iterator it = this.cache.values();
            while (it.hasNext()) {
                openFiles.add(it.next());
            }
            this.cache.clear();
        }
        for (SharedRandomAccessFile file : openFiles) {
            file.close();
        }
    }
}

