/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.log;

import java.io.Closeable;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import jetbrains.exodus.ArrayByteIterable;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.ByteIterator;
import jetbrains.exodus.ExodusException;
import jetbrains.exodus.InvalidSettingException;
import jetbrains.exodus.core.dataStructures.LongArrayList;
import jetbrains.exodus.core.dataStructures.hash.LongIterator;
import jetbrains.exodus.crypto.EnvKryptKt;
import jetbrains.exodus.crypto.StreamCipherProvider;
import jetbrains.exodus.io.Block;
import jetbrains.exodus.io.DataReader;
import jetbrains.exodus.io.DataWriter;
import jetbrains.exodus.io.FileDataReader;
import jetbrains.exodus.io.RemoveBlockType;
import jetbrains.exodus.log.BlockListener;
import jetbrains.exodus.log.BlockNotFoundException;
import jetbrains.exodus.log.BlockSet;
import jetbrains.exodus.log.BufferedDataWriter;
import jetbrains.exodus.log.ByteIteratorWithAddress;
import jetbrains.exodus.log.CompressedUnsignedLongByteIterable;
import jetbrains.exodus.log.DataIterator;
import jetbrains.exodus.log.LogCache;
import jetbrains.exodus.log.LogConfig;
import jetbrains.exodus.log.LogTestConfig;
import jetbrains.exodus.log.LogTip;
import jetbrains.exodus.log.LogUtil;
import jetbrains.exodus.log.Loggable;
import jetbrains.exodus.log.LoggableIterator;
import jetbrains.exodus.log.NullLoggable;
import jetbrains.exodus.log.RandomAccessByteIterable;
import jetbrains.exodus.log.RandomAccessLoggable;
import jetbrains.exodus.log.RandomAccessLoggableAndArrayByteIterable;
import jetbrains.exodus.log.RandomAccessLoggableImpl;
import jetbrains.exodus.log.ReadBytesListener;
import jetbrains.exodus.log.SeparateLogCache;
import jetbrains.exodus.log.SharedLogCache;
import jetbrains.exodus.log.TooBigLoggableException;
import jetbrains.exodus.util.DeferredIO;
import jetbrains.exodus.util.IdGenerator;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u00ee\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0016\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00b0\u00012\u00020\u0001:\u0002\u00b0\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010K\u001a\u00020LJ\u000e\u0010M\u001a\u00020L2\u0006\u0010N\u001a\u00020\u000bJ\u000e\u0010O\u001a\u00020L2\u0006\u0010N\u001a\u00020=J\u0010\u0010P\u001a\u00020\u001b2\u0006\u0010G\u001a\u00020\rH\u0002J\u0006\u0010Q\u001a\u00020-J\u0010\u0010R\u001a\u00020L2\u0006\u0010S\u001a\u00020TH\u0002J\u0006\u0010U\u001a\u00020-J\b\u0010V\u001a\u00020LH\u0016J\u0010\u0010W\u001a\u00020L2\u0006\u0010G\u001a\u00020\rH\u0002J\b\u0010X\u001a\u00020LH\u0002J\u0016\u0010Y\u001a\u00020-2\u0006\u0010Z\u001a\u00020-2\u0006\u0010[\u001a\u00020-J\u0006\u0010\\\u001a\u00020LJ\u0006\u0010]\u001a\u00020-J\u0006\u0010^\u001a\u00020\rJ\u0012\u0010_\u001a\u00020L2\b\b\u0002\u0010`\u001a\u00020.H\u0007J\u0010\u0010a\u001a\u00020L2\u0006\u0010b\u001a\u00020\u001bH\u0007J\u000e\u0010c\u001a\u00020L2\u0006\u0010d\u001a\u00020\u0006J\u000e\u0010e\u001a\u00020f2\u0006\u0010g\u001a\u00020\u001bJ\u000e\u0010h\u001a\u00020\u001b2\u0006\u0010b\u001a\u00020\u001bJ\u001a\u0010i\u001a\u00020\u001b2\u0006\u0010j\u001a\u00020\u001b2\b\b\u0002\u0010Z\u001a\u00020-H\u0007J\u001d\u0010k\u001a\u00020l2\u0006\u0010Z\u001a\u00020-2\b\u0010j\u001a\u0004\u0018\u00010\u001b\u00a2\u0006\u0002\u0010mJ\u0010\u0010n\u001a\u0004\u0018\u00010o2\u0006\u0010p\u001a\u00020\u0015J\u0010\u0010q\u001a\u0004\u0018\u00010f2\u0006\u0010r\u001a\u00020\u001bJ\u000e\u0010s\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020\u001bJ\u0018\u0010t\u001a\u00020\u001b2\u0006\u0010j\u001a\u00020\u001b2\u0006\u0010Z\u001a\u00020-H\u0002J\u0010\u0010u\u001a\u0004\u0018\u00010o2\u0006\u0010p\u001a\u00020\u0015J \u0010v\u001a\u0004\u0018\u00010o2\u0006\u0010p\u001a\u00020\u00152\u0006\u0010w\u001a\u00020\u001b2\u0006\u0010Z\u001a\u00020-J\u000e\u0010x\u001a\u00020y2\u0006\u0010z\u001a\u00020\u001bJ\u000e\u0010{\u001a\u00020\u001b2\u0006\u0010j\u001a\u00020\u001bJ\u0016\u0010|\u001a\u00020}2\u0006\u0010b\u001a\u00020\u001b2\u0006\u0010~\u001a\u00020}J\u000e\u0010\u007f\u001a\u00020.2\u0006\u0010b\u001a\u00020\u001bJ\u0019\u0010\u0080\u0001\u001a\u00020.2\u0007\u0010\u0081\u0001\u001a\u00020\u001b2\u0007\u0010\u0082\u0001\u001a\u00020\u001bJ\u000f\u0010\u0083\u0001\u001a\u00020.2\u0006\u0010j\u001a\u00020\u001bJ\u0017\u0010\u0084\u0001\u001a\u00020.2\u0006\u0010b\u001a\u00020\u001b2\u0006\u0010Z\u001a\u00020-J\u000f\u0010\u0085\u0001\u001a\u00020.2\u0006\u0010b\u001a\u00020\u001bJ\u0011\u0010\u0086\u0001\u001a\u00020L2\u0006\u0010b\u001a\u00020\u001bH\u0002J\u0011\u0010\u0087\u0001\u001a\u00020L2\u0006\u0010b\u001a\u00020\u001bH\u0002J\u001b\u0010\u0088\u0001\u001a\u00020L2\u0007\u0010\u0089\u0001\u001a\u00020f2\u0007\u0010\u008a\u0001\u001a\u00020\u0015H\u0002J\u0007\u0010\u008b\u0001\u001a\u00020LJ\u001e\u0010\u008c\u0001\u001a\u00030\u008d\u00012\b\u0010\u008e\u0001\u001a\u00030\u008f\u00012\b\b\u0002\u0010b\u001a\u00020\u001bH\u0007J$\u0010\u008c\u0001\u001a\u00030\u008d\u00012\u0006\u0010p\u001a\u00020}2\b\u0010\u008e\u0001\u001a\u00030\u008f\u00012\u0006\u0010b\u001a\u00020\u001bH\u0002J\u0010\u0010\u008c\u0001\u001a\u00030\u008d\u00012\u0006\u0010b\u001a\u00020\u001bJ\u0018\u0010\u0090\u0001\u001a\u00020\u00152\u0007\u0010\u0091\u0001\u001a\u00020f2\u0006\u0010b\u001a\u00020\u001bJ\u0010\u0010\u0092\u0001\u001a\u00030\u0093\u00012\u0006\u0010b\u001a\u00020\u001bJ\u001a\u0010\u0094\u0001\u001a\u00030\u008d\u00012\b\u0010\u008e\u0001\u001a\u00030\u008f\u00012\u0006\u0010b\u001a\u00020\u001bJ\u0007\u0010\u0095\u0001\u001a\u00020LJ)\u0010\u0096\u0001\u001a\u00020L2\u0006\u0010b\u001a\u00020\u001b2\n\b\u0002\u0010\u0097\u0001\u001a\u00030\u0098\u00012\n\b\u0002\u0010S\u001a\u0004\u0018\u00010TH\u0007J\u000f\u0010\u0099\u0001\u001a\u00020L2\u0006\u0010Z\u001a\u00020-J\u0017\u0010\u009a\u0001\u001a\u00020-2\u0006\u0010Z\u001a\u00020-2\u0006\u0010\"\u001a\u00020\u001bJ \u0010\u009a\u0001\u001a\u00020-2\u0006\u0010Z\u001a\u00020-2\u0006\u0010\"\u001a\u00020\u001b2\u0007\u0010\u009b\u0001\u001a\u00020TJ\u0013\u0010\u009c\u0001\u001a\u00020L2\b\u0010@\u001a\u0004\u0018\u00010AH\u0007J\u0007\u0010\u009d\u0001\u001a\u00020LJ\u001a\u0010\u009e\u0001\u001a\u00020L2\u0006\u0010b\u001a\u00020\u001b2\u0007\u0010\u009f\u0001\u001a\u00020\u001bH\u0002J\t\u0010\u00a0\u0001\u001a\u00020LH\u0002J\"\u0010\u00a1\u0001\u001a\u00020\u001b2\u0006\u0010p\u001a\u00020}2\u0007\u0010\u00a2\u0001\u001a\u00020\u00152\b\u0010\u00a3\u0001\u001a\u00030\u00a4\u0001J\t\u0010\u00a5\u0001\u001a\u00020LH\u0002J\u0010\u0010\u00a6\u0001\u001a\u00020\u001b2\u0007\u0010\u00a7\u0001\u001a\u00020oJ\"\u0010\u00a6\u0001\u001a\u00020\u001b2\u0006\u0010p\u001a\u00020}2\u0007\u0010\u00a2\u0001\u001a\u00020\u00152\b\u0010\u00a3\u0001\u001a\u00030\u00a4\u0001J\u0010\u0010\u00a8\u0001\u001a\u00020\u001b2\u0007\u0010\u00a7\u0001\u001a\u00020oJ\"\u0010\u00a8\u0001\u001a\u00020\u001b2\u0006\u0010p\u001a\u00020}2\u0007\u0010\u00a2\u0001\u001a\u00020\u00152\b\u0010\u00a3\u0001\u001a\u00030\u00a4\u0001J\u0019\u0010\u00a8\u0001\u001a\u00020\u001b2\u0007\u0010\u00a3\u0001\u001a\u00020f2\u0007\u0010\u008a\u0001\u001a\u00020\u0015JD\u0010\u00a9\u0001\u001a\n\u0012\u0005\u0012\u0003H\u00ab\u00010\u00aa\u0001\"\u0007\b\u0000\u0010\u00ab\u0001\u0018\u0001*\n\u0012\u0005\u0012\u0003H\u00ab\u00010\u00ac\u00012\u0015\u0010\u00ad\u0001\u001a\u0010\u0012\u0005\u0012\u0003H\u00ab\u0001\u0012\u0004\u0012\u00020L0\u00ae\u0001H\u0082\b\u00a2\u0006\u0003\u0010\u00af\u0001R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u00020\u000f8\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u001e\u001a\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u001dR\u0011\u0010 \u001a\u00020\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u001dR\u0011\u0010\"\u001a\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u001dR\u0011\u0010$\u001a\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u001dR$\u0010'\u001a\u00020\u00152\u0006\u0010&\u001a\u00020\u0015@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010\u0017\"\u0004\b)\u0010*R\u0014\u0010+\u001a\b\u0012\u0004\u0012\u00020-0,X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010/\u001a\u00020.2\u0006\u0010&\u001a\u00020.@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u00100\"\u0004\b1\u00102R\u000e\u00103\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u00104\u001a\u0002058F\u00a2\u0006\u0006\u001a\u0004\b6\u00107R\u0011\u00108\u001a\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\b9\u0010\u001dR\u0011\u0010:\u001a\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\b;\u0010\u001dR\u0014\u0010<\u001a\b\u0012\u0004\u0012\u00020=0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010>\u001a\u00020?X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010@\u001a\u0004\u0018\u00010A8\u0002@\u0002X\u0083\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\bB\u0010CR\u0011\u0010D\u001a\u00020-8F\u00a2\u0006\u0006\u001a\u0004\bE\u0010FR\u000e\u0010G\u001a\u00020HX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010I\u001a\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\bJ\u0010\u001d\u00a8\u0006\u00b1\u0001"}, d2={"Ljetbrains/exodus/log/Log;", "Ljava/io/Closeable;", "config", "Ljetbrains/exodus/log/LogConfig;", "(Ljetbrains/exodus/log/LogConfig;)V", "allFileAddresses", "", "getAllFileAddresses", "()[J", "blockListeners", "Ljava/util/ArrayList;", "Ljetbrains/exodus/log/BlockListener;", "bufferedWriter", "Ljetbrains/exodus/log/BufferedDataWriter;", "cache", "Ljetbrains/exodus/log/LogCache;", "cacheHitRate", "", "getCacheHitRate", "()F", "cachePageSize", "", "getCachePageSize", "()I", "getConfig", "()Ljetbrains/exodus/log/LogConfig;", "created", "", "getCreated", "()J", "diskUsage", "getDiskUsage", "fileLengthBound", "getFileLengthBound", "highAddress", "getHighAddress", "highFileAddress", "getHighFileAddress", "<set-?>", "identity", "getIdentity", "setIdentity", "(I)V", "internalTip", "Ljava/util/concurrent/atomic/AtomicReference;", "Ljetbrains/exodus/log/LogTip;", "", "isClosing", "()Z", "setClosing", "(Z)V", "lastSyncTicks", "location", "", "getLocation", "()Ljava/lang/String;", "lowAddress", "getLowAddress", "numberOfFiles", "getNumberOfFiles", "readBytesListeners", "Ljetbrains/exodus/log/ReadBytesListener;", "reader", "Ljetbrains/exodus/io/DataReader;", "testConfig", "Ljetbrains/exodus/log/LogTestConfig;", "testConfig$annotations", "()V", "tip", "getTip", "()Ljetbrains/exodus/log/LogTip;", "writer", "Ljetbrains/exodus/io/DataWriter;", "writtenHighAddress", "getWrittenHighAddress", "abortWrite", "", "addBlockListener", "listener", "addReadBytesListener", "beforeWrite", "beginWrite", "checkLogConsistency", "blockSetMutable", "Ljetbrains/exodus/log/BlockSet$Mutable;", "clear", "close", "closeFullFileIfNecessary", "closeWriter", "compareAndSetTip", "logTip", "updatedTip", "doPadWithNulls", "endWrite", "ensureWriter", "flush", "forceSync", "forgetFile", "address", "forgetFiles", "files", "getCachedPage", "", "pageAddress", "getFileAddress", "getFileSize", "fileAddress", "getFilesFrom", "Ljetbrains/exodus/core/dataStructures/hash/LongIterator;", "(Ljetbrains/exodus/log/LogTip;Ljava/lang/Long;)Ljetbrains/exodus/core/dataStructures/hash/LongIterator;", "getFirstLoggableOfType", "Ljetbrains/exodus/log/Loggable;", "type", "getHighPage", "alignedAddress", "getHighPageAddress", "getLastFileSize", "getLastLoggableOfType", "getLastLoggableOfTypeBefore", "beforeAddress", "getLoggableIterator", "Ljetbrains/exodus/log/LoggableIterator;", "startAddress", "getNextFileAddress", "getWrittenLoggableType", "", "max", "hasAddress", "hasAddressRange", "from", "to", "isImmutableFile", "isLastFileAddress", "isLastWrittenFileAddress", "notifyBlockCreated", "notifyBlockModified", "notifyReadBytes", "bytes", "count", "padWithNulls", "read", "Ljetbrains/exodus/log/RandomAccessLoggable;", "it", "Ljetbrains/exodus/log/ByteIteratorWithAddress;", "readBytes", "output", "readIteratorFrom", "Ljetbrains/exodus/log/DataIterator;", "readNotNull", "release", "removeFile", "rbt", "Ljetbrains/exodus/io/RemoveBlockType;", "revertWrite", "setHighAddress", "blockSet", "setLogTestConfig", "sync", "truncateFile", "length", "tryLock", "tryWrite", "structureId", "data", "Ljetbrains/exodus/ByteIterable;", "updateLogIdentity", "write", "loggable", "writeContinuously", "notifyListeners", "", "T", "", "call", "Lkotlin/Function1;", "(Ljava/util/List;Lkotlin/jvm/functions/Function1;)[Ljava/lang/Object;", "Companion", "xodus-environment"})
public final class Log
implements Closeable {
    private final long created;
    @JvmField
    @NotNull
    public final LogCache cache;
    private volatile boolean isClosing;
    private int identity;
    private final DataReader reader;
    private final DataWriter writer;
    private final AtomicReference<LogTip> internalTip;
    private BufferedDataWriter bufferedWriter;
    private long lastSyncTicks;
    private final ArrayList<BlockListener> blockListeners;
    private final ArrayList<ReadBytesListener> readBytesListeners;
    private final int cachePageSize;
    private final long fileLengthBound;
    private LogTestConfig testConfig;
    @NotNull
    private final LogConfig config;
    private static final IdGenerator identityGenerator;
    private static volatile LogCache sharedCache;
    public static final Companion Companion;

    public final long getCreated() {
        return this.created;
    }

    public final boolean isClosing() {
        return this.isClosing;
    }

    private final void setClosing(boolean bl) {
        this.isClosing = bl;
    }

    public final int getIdentity() {
        return this.identity;
    }

    private final void setIdentity(int n) {
        this.identity = n;
    }

    @NotNull
    public final LogTip getTip() {
        LogTip logTip = this.internalTip.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)logTip, (String)"internalTip.get()");
        return logTip;
    }

    public final int getCachePageSize() {
        return this.cachePageSize;
    }

    public final long getFileLengthBound() {
        return this.fileLengthBound;
    }

    @Deprecated(message="for tests only")
    private static /* synthetic */ void testConfig$annotations() {
    }

    @NotNull
    public final String getLocation() {
        String string = this.reader.getLocation();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"reader.location");
        return string;
    }

    public final long getNumberOfFiles() {
        return this.getTip().blockSet.size();
    }

    @NotNull
    public final long[] getAllFileAddresses() {
        return this.getTip().blockSet.getArray();
    }

    public final long getHighAddress() {
        return this.getTip().highAddress;
    }

    public final long getWrittenHighAddress() {
        return this.ensureWriter().getHighAddress();
    }

    public final long getLowAddress() {
        Long result;
        Long l = result = this.getTip().blockSet.getMinimum();
        return l != null ? l : -1L;
    }

    public final long getHighFileAddress() {
        return this.getFileAddress(this.getHighAddress());
    }

    public final long getDiskUsage() {
        long[] allFiles = this.getTip().getAllFiles();
        int filesCount = allFiles.length;
        return filesCount == 0 ? 0L : (long)(filesCount - 1) * this.fileLengthBound + this.getLastFileSize(allFiles[filesCount - 1], this.getTip());
    }

    public final float getCacheHitRate() {
        return this.cache.hitRate();
    }

    private final void checkLogConsistency(BlockSet.Mutable blockSetMutable) {
        boolean hasNext;
        Iterator blockIterator = this.reader.getBlocks().iterator();
        if (!blockIterator.hasNext()) {
            return;
        }
        if (this.config.isCleanDirectoryExpected()) {
            throw (Throwable)new ExodusException("Clean log is expected");
        }
        do {
            Block block;
            Block block2 = block = (Block)blockIterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)block2, (String)"block");
            long address = block2.getAddress();
            long blockLength = block.length();
            String clearLogReason = null;
            hasNext = blockIterator.hasNext();
            if (blockLength > this.fileLengthBound || hasNext && blockLength != this.fileLengthBound) {
                clearLogReason = "Unexpected file length" + LogUtil.getWrongAddressErrorMessage(address, this.fileLengthBound);
            }
            if (clearLogReason == null && address != this.getFileAddress(address)) {
                if (!this.config.isClearInvalidLog()) {
                    throw (Throwable)new ExodusException("Unexpected file address " + LogUtil.getLogFilename(address) + LogUtil.getWrongAddressErrorMessage(address, this.fileLengthBound));
                }
                clearLogReason = "Unexpected file address " + LogUtil.getLogFilename(address) + LogUtil.getWrongAddressErrorMessage(address, this.fileLengthBound);
            }
            if (clearLogReason != null) {
                if (!this.config.isClearInvalidLog()) {
                    throw (Throwable)new ExodusException(clearLogReason);
                }
                Companion.getLogger().error("Clearing log due to: " + clearLogReason);
                blockSetMutable.clear();
                this.writer.clear();
                break;
            }
            blockSetMutable.add(address, block);
        } while (hasNext);
    }

    @NotNull
    public final LogTip setHighAddress(@NotNull LogTip logTip, long highAddress) {
        Intrinsics.checkParameterIsNotNull((Object)logTip, (String)"logTip");
        return this.setHighAddress(logTip, highAddress, logTip.blockSet.beginWrite());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final LogTip setHighAddress(@NotNull LogTip logTip, long highAddress, @NotNull BlockSet.Mutable blockSet) {
        LogTip updatedTip;
        Intrinsics.checkParameterIsNotNull((Object)logTip, (String)"logTip");
        Intrinsics.checkParameterIsNotNull((Object)blockSet, (String)"blockSet");
        if (highAddress > logTip.highAddress) {
            throw (Throwable)new ExodusException("Only can decrease high address");
        }
        if (highAddress == logTip.highAddress) {
            if (this.bufferedWriter != null) {
                throw (Throwable)new IllegalStateException("Unexpected write in progress");
            }
            return logTip;
        }
        LogTestConfig testConfig = this.testConfig;
        if (testConfig != null && testConfig.isSettingHighAddressDenied()) {
            throw (Throwable)new ExodusException("Setting high address is denied");
        }
        this.closeWriter();
        LongArrayList blocksToDelete = new LongArrayList();
        long blockToTruncate = -1L;
        for (long blockAddress : blockSet.getArray()) {
            if (blockAddress <= highAddress) {
                blockToTruncate = blockAddress;
                break;
            }
            blocksToDelete.add(blockAddress);
        }
        int blockAddress = 0;
        int n = blocksToDelete.size();
        while (blockAddress < n) {
            void i2;
            this.removeFile(blocksToDelete.get((int)i2), RemoveBlockType.Delete, blockSet);
            ++i2;
        }
        if (blockToTruncate >= 0L) {
            this.truncateFile(blockToTruncate, highAddress - blockToTruncate);
        }
        if (blockSet.isEmpty()) {
            this.updateLogIdentity();
            updatedTip = new LogTip(this.fileLengthBound);
        } else {
            long oldHighPageAddress = logTip.pageAddress;
            long approvedHighAddress = logTip.approvedHighAddress;
            if (highAddress < approvedHighAddress) {
                approvedHighAddress = highAddress;
            }
            long highPageAddress = this.getHighPageAddress(highAddress);
            BlockSet.Immutable blockSetImmutable = blockSet.endWrite();
            int highPageSize = (int)(highAddress - highPageAddress);
            if (oldHighPageAddress == highPageAddress) {
                LogTip logTip2 = logTip.withResize(highPageSize, highAddress, approvedHighAddress, blockSetImmutable);
                Intrinsics.checkExpressionValueIsNotNull((Object)logTip2, (String)"logTip.withResize(highPa\u2026dress, blockSetImmutable)");
                updatedTip = logTip2;
            } else {
                this.updateLogIdentity();
                byte[] highPageContent = new byte[this.cachePageSize];
                if (highPageSize > 0 && this.readBytes(highPageContent, highPageAddress) < highPageSize) {
                    throw (Throwable)new ExodusException("Can't read expected high page bytes");
                }
                updatedTip = new LogTip(highPageContent, highPageAddress, highPageSize, highAddress, approvedHighAddress, blockSetImmutable);
            }
        }
        this.compareAndSetTip(logTip, updatedTip);
        this.bufferedWriter = null;
        return updatedTip;
    }

    private final void closeWriter() {
        if (this.bufferedWriter != null) {
            throw (Throwable)new IllegalStateException("Unexpected write in progress");
        }
        this.writer.close();
    }

    @NotNull
    public final LogTip beginWrite() {
        BufferedDataWriter writer;
        this.bufferedWriter = writer = new BufferedDataWriter(this, this.writer, this.getTip());
        LogTip logTip = writer.getStartingTip();
        Intrinsics.checkExpressionValueIsNotNull((Object)logTip, (String)"writer.startingTip");
        return logTip;
    }

    public final void abortWrite() {
        this.bufferedWriter = null;
    }

    public final void revertWrite(@NotNull LogTip logTip) {
        Intrinsics.checkParameterIsNotNull((Object)logTip, (String)"logTip");
        BufferedDataWriter writer = this.ensureWriter();
        BlockSet.Mutable blockSet = writer.getBlockSetMutable();
        this.abortWrite();
        LogTip logTip2 = writer.getUpdatedTip();
        Intrinsics.checkExpressionValueIsNotNull((Object)logTip2, (String)"writer.updatedTip");
        LogTip logTip3 = this.compareAndSetTip(logTip, logTip2);
        long l = logTip.highAddress;
        BlockSet.Mutable mutable = blockSet;
        Intrinsics.checkExpressionValueIsNotNull((Object)mutable, (String)"blockSet");
        this.setHighAddress(logTip3, l, mutable);
    }

    @NotNull
    public final LogTip endWrite() {
        BufferedDataWriter writer = this.ensureWriter();
        LogTip logTip = writer.getStartingTip();
        LogTip updatedTip = writer.getUpdatedTip();
        LogTip logTip2 = logTip;
        Intrinsics.checkExpressionValueIsNotNull((Object)logTip2, (String)"logTip");
        LogTip logTip3 = updatedTip;
        Intrinsics.checkExpressionValueIsNotNull((Object)logTip3, (String)"updatedTip");
        this.compareAndSetTip(logTip2, logTip3);
        this.bufferedWriter = null;
        return updatedTip;
    }

    @NotNull
    public final LogTip compareAndSetTip(@NotNull LogTip logTip, @NotNull LogTip updatedTip) {
        Intrinsics.checkParameterIsNotNull((Object)logTip, (String)"logTip");
        Intrinsics.checkParameterIsNotNull((Object)updatedTip, (String)"updatedTip");
        if (!this.internalTip.compareAndSet(logTip, updatedTip)) {
            throw (Throwable)new ExodusException("write start/finish mismatch");
        }
        return updatedTip;
    }

    public final long getFileAddress(long address) {
        return address - address % this.fileLengthBound;
    }

    public final long getNextFileAddress(long fileAddress) {
        LongIterator files = this.getTip().blockSet.getFilesFrom(fileAddress);
        if (files.hasNext()) {
            long result = files.nextLong();
            if (result != fileAddress) {
                throw (Throwable)new ExodusException("There is no file by address " + fileAddress);
            }
            if (files.hasNext()) {
                return files.nextLong();
            }
        }
        return -1L;
    }

    public final boolean isLastFileAddress(long address, @NotNull LogTip logTip) {
        Intrinsics.checkParameterIsNotNull((Object)logTip, (String)"logTip");
        return this.getFileAddress(address) == this.getFileAddress(logTip.highAddress);
    }

    public final boolean isLastWrittenFileAddress(long address) {
        return this.getFileAddress(address) == this.getFileAddress(this.getWrittenHighAddress());
    }

    public final boolean hasAddress(long address) {
        long fileAddress = this.getFileAddress(address);
        LogTip logTip = this.getTip();
        LongIterator files = logTip.blockSet.getFilesFrom(fileAddress);
        if (!files.hasNext()) {
            return false;
        }
        long leftBound = files.nextLong();
        return leftBound == fileAddress && leftBound + this.getFileSize(leftBound, logTip) > address;
    }

    public final boolean hasAddressRange(long from, long to) {
        long l;
        long fileAddress = this.getFileAddress(from);
        LogTip logTip = this.getTip();
        LongIterator files = logTip.blockSet.getFilesFrom(fileAddress);
        do {
            if (files.hasNext() && files.nextLong() == fileAddress) continue;
            return false;
        } while (from + 1L <= (l = (fileAddress += this.getFileSize(fileAddress, logTip))) && to >= l);
        return true;
    }

    @JvmOverloads
    public final long getFileSize(long fileAddress, @NotNull LogTip logTip) {
        Intrinsics.checkParameterIsNotNull((Object)logTip, (String)"logTip");
        return !this.isLastFileAddress(fileAddress, logTip) ? this.fileLengthBound : this.getLastFileSize(fileAddress, logTip);
    }

    @JvmOverloads
    public static /* synthetic */ long getFileSize$default(Log log, long l, LogTip logTip, int n, Object object) {
        if ((n & 2) != 0) {
            logTip = log.getTip();
        }
        return log.getFileSize(l, logTip);
    }

    @JvmOverloads
    public final long getFileSize(long fileAddress) {
        return Log.getFileSize$default(this, fileAddress, null, 2, null);
    }

    private final long getLastFileSize(long fileAddress, LogTip logTip) {
        long highAddress = logTip.highAddress;
        long result = highAddress % this.fileLengthBound;
        return result == 0L && highAddress != fileAddress ? this.fileLengthBound : result;
    }

    @Nullable
    public final byte[] getHighPage(long alignedAddress) {
        LogTip tip = this.getTip();
        return tip.pageAddress == alignedAddress && tip.count >= 0 ? tip.bytes : null;
    }

    @NotNull
    public final byte[] getCachedPage(long pageAddress) {
        byte[] byArray = this.cache.getPage(this, pageAddress);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"cache.getPage(this, pageAddress)");
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addBlockListener(@NotNull BlockListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        ArrayList<BlockListener> arrayList = this.blockListeners;
        synchronized (arrayList) {
            boolean bl = this.blockListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addReadBytesListener(@NotNull ReadBytesListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        ArrayList<ReadBytesListener> arrayList = this.readBytesListeners;
        synchronized (arrayList) {
            boolean bl = this.readBytesListeners.add(listener);
        }
    }

    @NotNull
    public final RandomAccessLoggable read(long address) {
        return this.read(this.readIteratorFrom(address), address);
    }

    public final byte getWrittenLoggableType(long address, byte max) {
        return this.ensureWriter().getByte(address, max);
    }

    @JvmOverloads
    @NotNull
    public final RandomAccessLoggable read(@NotNull ByteIteratorWithAddress it, long address) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)it), (String)"it");
        byte by = it.next();
        byte by2 = (byte)128;
        byte type = (byte)(by ^ by2);
        return NullLoggable.isNullLoggable(type) ? (RandomAccessLoggable)new NullLoggable(address) : this.read(type, it, address);
    }

    @JvmOverloads
    @NotNull
    public static /* synthetic */ RandomAccessLoggable read$default(Log log, ByteIteratorWithAddress byteIteratorWithAddress, long l, int n, Object object) {
        if ((n & 2) != 0) {
            l = byteIteratorWithAddress.getAddress();
        }
        return log.read(byteIteratorWithAddress, l);
    }

    @JvmOverloads
    @NotNull
    public final RandomAccessLoggable read(@NotNull ByteIteratorWithAddress it) {
        return Log.read$default(this, it, 0L, 2, null);
    }

    @NotNull
    public final RandomAccessLoggable readNotNull(@NotNull ByteIteratorWithAddress it, long address) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)it), (String)"it");
        byte by = it.next();
        byte by2 = (byte)128;
        Log log = this;
        byte by3 = (byte)(by ^ by2);
        return log.read(by3, it, address);
    }

    private final RandomAccessLoggable read(byte type, ByteIteratorWithAddress it, long address) {
        int structureId = CompressedUnsignedLongByteIterable.getInt(it);
        int dataLength = CompressedUnsignedLongByteIterable.getInt(it);
        long dataAddress = it.getAddress();
        if (dataLength > 0 && it.availableInCurrentPage(dataLength)) {
            return new RandomAccessLoggableAndArrayByteIterable(address, type, structureId, dataAddress, it.getCurrentPage(), it.getOffset(), dataLength);
        }
        RandomAccessByteIterable data = new RandomAccessByteIterable(dataAddress, this);
        return new RandomAccessLoggableImpl(address, type, data, dataLength, structureId);
    }

    @NotNull
    public final LoggableIterator getLoggableIterator(long startAddress) {
        return new LoggableIterator(this, startAddress);
    }

    public final long tryWrite(byte type, int structureId, @NotNull ByteIterable data) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        long result = this.writeContinuously(type, structureId, data);
        if (result < 0L) {
            this.doPadWithNulls();
        }
        return result;
    }

    public final long write(@NotNull Loggable loggable) {
        Intrinsics.checkParameterIsNotNull((Object)loggable, (String)"loggable");
        byte by = loggable.getType();
        int n = loggable.getStructureId();
        ByteIterable byteIterable = loggable.getData();
        Intrinsics.checkExpressionValueIsNotNull((Object)byteIterable, (String)"loggable.data");
        return this.write(by, n, byteIterable);
    }

    public final long write(byte type, int structureId, @NotNull ByteIterable data) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        long result = this.writeContinuously(type, structureId, data);
        if (result < 0L) {
            this.doPadWithNulls();
            result = this.writeContinuously(type, structureId, data);
            if (result < 0L) {
                throw (Throwable)((Object)new TooBigLoggableException());
            }
        }
        return result;
    }

    @Nullable
    public final Loggable getFirstLoggableOfType(int type) {
        LogTip logTip = this.getTip();
        LongIterator files = logTip.blockSet.getFilesFrom(0L);
        long approvedHighAddress = logTip.approvedHighAddress;
        block0: while (files.hasNext()) {
            RandomAccessLoggable loggable;
            long fileAddress = files.nextLong();
            LoggableIterator it = this.getLoggableIterator(fileAddress);
            while (it.hasNext() && (loggable = it.next()) != null && loggable.getAddress() < fileAddress + this.fileLengthBound) {
                if (loggable.getType() == type) {
                    return loggable;
                }
                if (loggable.getAddress() + (long)loggable.length() != approvedHighAddress) continue;
                continue block0;
            }
        }
        return null;
    }

    @Nullable
    public final Loggable getLastLoggableOfType(int type) {
        Loggable result = null;
        LogTip logTip = this.getTip();
        long approvedHighAddress = logTip.approvedHighAddress;
        block0: for (long fileAddress : logTip.blockSet.getArray()) {
            RandomAccessLoggable loggable;
            if (result != null) break;
            LoggableIterator it = this.getLoggableIterator(fileAddress);
            while (it.hasNext() && (loggable = it.next()) != null && loggable.getAddress() < fileAddress + this.fileLengthBound) {
                if (loggable.getType() == type) {
                    result = loggable;
                }
                if (loggable.getAddress() + (long)loggable.length() != approvedHighAddress) continue;
                continue block0;
            }
        }
        return result;
    }

    @Nullable
    public final Loggable getLastLoggableOfTypeBefore(int type, long beforeAddress, @NotNull LogTip logTip) {
        Intrinsics.checkParameterIsNotNull((Object)logTip, (String)"logTip");
        Loggable result = null;
        block0: for (long fileAddress : logTip.blockSet.getArray()) {
            if (result != null) break;
            if (fileAddress >= beforeAddress) continue;
            LoggableIterator it = this.getLoggableIterator(fileAddress);
            while (it.hasNext()) {
                RandomAccessLoggable loggable;
                if (it.next() == null) {
                    continue block0;
                }
                long address = loggable.getAddress();
                if (address >= beforeAddress || address >= fileAddress + this.fileLengthBound) continue block0;
                if (loggable.getType() != type) continue;
                result = loggable;
            }
        }
        return result;
    }

    public final boolean isImmutableFile(long fileAddress) {
        return fileAddress + this.fileLengthBound <= this.getTip().approvedHighAddress;
    }

    @JvmOverloads
    public final void flush(boolean forceSync) {
        this.ensureWriter().flush();
        if (forceSync || this.config.isDurableWrite()) {
            this.sync();
        }
    }

    @JvmOverloads
    public static /* synthetic */ void flush$default(Log log, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        log.flush(bl);
    }

    @JvmOverloads
    public final void flush() {
        Log.flush$default(this, false, 1, null);
    }

    public final void sync() {
        this.writer.sync();
        this.lastSyncTicks = System.currentTimeMillis();
    }

    @Override
    public void close() {
        LogTip logTip = this.getTip();
        this.isClosing = true;
        this.sync();
        this.reader.close();
        this.closeWriter();
        this.compareAndSetTip(logTip, new LogTip(this.fileLengthBound, logTip.pageAddress, logTip.highAddress));
        this.release();
    }

    public final void release() {
        this.writer.release();
    }

    @NotNull
    public final LogTip clear() {
        LogTip logTip = this.getTip();
        this.cache.clear();
        this.reader.close();
        this.closeWriter();
        this.writer.clear();
        LogTip updatedTip = new LogTip(this.fileLengthBound);
        this.compareAndSetTip(logTip, updatedTip);
        this.bufferedWriter = null;
        this.updateLogIdentity();
        return updatedTip;
    }

    @Deprecated(message="for tests only")
    public final void forgetFile(long address) {
        this.beginWrite();
        this.forgetFiles(new long[]{address});
        this.endWrite();
    }

    public final void forgetFiles(@NotNull long[] files) {
        Intrinsics.checkParameterIsNotNull((Object)files, (String)"files");
        BlockSet.Mutable blockSetMutable = this.ensureWriter().getBlockSetMutable();
        for (long file : files) {
            blockSetMutable.remove(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmOverloads
    public final void removeFile(long address, @NotNull RemoveBlockType rbt, @Nullable BlockSet.Mutable blockSetMutable) {
        BlockListener[] listeners$iv;
        BlockListener[] blockListenerArray;
        BlockListener[] $receiver$iv$iv;
        BlockListener[] $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)rbt, (String)"rbt");
        Block block = this.getTip().blockSet.getBlock(address);
        List list = this.blockListeners;
        Log this_$iv = this;
        synchronized ($receiver$iv) {
            $receiver$iv$iv = $receiver$iv;
            if ($receiver$iv$iv == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
            }
            BlockListener[] thisCollection$iv$iv = $receiver$iv$iv;
            BlockListener[] blockListenerArray2 = thisCollection$iv$iv.toArray(new BlockListener[0]);
            if (blockListenerArray2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            blockListenerArray = blockListenerArray2;
        }
        blockListenerArray = $receiver$iv$iv = (listeners$iv = blockListenerArray);
        int $i$f$toTypedArray = blockListenerArray.length;
        for (int $i$a$1$synchronized = 0; $i$a$1$synchronized < $i$f$toTypedArray; ++$i$a$1$synchronized) {
            BlockListener element$iv$iv;
            BlockListener it$iv;
            BlockListener it = it$iv = (element$iv$iv = blockListenerArray[$i$a$1$synchronized]);
            it.beforeBlockDeleted(block, this.reader, this.writer);
        }
        BlockListener[] listeners = listeners$iv;
        try {
            this.writer.removeBlock(address, rbt);
            BlockSet.Mutable mutable = blockSetMutable;
            if (mutable != null) {
                mutable.remove(address);
            }
            for (long offset = 0L; offset < this.fileLengthBound; offset += (long)this.cachePageSize) {
                this.cache.removePage(this, address + offset);
            }
        }
        finally {
            BlockListener[] $receiver$iv2;
            $receiver$iv = $receiver$iv2 = listeners;
            int n = $receiver$iv.length;
            for (int j = 0; j < n; ++j) {
                BlockListener element$iv;
                BlockListener it = element$iv = $receiver$iv[j];
                it.afterBlockDeleted(address, this.reader, this.writer);
            }
        }
    }

    @JvmOverloads
    public static /* synthetic */ void removeFile$default(Log log, long l, RemoveBlockType removeBlockType, BlockSet.Mutable mutable, int n, Object object) {
        if ((n & 2) != 0) {
            removeBlockType = RemoveBlockType.Delete;
        }
        if ((n & 4) != 0) {
            mutable = null;
        }
        log.removeFile(l, removeBlockType, mutable);
    }

    @JvmOverloads
    public final void removeFile(long address, @NotNull RemoveBlockType rbt) {
        Log.removeFile$default(this, address, rbt, null, 4, null);
    }

    @JvmOverloads
    public final void removeFile(long address) {
        Log.removeFile$default(this, address, null, null, 6, null);
    }

    @NotNull
    public final BufferedDataWriter ensureWriter() {
        BufferedDataWriter bufferedDataWriter = this.bufferedWriter;
        if (bufferedDataWriter == null) {
            throw (Throwable)new ExodusException("write not in progress");
        }
        return bufferedDataWriter;
    }

    private final void truncateFile(long address, long length) {
        this.writer.truncateBlock(address, length);
        this.writer.openOrCreateBlock(address, length);
        for (long offset = length - length % (long)this.cachePageSize; offset < this.fileLengthBound; offset += (long)this.cachePageSize) {
            this.cache.removePage(this, address + offset);
        }
    }

    public final void padWithNulls() {
        this.beforeWrite(this.ensureWriter());
        this.doPadWithNulls();
    }

    public final void doPadWithNulls() {
        byte[] cachedTailPage;
        BufferedDataWriter writer = this.ensureWriter();
        long bytesToWrite = this.fileLengthBound - writer.getLastWrittenFileLength(this.fileLengthBound);
        if (bytesToWrite == 0L) {
            throw (Throwable)new ExodusException("Nothing to pad");
        }
        if (bytesToWrite >= (long)this.cachePageSize && (cachedTailPage = LogCache.getCachedTailPage(this.cachePageSize)) != null) {
            do {
                writer.write(cachedTailPage, this.cachePageSize);
                writer.incHighAddress(this.cachePageSize);
            } while ((bytesToWrite -= (long)this.cachePageSize) >= (long)this.cachePageSize);
        }
        if (bytesToWrite == 0L) {
            writer.commit();
            this.closeFullFileIfNecessary(writer);
        } else {
            while (true) {
                long l = bytesToWrite;
                bytesToWrite = l + -1L;
                if (l <= 0L) break;
                NullLoggable nullLoggable = NullLoggable.create();
                Intrinsics.checkExpressionValueIsNotNull((Object)nullLoggable, (String)"NullLoggable.create()");
                this.writeContinuously(nullLoggable);
            }
        }
    }

    public final int readBytes(@NotNull byte[] output, long address) {
        Intrinsics.checkParameterIsNotNull((Object)output, (String)"output");
        long fileAddress = this.getFileAddress(address);
        LogTip logTip = this.getTip();
        LongIterator files = logTip.blockSet.getFilesFrom(fileAddress);
        if (files.hasNext()) {
            long leftBound = files.nextLong();
            long fileSize = this.getFileSize(leftBound, logTip);
            if (leftBound == fileAddress && fileAddress + fileSize > address) {
                Block block = logTip.blockSet.getBlock(fileAddress);
                int readBytes = block.read(output, address - fileAddress, 0, output.length);
                StreamCipherProvider cipherProvider = this.config.getCipherProvider();
                if (cipherProvider != null) {
                    byte[] byArray = this.config.getCipherKey();
                    Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"config.cipherKey");
                    EnvKryptKt.cryptBlocksMutable(cipherProvider, byArray, this.config.getCipherBasicIV(), address, output, 0, readBytes, 1024);
                }
                this.notifyReadBytes(output, readBytes);
                return readBytes;
            }
            Long l = logTip.blockSet.getMinimum();
            if (fileAddress < (l != null ? l : -1L)) {
                BlockNotFoundException.raise("Address is out of log space, underflow", this, address);
            }
            Long l2 = logTip.blockSet.getMaximum();
            if (fileAddress >= (l2 != null ? l2 : -1L)) {
                BlockNotFoundException.raise("Address is out of log space, overflow", this, address);
            }
        }
        BlockNotFoundException.raise(this, address);
        return 0;
    }

    @NotNull
    public final DataIterator readIteratorFrom(long address) {
        return new DataIterator(this, address);
    }

    private final void tryLock() {
        long lockTimeout;
        if (!this.config.isLockIgnored() && !this.writer.lock(lockTimeout = this.config.getLockTimeout())) {
            throw (Throwable)new ExodusException("Can't acquire environment lock after " + lockTimeout + " ms.\n\n Lock owner info: \n" + this.writer.lockInfo());
        }
    }

    public final long getHighPageAddress(long highAddress) {
        int alignment = (int)highAddress & this.cachePageSize - 1;
        if (alignment == 0 && highAddress > 0L) {
            alignment = this.cachePageSize;
        }
        return highAddress - (long)alignment;
    }

    @NotNull
    public final LongIterator getFilesFrom(@NotNull LogTip logTip, @Nullable Long fileAddress) {
        Intrinsics.checkParameterIsNotNull((Object)logTip, (String)"logTip");
        BlockSet.Immutable immutable = logTip.blockSet;
        Long l = fileAddress;
        if (l == null) {
            Intrinsics.throwNpe();
        }
        return immutable.getFilesFrom(l);
    }

    public final long writeContinuously(@NotNull Loggable loggable) {
        Intrinsics.checkParameterIsNotNull((Object)loggable, (String)"loggable");
        byte by = loggable.getType();
        int n = loggable.getStructureId();
        ByteIterable byteIterable = loggable.getData();
        Intrinsics.checkExpressionValueIsNotNull((Object)byteIterable, (String)"loggable.data");
        return this.writeContinuously(by, n, byteIterable);
    }

    public final long writeContinuously(byte type, int structureId, @NotNull ByteIterable data) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        BufferedDataWriter writer = this.ensureWriter();
        long result = this.beforeWrite(writer);
        boolean isNull = NullLoggable.isNullLoggable(type);
        int recordLength = 1;
        if (isNull) {
            byte by = type;
            byte by2 = (byte)128;
            BufferedDataWriter bufferedDataWriter = writer;
            byte by3 = (byte)(by ^ by2);
            bufferedDataWriter.write(by3);
        } else {
            ByteIterable structureIdIterable = CompressedUnsignedLongByteIterable.getIterable(structureId);
            int dataLength = data.getLength();
            ByteIterable dataLengthIterable = CompressedUnsignedLongByteIterable.getIterable(dataLength);
            ByteIterable byteIterable = structureIdIterable;
            Intrinsics.checkExpressionValueIsNotNull((Object)byteIterable, (String)"structureIdIterable");
            recordLength += byteIterable.getLength();
            ByteIterable byteIterable2 = dataLengthIterable;
            Intrinsics.checkExpressionValueIsNotNull((Object)byteIterable2, (String)"dataLengthIterable");
            recordLength += byteIterable2.getLength();
            if ((long)(recordLength += dataLength) > this.fileLengthBound - writer.getLastWrittenFileLength(this.fileLengthBound)) {
                return -1L;
            }
            byte by = type;
            byte by4 = (byte)128;
            BufferedDataWriter bufferedDataWriter = writer;
            byte by5 = (byte)(by ^ by4);
            bufferedDataWriter.write(by5);
            Log.Companion.writeByteIterable(writer, structureIdIterable);
            Log.Companion.writeByteIterable(writer, dataLengthIterable);
            if (dataLength > 0) {
                Log.Companion.writeByteIterable(writer, data);
            }
        }
        writer.commit();
        writer.incHighAddress(recordLength);
        this.closeFullFileIfNecessary(writer);
        return result;
    }

    public final long writeContinuously(@NotNull byte[] data, int count) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        BufferedDataWriter writer = this.ensureWriter();
        long result = this.beforeWrite(writer);
        if ((long)count > this.fileLengthBound - writer.getLastWrittenFileLength(this.fileLengthBound)) {
            return -1L;
        }
        BufferedDataWriter $receiver = writer;
        $receiver.write(data, count);
        $receiver.commit();
        $receiver.incHighAddress(count);
        this.closeFullFileIfNecessary($receiver);
        return result;
    }

    private final long beforeWrite(BufferedDataWriter writer) {
        long maxHighAddress;
        long l;
        long result = writer.getHighAddress();
        LogTestConfig testConfig = this.testConfig;
        if (testConfig != null && 0L <= (l = (maxHighAddress = testConfig.getMaxHighAddress())) && result >= l) {
            throw (Throwable)new ExodusException("Can't write more than " + maxHighAddress);
        }
        if (!this.writer.isOpen()) {
            boolean fileCreated;
            long fileAddress = this.getFileAddress(result);
            Block block = writer.openOrCreateBlock(fileAddress, writer.getLastWrittenFileLength(this.fileLengthBound));
            boolean bl = fileCreated = !writer.getBlockSetMutable().contains(fileAddress);
            if (fileCreated) {
                BlockSet.Mutable mutable = writer.getBlockSetMutable();
                Block block2 = block;
                Intrinsics.checkExpressionValueIsNotNull((Object)block2, (String)"block");
                mutable.add(fileAddress, block2);
                this.writer.syncDirectory();
                this.notifyBlockCreated(fileAddress);
            } else {
                this.notifyBlockModified(fileAddress);
            }
        }
        return result;
    }

    private final void closeFullFileIfNecessary(BufferedDataWriter writer) {
        boolean shouldCreateNewFile;
        boolean bl = shouldCreateNewFile = writer.getLastWrittenFileLength(this.fileLengthBound) == 0L;
        if (shouldCreateNewFile) {
            this.flush(true);
            this.writer.close();
            BlockSet.Mutable blockSet = writer.getBlockSetMutable();
            Long lastFile = blockSet.getMaximum();
            if (lastFile != null) {
                long length;
                Block refreshed;
                Block block = blockSet.getBlock(lastFile);
                if (block != (refreshed = block.refresh())) {
                    long l = lastFile;
                    Block block2 = refreshed;
                    Intrinsics.checkExpressionValueIsNotNull((Object)block2, (String)"refreshed");
                    blockSet.add(l, block2);
                }
                if ((length = refreshed.length()) < this.fileLengthBound) {
                    throw (Throwable)new IllegalStateException("File's too short (" + LogUtil.getLogFilename(lastFile) + "), block.length() = " + length + ", fileLengthBound = " + this.fileLengthBound);
                }
                if (this.config.isFullFileReadonly() && block instanceof File) {
                    ((File)block).setReadOnly();
                }
            }
        } else if (System.currentTimeMillis() > this.lastSyncTicks + this.config.getSyncPeriod()) {
            this.flush(true);
        }
    }

    @Deprecated(message="for tests only")
    public final void setLogTestConfig(@Nullable LogTestConfig testConfig) {
        this.testConfig = testConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void notifyBlockCreated(long address) {
        BlockListener[] listeners$iv;
        BlockListener[] blockListenerArray;
        BlockListener[] $receiver$iv$iv;
        void $receiver$iv;
        Block block = this.getTip().blockSet.getBlock(address);
        List list = this.blockListeners;
        Log this_$iv = this;
        synchronized ($receiver$iv) {
            $receiver$iv$iv = (BlockListener[])$receiver$iv;
            if ($receiver$iv$iv == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
            }
            BlockListener[] thisCollection$iv$iv = $receiver$iv$iv;
            BlockListener[] blockListenerArray2 = thisCollection$iv$iv.toArray(new BlockListener[0]);
            if (blockListenerArray2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            blockListenerArray = blockListenerArray2;
        }
        blockListenerArray = $receiver$iv$iv = (listeners$iv = blockListenerArray);
        int n = blockListenerArray.length;
        for (int j = 0; j < n; ++j) {
            BlockListener element$iv$iv;
            BlockListener it$iv;
            BlockListener it = it$iv = (element$iv$iv = blockListenerArray[j]);
            it.blockCreated(block, this.reader, this.writer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void notifyBlockModified(long address) {
        BlockListener[] listeners$iv;
        BlockListener[] blockListenerArray;
        BlockListener[] $receiver$iv$iv;
        void $receiver$iv;
        Block block = this.getTip().blockSet.getBlock(address);
        List list = this.blockListeners;
        Log this_$iv = this;
        synchronized ($receiver$iv) {
            $receiver$iv$iv = (BlockListener[])$receiver$iv;
            if ($receiver$iv$iv == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
            }
            BlockListener[] thisCollection$iv$iv = $receiver$iv$iv;
            BlockListener[] blockListenerArray2 = thisCollection$iv$iv.toArray(new BlockListener[0]);
            if (blockListenerArray2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            blockListenerArray = blockListenerArray2;
        }
        blockListenerArray = $receiver$iv$iv = (listeners$iv = blockListenerArray);
        int n = blockListenerArray.length;
        for (int j = 0; j < n; ++j) {
            BlockListener element$iv$iv;
            BlockListener it$iv;
            BlockListener it = it$iv = (element$iv$iv = blockListenerArray[j]);
            it.blockModified(block, this.reader, this.writer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void notifyReadBytes(byte[] bytes, int count) {
        ReadBytesListener[] listeners$iv;
        ReadBytesListener[] readBytesListenerArray;
        ReadBytesListener[] $receiver$iv$iv;
        void $receiver$iv;
        List list = this.readBytesListeners;
        Log this_$iv = this;
        synchronized ($receiver$iv) {
            $receiver$iv$iv = (ReadBytesListener[])$receiver$iv;
            if ($receiver$iv$iv == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
            }
            ReadBytesListener[] thisCollection$iv$iv = $receiver$iv$iv;
            ReadBytesListener[] readBytesListenerArray2 = thisCollection$iv$iv.toArray(new ReadBytesListener[0]);
            if (readBytesListenerArray2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            readBytesListenerArray = readBytesListenerArray2;
        }
        readBytesListenerArray = $receiver$iv$iv = (listeners$iv = readBytesListenerArray);
        int n = readBytesListenerArray.length;
        for (int j = 0; j < n; ++j) {
            ReadBytesListener element$iv$iv;
            ReadBytesListener it$iv;
            ReadBytesListener it = it$iv = (element$iv$iv = readBytesListenerArray[j]);
            it.bytesRead(bytes, count);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T> T[] notifyListeners(@NotNull List<? extends T> $receiver, Function1<? super T, Unit> call) {
        synchronized ($receiver) {
            Object[] listeners;
            Object[] objectArray;
            Object[] $receiver$iv;
            try {
                $receiver$iv = (Object[])$receiver;
                if ($receiver$iv == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
                }
                Object[] thisCollection$iv = $receiver$iv;
                Intrinsics.reifiedOperationMarker((int)0, (String)"T?");
                Object[] objectArray2 = thisCollection$iv.toArray(new Object[0]);
                if (objectArray2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                objectArray = objectArray2;
            }
            finally {
                InlineMarker.finallyStart((int)1);
                // MONITOREXIT @DISABLED, blocks:[1, 3] lbl16 : MonitorExitStatement: MONITOREXIT : $receiver
                InlineMarker.finallyEnd((int)1);
            }
            objectArray = $receiver$iv = (listeners = objectArray);
            int n = objectArray.length;
            for (int j = 0; j < n; ++j) {
                Object element$iv;
                Object it = element$iv = objectArray[j];
                call.invoke(it);
            }
            return listeners;
        }
    }

    private final void updateLogIdentity() {
        this.identity = identityGenerator.nextId();
    }

    @NotNull
    public final LogConfig getConfig() {
        return this.config;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Log(@NotNull LogConfig config) {
        LogCache logCache;
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        this.config = config;
        this.created = System.currentTimeMillis();
        DataReader dataReader = this.config.getReader();
        Intrinsics.checkExpressionValueIsNotNull((Object)dataReader, (String)"config.reader");
        this.reader = dataReader;
        DataWriter dataWriter = this.config.getWriter();
        Intrinsics.checkExpressionValueIsNotNull((Object)dataWriter, (String)"config.writer");
        this.writer = dataWriter;
        this.blockListeners = new ArrayList(2);
        this.readBytesListeners = new ArrayList(2);
        this.cachePageSize = this.config.getCachePageSize();
        this.tryLock();
        long fileLength = this.config.getFileSize() * 1024L;
        if (fileLength % (long)this.cachePageSize != 0L) {
            throw (Throwable)new InvalidSettingException("File size should be a multiple of cache page size.");
        }
        this.fileLengthBound = fileLength;
        BlockSet.Mutable blockSetMutable = new BlockSet.Immutable(fileLength, null, 2, null).beginWrite();
        if (this.reader instanceof FileDataReader) {
            ((FileDataReader)this.reader).setLog(this);
        }
        this.checkLogConsistency(blockSetMutable);
        BlockSet.Immutable blockSetImmutable = blockSetMutable.endWrite();
        long memoryUsage = this.config.getMemoryUsage();
        boolean nonBlockingCache = this.config.isNonBlockingCache();
        int generationCount = this.config.getCacheGenerationCount();
        if (memoryUsage != 0L) {
            logCache = this.config.isSharedCache() ? Log.Companion.getSharedCache(memoryUsage, this.cachePageSize, nonBlockingCache, generationCount) : (LogCache)new SeparateLogCache(memoryUsage, this.cachePageSize, nonBlockingCache, generationCount);
        } else {
            int memoryUsagePercentage = this.config.getMemoryUsagePercentage();
            logCache = this.config.isSharedCache() ? Log.Companion.getSharedCache(memoryUsagePercentage, this.cachePageSize, nonBlockingCache, generationCount) : (LogCache)new SeparateLogCache(memoryUsagePercentage, this.cachePageSize, nonBlockingCache, generationCount);
        }
        this.cache = logCache;
        DeferredIO.getJobProcessor();
        this.isClosing = false;
        Long lastFileAddress = blockSetMutable.getMaximum();
        this.updateLogIdentity();
        if (lastFileAddress == null) {
            this.internalTip = new AtomicReference<LogTip>(new LogTip(this.fileLengthBound));
        } else {
            long currentHighAddress = lastFileAddress + blockSetMutable.getBlock(lastFileAddress).length();
            long highPageAddress = this.getHighPageAddress(currentHighAddress);
            byte[] highPageContent = new byte[this.cachePageSize];
            LogTip tmpTip = new LogTip(highPageContent, highPageAddress, this.cachePageSize, currentHighAddress, currentHighAddress, blockSetImmutable);
            this.internalTip = new AtomicReference<LogTip>(tmpTip);
            int highPageSize = currentHighAddress == 0L ? 0 : this.readBytes(highPageContent, highPageAddress);
            LogTip proposedTip = new LogTip(highPageContent, highPageAddress, highPageSize, currentHighAddress, currentHighAddress, blockSetImmutable);
            this.internalTip.set(proposedTip);
            LoggableIterator lastFileLoggables = new LoggableIterator(this, lastFileAddress);
            long approvedHighAddress = lastFileAddress;
            try {
                while (lastFileLoggables.hasNext()) {
                    int dataLength;
                    int n;
                    RandomAccessLoggable loggable = lastFileLoggables.next();
                    if (NullLoggable.isNullLoggable(loggable)) {
                        n = 0;
                    } else {
                        RandomAccessLoggable randomAccessLoggable = loggable;
                        Intrinsics.checkExpressionValueIsNotNull((Object)randomAccessLoggable, (String)"loggable");
                        n = dataLength = randomAccessLoggable.getDataLength();
                    }
                    if (dataLength > 0) {
                        RandomAccessLoggable randomAccessLoggable = loggable;
                        Intrinsics.checkExpressionValueIsNotNull((Object)randomAccessLoggable, (String)"loggable");
                        ByteIteratorWithAddress data = randomAccessLoggable.getData().iterator();
                        int n2 = 0;
                        int n3 = dataLength;
                        while (n2 < n3) {
                            void i2;
                            if (!data.hasNext()) {
                                StringBuilder stringBuilder = new StringBuilder().append("Can't read loggable fully");
                                ByteIteratorWithAddress byteIteratorWithAddress = data;
                                Intrinsics.checkExpressionValueIsNotNull((Object)((Object)byteIteratorWithAddress), (String)"data");
                                throw (Throwable)new ExodusException(stringBuilder.append(LogUtil.getWrongAddressErrorMessage(byteIteratorWithAddress.getAddress(), this.fileLengthBound)).toString());
                            }
                            data.next();
                            ++i2;
                        }
                    } else if (dataLength < 0) break;
                    RandomAccessLoggable randomAccessLoggable = loggable;
                    Intrinsics.checkExpressionValueIsNotNull((Object)randomAccessLoggable, (String)"loggable");
                    long approvedHighAddressCandidate = randomAccessLoggable.getAddress() + (long)loggable.length();
                    if (approvedHighAddressCandidate <= currentHighAddress) {
                        approvedHighAddress = approvedHighAddressCandidate;
                        continue;
                    }
                    break;
                }
            }
            catch (ExodusException e) {
                Companion.getLogger().error("Exception on Log recovery. Approved high address = " + approvedHighAddress, (Throwable)e);
            }
            this.internalTip.set(proposedTip.withApprovedAddress(approvedHighAddress));
        }
        this.sync();
    }

    static {
        Companion = new Companion(null);
        identityGenerator = new IdGenerator();
    }

    @JvmStatic
    public static final void invalidateSharedCache() {
        Companion.invalidateSharedCache();
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006H\u0002J(\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\nH\u0002J(\u0010\f\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\nH\u0002J\b\u0010\u0013\u001a\u00020\bH\u0007J\u0018\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Ljetbrains/exodus/log/Log$Companion;", "Lmu/KLogging;", "()V", "identityGenerator", "Ljetbrains/exodus/util/IdGenerator;", "sharedCache", "Ljetbrains/exodus/log/LogCache;", "checkCachePageSize", "", "pageSize", "", "result", "getSharedCache", "memoryUsagePercentage", "nonBlocking", "", "cacheGenerationCount", "memoryUsage", "", "invalidateSharedCache", "writeByteIterable", "writer", "Ljetbrains/exodus/log/BufferedDataWriter;", "iterable", "Ljetbrains/exodus/ByteIterable;", "xodus-environment"})
    public static final class Companion
    extends KLogging {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmStatic
        public final void invalidateSharedCache() {
            Class<Log> clazz = Log.class;
            synchronized (clazz) {
                sharedCache = null;
                Unit unit = Unit.INSTANCE;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final LogCache getSharedCache(long memoryUsage, int pageSize, boolean nonBlocking, int cacheGenerationCount) {
            LogCache result = sharedCache;
            if (result == null) {
                Class<Log> clazz = Log.class;
                synchronized (clazz) {
                    if (sharedCache == null) {
                        sharedCache = new SharedLogCache(memoryUsage, pageSize, nonBlocking, cacheGenerationCount);
                    }
                    result = sharedCache;
                    Unit unit = Unit.INSTANCE;
                }
            }
            LogCache logCache = result;
            if (logCache == null) {
                Intrinsics.throwNpe();
            }
            this.checkCachePageSize(pageSize, logCache);
            LogCache logCache2 = result;
            if (logCache2 == null) {
                Intrinsics.throwNpe();
            }
            return logCache2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final LogCache getSharedCache(int memoryUsagePercentage, int pageSize, boolean nonBlocking, int cacheGenerationCount) {
            LogCache result = sharedCache;
            if (result == null) {
                Class<Log> clazz = Log.class;
                synchronized (clazz) {
                    if (sharedCache == null) {
                        sharedCache = new SharedLogCache(memoryUsagePercentage, pageSize, nonBlocking, cacheGenerationCount);
                    }
                    result = sharedCache;
                    Unit unit = Unit.INSTANCE;
                }
            }
            LogCache logCache = result;
            if (logCache == null) {
                Intrinsics.throwNpe();
            }
            this.checkCachePageSize(pageSize, logCache);
            LogCache logCache2 = result;
            if (logCache2 == null) {
                Intrinsics.throwNpe();
            }
            return logCache2;
        }

        private final void checkCachePageSize(int pageSize, LogCache result) {
            if (result.pageSize != pageSize) {
                throw (Throwable)new ExodusException("SharedLogCache was created with page size " + result.pageSize + " and then requested with page size " + pageSize + ". EnvironmentConfig.LOG_CACHE_PAGE_SIZE was set manually.");
            }
        }

        private final void writeByteIterable(BufferedDataWriter writer, ByteIterable iterable) {
            int length = iterable.getLength();
            if (iterable instanceof ArrayByteIterable) {
                byte[] bytes = iterable.getBytesUnsafe();
                if (length == 1) {
                    writer.write(bytes[0]);
                } else {
                    writer.write(bytes, length);
                }
            } else if (length >= 3) {
                writer.write(iterable.getBytesUnsafe(), length);
            } else {
                ByteIterator iterator = iterable.iterator();
                writer.write(iterator.next());
                if (length == 2) {
                    writer.write(iterator.next());
                }
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

