/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.log.replication;

import java.nio.ByteBuffer;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.AsyncResponseTransformer;
import software.amazon.awssdk.services.s3.model.GetObjectResponse;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0003\u0018\u0000 \u001d2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u001d\u001eB\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0010\u001a\u00020\u0002H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0016\u0010\u0015\u001a\u00020\u00122\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00060\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\u0002H\u0016J\u001e\u0010\u0019\u001a\u00020\u000f2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00020\u000e2\b\b\u0002\u0010\u001b\u001a\u00020\u001cR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0010\u0010\t\u001a\u0004\u0018\u00010\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\n\u001a\f\u0012\b\u0012\u00060\fR\u00020\u00000\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Ljetbrains/exodus/log/replication/BufferQueueAsyncHandler;", "Lsoftware/amazon/awssdk/core/async/AsyncResponseTransformer;", "Lsoftware/amazon/awssdk/services/s3/model/GetObjectResponse;", "()V", "queue", "Ljava/util/concurrent/ArrayBlockingQueue;", "Ljava/nio/ByteBuffer;", "getQueue", "()Ljava/util/concurrent/ArrayBlockingQueue;", "response", "subscriber", "Ljava/util/concurrent/atomic/AtomicReference;", "Ljetbrains/exodus/log/replication/BufferQueueAsyncHandler$QueueSubscriber;", "subscriptionFuture", "Ljava/util/concurrent/CompletableFuture;", "Lorg/reactivestreams/Subscription;", "complete", "exceptionOccurred", "", "t", "", "onStream", "publisher", "Lorg/reactivestreams/Publisher;", "responseReceived", "waitForSubscription", "forObject", "maxMillis", "", "Companion", "QueueSubscriber", "xodus-multinode"})
public final class BufferQueueAsyncHandler
implements AsyncResponseTransformer<GetObjectResponse, GetObjectResponse> {
    private final AtomicReference<QueueSubscriber> subscriber = new AtomicReference();
    private final CompletableFuture<Subscription> subscriptionFuture = new CompletableFuture();
    @NotNull
    private final ArrayBlockingQueue<ByteBuffer> queue = new ArrayBlockingQueue(2);
    private volatile GetObjectResponse response;
    private static final long waitForSubscriptionInterval = 20L;
    @NotNull
    private static final ByteBuffer finish;
    public static final Companion Companion;

    @NotNull
    public final ArrayBlockingQueue<ByteBuffer> getQueue() {
        return this.queue;
    }

    @NotNull
    public final Subscription waitForSubscription(@NotNull CompletableFuture<GetObjectResponse> forObject, long maxMillis) {
        Intrinsics.checkParameterIsNotNull(forObject, (String)"forObject");
        for (long remaining = maxMillis; remaining > 0L; remaining -= 20L) {
            try {
                Subscription subscription = this.subscriptionFuture.get(20L, TimeUnit.MILLISECONDS);
                Intrinsics.checkExpressionValueIsNotNull((Object)subscription, (String)"subscriptionFuture.get(w\u2026l, TimeUnit.MILLISECONDS)");
                return subscription;
            }
            catch (TimeoutException t) {
                if (!forObject.isCompletedExceptionally()) continue;
                forObject.get();
                continue;
            }
        }
        throw (Throwable)new TimeoutException();
    }

    @NotNull
    public static /* synthetic */ Subscription waitForSubscription$default(BufferQueueAsyncHandler bufferQueueAsyncHandler, CompletableFuture completableFuture, long l, int n, Object object) {
        if ((n & 2) != 0) {
            l = 30000L;
        }
        return bufferQueueAsyncHandler.waitForSubscription(completableFuture, l);
    }

    public void responseReceived(@NotNull GetObjectResponse response) {
        Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
        this.response = response;
    }

    public void exceptionOccurred(@NotNull Throwable t) {
        Intrinsics.checkParameterIsNotNull((Object)t, (String)"t");
        this.queue.add(finish);
        this.subscriptionFuture.completeExceptionally(t);
    }

    public void onStream(@NotNull Publisher<ByteBuffer> publisher) {
        Intrinsics.checkParameterIsNotNull(publisher, (String)"publisher");
        QueueSubscriber sub = new QueueSubscriber();
        if (!this.subscriber.compareAndSet(null, sub)) {
            IllegalStateException illegalStateException;
            IllegalStateException it = illegalStateException = new IllegalStateException("Re-try is not supported");
            this.subscriptionFuture.completeExceptionally(it);
            throw (Throwable)it;
        }
        publisher.subscribe((Subscriber)sub);
    }

    @NotNull
    public GetObjectResponse complete() {
        GetObjectResponse getObjectResponse = this.response;
        if (getObjectResponse == null) {
            throw (Throwable)new IllegalStateException("Not subscribed");
        }
        return getObjectResponse;
    }

    static {
        Companion = new Companion(null);
        ByteBuffer byteBuffer = ByteBuffer.allocate(0);
        Intrinsics.checkExpressionValueIsNotNull((Object)byteBuffer, (String)"ByteBuffer.allocate(0)");
        finish = byteBuffer;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0002H\u0016J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0005H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Ljetbrains/exodus/log/replication/BufferQueueAsyncHandler$QueueSubscriber;", "Lorg/reactivestreams/Subscriber;", "Ljava/nio/ByteBuffer;", "(Ljetbrains/exodus/log/replication/BufferQueueAsyncHandler;)V", "subscription", "Lorg/reactivestreams/Subscription;", "onComplete", "", "onError", "t", "", "onNext", "onSubscribe", "s", "xodus-multinode"})
    private final class QueueSubscriber
    implements Subscriber<ByteBuffer> {
        private Subscription subscription;

        public void onComplete() {
            BufferQueueAsyncHandler.this.getQueue().add(Companion.getFinish());
        }

        public void onSubscribe(@NotNull Subscription s) {
            Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
            this.subscription = s;
            BufferQueueAsyncHandler.this.subscriptionFuture.complete(s);
            s.request(1L);
        }

        public void onNext(@NotNull ByteBuffer t) {
            Intrinsics.checkParameterIsNotNull((Object)t, (String)"t");
            if (!BufferQueueAsyncHandler.this.getQueue().add(t)) {
                throw (Throwable)new IllegalStateException("Unexpected capacity problems: subscription.request not invoked?");
            }
        }

        public void onError(@NotNull Throwable t) {
            Intrinsics.checkParameterIsNotNull((Object)t, (String)"t");
            Subscription subscription = this.subscription;
            if (subscription == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"subscription");
            }
            subscription.cancel();
            BufferQueueAsyncHandler.this.subscriptionFuture.completeExceptionally(t);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Ljetbrains/exodus/log/replication/BufferQueueAsyncHandler$Companion;", "", "()V", "finish", "Ljava/nio/ByteBuffer;", "getFinish", "()Ljava/nio/ByteBuffer;", "waitForSubscriptionInterval", "", "xodus-multinode"})
    public static final class Companion {
        @NotNull
        public final ByteBuffer getFinish() {
            return finish;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

