/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.log.replication;

import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import jetbrains.exodus.io.Block;
import jetbrains.exodus.io.FileDataReader;
import jetbrains.exodus.log.BufferedDataWriter;
import jetbrains.exodus.log.Log;
import jetbrains.exodus.log.LogUtil;
import jetbrains.exodus.log.replication.FileAsyncHandler;
import jetbrains.exodus.log.replication.FileFactory;
import jetbrains.exodus.log.replication.S3FactoryBoilerplate;
import jetbrains.exodus.log.replication.WriteResult;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.async.AsyncResponseTransformer;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.model.GetObjectResponse;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \"2\u00020\u00012\u00020\u0002:\u0001\"B1\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010\rJ0\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020!H\u0016R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0016\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006#"}, d2={"Ljetbrains/exodus/log/replication/S3FileFactory;", "Ljetbrains/exodus/log/replication/S3FactoryBoilerplate;", "Ljetbrains/exodus/log/replication/FileFactory;", "s3", "Lsoftware/amazon/awssdk/services/s3/S3AsyncClient;", "dir", "Ljava/nio/file/Path;", "bucket", "", "reader", "Ljetbrains/exodus/io/FileDataReader;", "requestOverrideConfig", "Lsoftware/amazon/awssdk/awscore/AwsRequestOverrideConfiguration;", "(Lsoftware/amazon/awssdk/services/s3/S3AsyncClient;Ljava/nio/file/Path;Ljava/lang/String;Ljetbrains/exodus/io/FileDataReader;Lsoftware/amazon/awssdk/awscore/AwsRequestOverrideConfiguration;)V", "getBucket", "()Ljava/lang/String;", "getDir", "()Ljava/nio/file/Path;", "getReader", "()Ljetbrains/exodus/io/FileDataReader;", "getRequestOverrideConfig", "()Lsoftware/amazon/awssdk/awscore/AwsRequestOverrideConfiguration;", "getS3", "()Lsoftware/amazon/awssdk/services/s3/S3AsyncClient;", "fetchFile", "Ljetbrains/exodus/log/replication/WriteResult;", "log", "Ljetbrains/exodus/log/Log;", "address", "", "startingLength", "expectedLength", "finalFile", "", "Companion", "xodus-multinode"})
public final class S3FileFactory
implements S3FactoryBoilerplate,
FileFactory {
    @NotNull
    private final S3AsyncClient s3;
    @NotNull
    private final Path dir;
    @NotNull
    private final String bucket;
    @NotNull
    private final FileDataReader reader;
    @Nullable
    private final AwsRequestOverrideConfiguration requestOverrideConfig;
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public WriteResult fetchFile(@NotNull Log log, long address, long startingLength, long expectedLength, boolean finalFile) {
        BufferedDataWriter bufferedDataWriter;
        FileAsyncHandler fileAsyncHandler;
        Intrinsics.checkParameterIsNotNull((Object)log, (String)"log");
        if (this.checkPreconditions(log, expectedLength, startingLength)) {
            return WriteResult.Companion.getEmpty();
        }
        log.ensureWriter().getBlockSetMutable().add(address, (Block)new FileDataReader.FileBlock(address, this.reader));
        String filename = LogUtil.getLogFilename((long)address);
        Companion.getLogger().debug((Function0)new Function0<String>(filename){
            final /* synthetic */ String $filename;

            @NotNull
            public final String invoke() {
                return "Fetch file at " + this.$filename;
            }
            {
                this.$filename = string;
                super(0);
            }
        });
        Path file = this.dir.resolve(filename);
        if (finalFile) {
            long lastPageStart = log.getHighPageAddress(expectedLength);
            Path path = file;
            Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"file");
            fileAsyncHandler = new FileAsyncHandler(path, startingLength, lastPageStart, log.ensureWriter().allocLastPage(address + lastPageStart));
        } else {
            Path path = file;
            Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"file");
            fileAsyncHandler = new FileAsyncHandler(path, startingLength, 0L, null, 12, null);
        }
        FileAsyncHandler handler = fileAsyncHandler;
        String string = filename;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"filename");
        Object t = this.getRemoteFile(expectedLength, startingLength, string, handler).get();
        WriteResult it = (WriteResult)t;
        BufferedDataWriter $receiver = bufferedDataWriter = log.ensureWriter();
        $receiver.incHighAddress(it.getWritten());
        $receiver.setLastPageLength(it.getLastPageLength());
        Object t2 = t;
        Intrinsics.checkExpressionValueIsNotNull(t2, (String)"getRemoteFile(expectedLe\u2026h\n            }\n        }");
        return (WriteResult)t2;
    }

    @Override
    @NotNull
    public S3AsyncClient getS3() {
        return this.s3;
    }

    @NotNull
    public final Path getDir() {
        return this.dir;
    }

    @Override
    @NotNull
    public String getBucket() {
        return this.bucket;
    }

    @NotNull
    public final FileDataReader getReader() {
        return this.reader;
    }

    @Override
    @Nullable
    public AwsRequestOverrideConfiguration getRequestOverrideConfig() {
        return this.requestOverrideConfig;
    }

    public S3FileFactory(@NotNull S3AsyncClient s3, @NotNull Path dir, @NotNull String bucket, @NotNull FileDataReader reader, @Nullable AwsRequestOverrideConfiguration requestOverrideConfig) {
        Intrinsics.checkParameterIsNotNull((Object)s3, (String)"s3");
        Intrinsics.checkParameterIsNotNull((Object)dir, (String)"dir");
        Intrinsics.checkParameterIsNotNull((Object)bucket, (String)"bucket");
        Intrinsics.checkParameterIsNotNull((Object)reader, (String)"reader");
        this.s3 = s3;
        this.dir = dir;
        this.bucket = bucket;
        this.reader = reader;
        this.requestOverrideConfig = requestOverrideConfig;
    }

    public /* synthetic */ S3FileFactory(S3AsyncClient s3AsyncClient, Path path, String string, FileDataReader fileDataReader, AwsRequestOverrideConfiguration awsRequestOverrideConfiguration, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            awsRequestOverrideConfiguration = null;
        }
        this(s3AsyncClient, path, string, fileDataReader, awsRequestOverrideConfiguration);
    }

    @Override
    @NotNull
    public <T> CompletableFuture<T> getRemoteFile(long length, long startingLength, @NotNull String name, @NotNull AsyncResponseTransformer<GetObjectResponse, T> handler) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull(handler, (String)"handler");
        return S3FactoryBoilerplate.DefaultImpls.getRemoteFile(this, length, startingLength, name, handler);
    }

    @Override
    public boolean checkPreconditions(@NotNull Log log, long expectedLength, long startingLength) {
        Intrinsics.checkParameterIsNotNull((Object)log, (String)"log");
        return S3FactoryBoilerplate.DefaultImpls.checkPreconditions(this, log, expectedLength, startingLength);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Ljetbrains/exodus/log/replication/S3FileFactory$Companion;", "Lmu/KLogging;", "()V", "xodus-multinode"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

