/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore;

import java.util.Comparator;
import java.util.List;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.entitystore.EntityIterable;
import jetbrains.exodus.entitystore.EntityStore;
import jetbrains.exodus.entitystore.QueryCancellingPolicy;
import jetbrains.exodus.entitystore.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface StoreTransaction {
    @NotNull
    public EntityStore getStore();

    public boolean isIdempotent();

    public boolean isReadonly();

    public boolean isFinished();

    public boolean commit();

    public void abort();

    public boolean flush();

    public void revert();

    public StoreTransaction getSnapshot();

    @NotNull
    public Entity newEntity(@NotNull String var1);

    public void saveEntity(@NotNull Entity var1);

    @NotNull
    public Entity getEntity(@NotNull EntityId var1);

    @NotNull
    public List<String> getEntityTypes();

    @NotNull
    public EntityIterable getAll(@NotNull String var1);

    @NotNull
    public EntityIterable getSingletonIterable(@NotNull Entity var1);

    @NotNull
    public EntityIterable find(@NotNull String var1, @NotNull String var2, @NotNull Comparable var3);

    @NotNull
    public EntityIterable find(@NotNull String var1, @NotNull String var2, @NotNull Comparable var3, @NotNull Comparable var4);

    @NotNull
    public EntityIterable findStartingWith(@NotNull String var1, @NotNull String var2, @NotNull String var3);

    @NotNull
    public EntityIterable findIds(@NotNull String var1, long var2, long var4);

    @NotNull
    public EntityIterable findWithProp(@NotNull String var1, @NotNull String var2);

    @NotNull
    public EntityIterable findWithBlob(@NotNull String var1, @NotNull String var2);

    @NotNull
    public EntityIterable findLinks(@NotNull String var1, @NotNull Entity var2, @NotNull String var3);

    @NotNull
    public EntityIterable findLinks(@NotNull String var1, @NotNull EntityIterable var2, @NotNull String var3);

    @NotNull
    public EntityIterable findWithLinks(@NotNull String var1, @NotNull String var2);

    @NotNull
    public EntityIterable findWithLinks(@NotNull String var1, @NotNull String var2, @NotNull String var3, @NotNull String var4);

    @NotNull
    public EntityIterable sort(@NotNull String var1, @NotNull String var2, boolean var3);

    @NotNull
    public EntityIterable sort(@NotNull String var1, @NotNull String var2, @NotNull EntityIterable var3, boolean var4);

    @NotNull
    public EntityIterable sortLinks(@NotNull String var1, @NotNull EntityIterable var2, boolean var3, @NotNull String var4, @NotNull EntityIterable var5);

    @NotNull
    public EntityIterable sortLinks(@NotNull String var1, @NotNull EntityIterable var2, boolean var3, @NotNull String var4, @NotNull EntityIterable var5, @NotNull String var6, @NotNull String var7);

    @Deprecated
    @NotNull
    public EntityIterable mergeSorted(@NotNull List<EntityIterable> var1, @NotNull Comparator<Entity> var2);

    @NotNull
    public EntityId toEntityId(@NotNull String var1);

    @NotNull
    public Sequence getSequence(@NotNull String var1);

    public void setQueryCancellingPolicy(QueryCancellingPolicy var1);

    @Nullable
    public QueryCancellingPolicy getQueryCancellingPolicy();
}

