/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.query;

import java.util.Iterator;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.query.BinaryOperator;
import jetbrains.exodus.query.NodeBase;
import jetbrains.exodus.query.OptimizationPlan;
import jetbrains.exodus.query.OptimizationRule;
import jetbrains.exodus.query.QueryEngine;
import jetbrains.exodus.query.Sorts;
import jetbrains.exodus.query.Utils;
import jetbrains.exodus.query.metadata.ModelMetaData;
import org.jetbrains.annotations.NotNull;

public class Concat
extends BinaryOperator {
    private Sorts leftSorts;
    private Sorts rightSorts;

    public Concat(@NotNull NodeBase left, @NotNull NodeBase right) {
        super(left, right);
    }

    public Concat(NodeBase left, Sorts lSorts, NodeBase right, Sorts rSorts) {
        super(left, right);
        this.leftSorts = lSorts;
        this.rightSorts = rSorts;
    }

    @Override
    public Iterable<Entity> instantiate(String entityType, QueryEngine queryEngine, ModelMetaData metaData) {
        return queryEngine.concatAdjusted(this.leftSorts.apply(entityType, this.getLeft().instantiate(entityType, queryEngine, metaData), queryEngine), this.rightSorts.apply(entityType, this.getRight().instantiate(entityType, queryEngine, metaData), queryEngine));
    }

    @Override
    public void optimize(Sorts sorts, OptimizationPlan rules) {
        if (this.leftSorts == null) {
            this.leftSorts = new Sorts();
        }
        if (this.rightSorts == null) {
            this.rightSorts = new Sorts();
        }
        boolean applied = true;
        while (applied) {
            OptimizationRule rule;
            applied = false;
            NodeBase left = this.getLeft();
            NodeBase right = this.getRight();
            left.optimize(this.leftSorts, rules);
            right.optimize(this.rightSorts, rules);
            Iterator<OptimizationRule> iterator2 = rules.rules.iterator();
            while (iterator2.hasNext() && !(applied = left.replaceIfMatches(rule = iterator2.next()) || right.replaceIfMatches(rule))) {
            }
        }
    }

    @Override
    public void cleanSorts(Sorts sorts) {
        if (sorts.sortCount() > 0) {
            this.leftSorts = new Sorts();
            this.rightSorts = new Sorts();
            this.getLeft().cleanSorts(sorts);
            this.getRight().cleanSorts(sorts);
        } else {
            this.getLeft().cleanSorts(this.leftSorts);
            this.getRight().cleanSorts(this.rightSorts);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        this.checkWildcard(obj);
        if (!(obj instanceof Concat)) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        Concat s = (Concat)obj;
        boolean leftEmpty = !(this.leftSorts != null && this.leftSorts.sortCount() != 0 || s.leftSorts != null && s.leftSorts.sortCount() != 0);
        boolean rightEmpty = !(this.rightSorts != null && this.rightSorts.sortCount() != 0 || s.rightSorts != null && s.rightSorts.sortCount() != 0);
        return !(!leftEmpty && !Utils.safe_equals(this.leftSorts, s.leftSorts) || !rightEmpty && !Utils.safe_equals(this.rightSorts, s.rightSorts));
    }

    @Override
    public NodeBase getClone() {
        return new Concat(this.getLeft().getClone(), this.leftSorts, this.getRight().getClone(), this.rightSorts);
    }

    @Override
    public String getSimpleName() {
        return "cnct";
    }
}

