/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.query;

import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.entitystore.PersistentEntity;
import jetbrains.exodus.entitystore.PersistentEntityId;
import jetbrains.exodus.entitystore.iterate.EntityIterableBase;
import jetbrains.exodus.query.NodeBase;
import jetbrains.exodus.query.QueryEngine;
import jetbrains.exodus.query.Utils;
import jetbrains.exodus.query.metadata.ModelMetaData;

public class GetLinks
extends NodeBase {
    private final EntityId id;
    private final String linkName;

    public GetLinks(EntityId from, String linkName) {
        this.id = from;
        this.linkName = linkName;
    }

    @Override
    protected boolean polymorphic() {
        return true;
    }

    @Override
    public Iterable<Entity> instantiate(String entityType, QueryEngine queryEngine, ModelMetaData metaData) {
        if (this.id != null) {
            PersistentEntity source = new PersistentEntity(queryEngine.getPersistentStore(), (PersistentEntityId)this.id);
            return source.getLinks(this.linkName);
        }
        return EntityIterableBase.EMPTY;
    }

    @Override
    public NodeBase getClone() {
        return new GetLinks(this.id, this.linkName);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        this.checkWildcard(obj);
        if (!(obj instanceof GetLinks)) {
            return false;
        }
        GetLinks getLinks = (GetLinks)obj;
        return Utils.safe_equals(this.linkName, getLinks.linkName) && Utils.safe_equals(this.id, getLinks.id);
    }

    @Override
    public String toString(String prefix) {
        return super.toString(prefix) + '(' + this.id + '.' + this.linkName + ") ";
    }

    @Override
    public StringBuilder getHandle(StringBuilder sb) {
        StringBuilder result = super.getHandle(sb).append('(');
        if (this.id != null) {
            result.append(this.id);
        }
        return result.append('.').append(this.linkName).append(')');
    }

    @Override
    public String getSimpleName() {
        return "gl";
    }
}

