/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.query;

import java.util.ArrayList;
import java.util.List;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.query.QueryEngine;
import jetbrains.exodus.query.Sort;
import jetbrains.exodus.query.SortEngine;
import org.jetbrains.annotations.NotNull;

public class Sorts {
    private List<Sort> sorts;

    public void addSort(Sort sort) {
        if (this.sorts == null) {
            this.sorts = new ArrayList<Sort>(4);
        }
        if (this.sorts.size() < 4) {
            this.sorts.add(0, sort);
        }
    }

    public Iterable<Entity> apply(String entityType, Iterable<Entity> iterable, @NotNull QueryEngine queryEngine) {
        if (this.sorts != null) {
            SortEngine sortEngine = queryEngine.getSortEngine();
            if (sortEngine == null) {
                throw new UnsupportedOperationException("Sort engine not provided!");
            }
            for (Sort sort : this.sorts) {
                iterable = sort.applySort(entityType, iterable, sortEngine);
            }
        }
        return iterable;
    }

    public int sortCount() {
        return this.sorts == null ? 0 : this.sorts.size();
    }

    public boolean canBeCached() {
        List<Sort> sorts = this.sorts;
        if (sorts != null) {
            for (Sort sort : sorts) {
                if (sort.canBeCached()) continue;
                return false;
            }
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Sorts)) {
            return false;
        }
        Sorts s = (Sorts)obj;
        if (this.sortCount() != s.sortCount()) {
            return false;
        }
        if (this.sorts != null) {
            for (int i = 0; i < this.sorts.size(); ++i) {
                if (this.sorts.get(i).equalAsSort(s.sorts.get(i))) continue;
                return false;
            }
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Sort it : this.sorts) {
            sb.append(it.getHandle()).append(' ');
        }
        return sb.toString();
    }
}

