/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.query.metadata;

import java.util.ArrayList;
import java.util.List;
import jetbrains.exodus.query.metadata.AssociationEndMetaData;
import jetbrains.exodus.query.metadata.AssociationMetaData;
import jetbrains.exodus.query.metadata.AssociationType;
import org.jetbrains.annotations.NotNull;

public class AssociationMetaDataImpl
implements AssociationMetaData {
    private AssociationType type;
    private final List<AssociationEndMetaData> ends = new ArrayList<AssociationEndMetaData>(2);
    private String fullName;

    public AssociationMetaDataImpl() {
    }

    public AssociationMetaDataImpl(AssociationType type, String fullName) {
        this.type = type;
        this.fullName = fullName;
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public void addEnd(@NotNull AssociationEndMetaData end) {
        if (this.ends.isEmpty() || this.ends.size() < 2 && this.ends.get(0) != end) {
            this.ends.add(end);
        }
    }

    public void setType(@NotNull AssociationType type) {
        this.type = type;
    }

    @Override
    @NotNull
    public AssociationType getType() {
        return this.type;
    }

    @Override
    @NotNull
    public AssociationEndMetaData getOppositeEnd(@NotNull AssociationEndMetaData end) {
        if (AssociationType.Directed.equals((Object)this.type)) {
            throw new IllegalStateException("Directed association has no opposite end.");
        }
        if (this.ends.size() != 1 && this.ends.size() != 2) {
            throw new IllegalStateException("Incomplete association.");
        }
        return end == this.ends.get(0) ? this.ends.get(1) : this.ends.get(0);
    }
}

