/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.query.metadata;

import java.util.LinkedList;
import java.util.Set;
import jetbrains.exodus.core.dataStructures.hash.HashSet;
import jetbrains.exodus.query.metadata.AssociationEndCardinality;
import jetbrains.exodus.query.metadata.AssociationEndMetaData;
import jetbrains.exodus.query.metadata.AssociationEndMetaDataImpl;
import jetbrains.exodus.query.metadata.AssociationEndType;
import jetbrains.exodus.query.metadata.AssociationMetaData;
import jetbrains.exodus.query.metadata.AssociationMetaDataImpl;
import jetbrains.exodus.query.metadata.AssociationType;
import jetbrains.exodus.query.metadata.EntityMetaData;
import jetbrains.exodus.query.metadata.EntityMetaDataImpl;
import jetbrains.exodus.query.metadata.MemberMetaData;
import jetbrains.exodus.query.metadata.ModelMetaDataImpl;
import jetbrains.exodus.query.metadata.PropertyMetaData;
import jetbrains.exodus.query.metadata.PropertyMetaDataImpl;
import jetbrains.exodus.query.metadata.PropertyType;
import jetbrains.exodus.query.metadata.SimplePropertyMetaDataImpl;

public class MetaBuilder {
    private MetaBuilder() {
    }

    public static ModelMetaDataImpl model() {
        return new ModelMetaDataImpl();
    }

    public static ModelMetaDataImpl model(Enumeration ... classes) {
        return MetaBuilder.model(MetaBuilder.model(), classes);
    }

    public static ModelMetaDataImpl model(ModelMetaDataImpl modelMetaData, Enumeration ... classes) {
        HashSet emdSet = new HashSet();
        for (Enumeration enumeration : classes) {
            emdSet.add(enumeration.build(modelMetaData));
        }
        modelMetaData.setEntityMetaDatas((Set<EntityMetaData>)emdSet);
        modelMetaData.init();
        return modelMetaData;
    }

    public static Clazz clazz(Class clz) {
        return MetaBuilder.clazz(clz.getName());
    }

    public static Clazz clazz(String name) {
        return new Clazz(name);
    }

    public static Clazz clazz(Class clz, Class superClz) {
        return new Clazz(clz.getName(), superClz.getName());
    }

    public static Clazz clazz(String name, String superType) {
        return new Clazz(name, superType);
    }

    public static Enumeration enumeration(Class clz) {
        return MetaBuilder.enumeration(clz.getName());
    }

    public static Enumeration enumeration(String name) {
        return new Enumeration(name);
    }

    public static void main(String ... args) {
        MetaBuilder.model(MetaBuilder.clazz("TstClass").prop("s", "string").prop("i", "int").link("itself", "TstClass", AssociationEndCardinality._0_1).edge("self1", "TstClass", AssociationEndCardinality._0_1, "self2", AssociationEndCardinality._0_1).link("myEnum", "MyEnum", AssociationEndCardinality._0_1), MetaBuilder.clazz("TstClassInheritor", "TstClass"), MetaBuilder.enumeration("MyEnum").prop("number", "int"));
    }

    public static final class Clazz
    extends Enumeration {
        private String superType;

        public Clazz(String name) {
            super(name);
        }

        public Clazz(String name, String superType) {
            super(name);
            this.superType = superType;
        }

        public Clazz link(String name, String toType, AssociationEndCardinality cardinality) {
            AssociationEndMetaDataImpl result = new AssociationEndMetaDataImpl();
            result.setName(name);
            result.setOppositeEntityMetaDataType(toType);
            result.setAssociationEndType(AssociationEndType.DirectedAssociationEnd);
            result.setCardinality(cardinality);
            String assocName = this.type + '.' + name + '-' + toType;
            AssociationMetaDataImpl amd = new AssociationMetaDataImpl(AssociationType.Directed, assocName);
            result.setAssociationMetaDataName(assocName);
            result.setAssociationMetaDataInternal(amd);
            this.assoc.add(amd);
            this.meta.add(result);
            return this;
        }

        public Clazz edge(String name, String toType, AssociationEndCardinality cardinality, String toName, AssociationEndCardinality toCardinality) {
            AssociationEndMetaDataImpl from = new AssociationEndMetaDataImpl();
            from.setName(name);
            from.setOppositeEntityMetaDataType(toType);
            from.setAssociationEndType(AssociationEndType.UndirectedAssociationEnd);
            from.setCardinality(cardinality);
            from.setOppositeEndName(toName);
            AssociationEndMetaDataImpl to = new AssociationEndMetaDataImpl();
            to.setName(toName);
            to.setOppositeEntityMetaDataType(this.type);
            to.setAssociationEndType(AssociationEndType.UndirectedAssociationEnd);
            to.setCardinality(toCardinality);
            to.setOppositeEndName(name);
            String assocName = this.type + '.' + name + '-' + toType + '.' + toName;
            AssociationMetaDataImpl amd = new AssociationMetaDataImpl(AssociationType.Undirected, assocName);
            from.setAssociationMetaDataName(assocName);
            to.setAssociationMetaDataName(assocName);
            from.setAssociationMetaDataInternal(amd);
            to.setAssociationMetaDataInternal(amd);
            this.assoc.add(amd);
            this.meta.add(from);
            this.meta.add(to);
            return this;
        }

        @Override
        public Clazz prop(String name, String type) {
            super.prop(name, type);
            return this;
        }

        @Override
        public Clazz text(String name) {
            super.text(name);
            return this;
        }

        @Override
        public Clazz blob(String name) {
            super.blob(name);
            return this;
        }

        @Override
        public EntityMetaDataImpl build(ModelMetaDataImpl model) {
            EntityMetaDataImpl result = super.build(model);
            if (this.superType != null) {
                result.setSuperType(this.superType);
            }
            return result;
        }
    }

    public static class Enumeration {
        protected final String type;
        protected final Set<MemberMetaData> meta = new HashSet();
        protected final Set<AssociationMetaData> assoc = new HashSet();

        public Enumeration(String type) {
            this.type = type;
        }

        public Enumeration prop(String name, String type) {
            this.meta.add(new SimplePropertyMetaDataImpl(name, type));
            return this;
        }

        public Enumeration text(String name) {
            this.meta.add(new PropertyMetaDataImpl(name, PropertyType.TEXT));
            return this;
        }

        public Enumeration blob(String name) {
            this.meta.add(new PropertyMetaDataImpl(name, PropertyType.BLOB));
            return this;
        }

        public EntityMetaDataImpl build(ModelMetaDataImpl model) {
            EntityMetaDataImpl result = new EntityMetaDataImpl();
            result.setType(this.type);
            LinkedList<PropertyMetaData> p = new LinkedList<PropertyMetaData>();
            LinkedList<AssociationEndMetaData> a = new LinkedList<AssociationEndMetaData>();
            for (MemberMetaData member : this.meta) {
                if (member instanceof PropertyMetaData) {
                    p.add((PropertyMetaData)member);
                    continue;
                }
                if (member instanceof AssociationEndMetaData) {
                    a.add((AssociationEndMetaData)member);
                    continue;
                }
                throw new UnsupportedOperationException("unknown member type");
            }
            model.setAssociationMetaDatas(this.assoc);
            result.setPropertiesMetaData(p);
            result.setAssociationEndsMetaData(a);
            return result;
        }
    }
}

