/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.core.dataStructures.decorators;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import jetbrains.exodus.core.dataStructures.hash.HashMap;

public class HashMapDecorator<K, V>
implements Map<K, V> {
    private Map<K, V> decorated;

    public HashMapDecorator() {
        this.clear();
    }

    @Override
    public int size() {
        return this.decorated.size();
    }

    @Override
    public boolean isEmpty() {
        return this.decorated == Collections.emptyMap() || this.decorated.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.decorated.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.decorated.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.decorated.get(key);
    }

    @Override
    public V put(K key, V value) {
        this.checkDecorated();
        return this.decorated.put(key, value);
    }

    @Override
    public V remove(Object key) {
        if (this.decorated == Collections.emptyMap()) {
            return null;
        }
        V result = this.decorated.remove(key);
        if (result != null && this.decorated.isEmpty()) {
            this.clear();
        }
        return result;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.checkDecorated();
        this.decorated.putAll(m);
    }

    @Override
    public void clear() {
        this.decorated = Collections.emptyMap();
    }

    @Override
    public Set<K> keySet() {
        return this.decorated.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.decorated.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.decorated.entrySet();
    }

    private void checkDecorated() {
        if (this.decorated == Collections.emptyMap()) {
            this.decorated = new HashMap();
        }
    }
}

