/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.vfs;

import java.io.IOException;
import java.io.OutputStream;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.env.Store;
import jetbrains.exodus.env.StoreImpl;
import jetbrains.exodus.env.Transaction;
import jetbrains.exodus.vfs.Cluster;
import jetbrains.exodus.vfs.ClusterIterator;
import jetbrains.exodus.vfs.ClusterKey;
import jetbrains.exodus.vfs.ClusteringStrategy;
import jetbrains.exodus.vfs.VirtualFileSystem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class VfsOutputStream
extends OutputStream {
    @NotNull
    private final VirtualFileSystem vfs;
    @NotNull
    private final Transaction txn;
    private final long fd;
    private final Store contents;
    private final Runnable clusterFlushTrigger;
    private final ClusterIterator clusterIterator;
    private byte[] outputCluster;
    private int position;
    private int outputClusterSize;
    private boolean isOutputClusterDirty;
    private long currentClusterNumber;

    VfsOutputStream(@NotNull VirtualFileSystem vfs, @NotNull Transaction txn, long fileDescriptor, @Nullable Runnable clusterFlushTrigger) {
        this(vfs, txn, fileDescriptor, 0L, clusterFlushTrigger);
    }

    VfsOutputStream(@NotNull VirtualFileSystem vfs, @NotNull Transaction txn, long fileDescriptor, long position, @Nullable Runnable clusterFlushTrigger) {
        if (position < 0L) {
            throw new IllegalArgumentException("Position in output stream can't be negative");
        }
        this.vfs = vfs;
        this.txn = txn;
        this.fd = fileDescriptor;
        this.contents = vfs.getContents();
        this.clusterFlushTrigger = clusterFlushTrigger;
        this.currentClusterNumber = -1L;
        this.clusterIterator = new ClusterIterator(vfs, txn, fileDescriptor, position);
        ClusteringStrategy clusteringStrategy = vfs.getConfig().getClusteringStrategy();
        int firstClusterSize = clusteringStrategy.getFirstClusterSize();
        if (this.clusterIterator.getCurrent() != null) {
            this.loadCurrentCluster(firstClusterSize);
            this.position = (int)(position % (long)firstClusterSize);
        } else {
            if (position > 0L) {
                this.clusterIterator.seek(0L);
            }
            this.loadCurrentCluster(firstClusterSize);
            while (this.clusterIterator.hasCluster()) {
                if (position < (long)this.outputClusterSize) {
                    this.position = (int)position;
                    break;
                }
                position -= (long)this.outputClusterSize;
                this.clusterIterator.moveToNext();
                this.loadCurrentCluster(clusteringStrategy.getNextClusterSize(this.outputCluster.length));
            }
        }
    }

    @Override
    public void write(int b) {
        byte destByte;
        byte sourceByte;
        int position = this.position;
        if (position == this.outputCluster.length) {
            this.flushCurrentCluster();
            this.clusterIterator.moveToNext();
            this.loadCurrentCluster(this.vfs.getConfig().getClusteringStrategy().getNextClusterSize(position));
            position = this.position;
        }
        if ((sourceByte = this.outputCluster[position]) != (destByte = (byte)b)) {
            this.outputCluster[position] = destByte;
            this.isOutputClusterDirty = true;
        }
        if (++position > this.outputClusterSize) {
            this.outputClusterSize = position;
            this.isOutputClusterDirty = true;
        }
        this.position = position;
    }

    @Override
    public void write(@NotNull byte[] b, int off, int len) throws IOException {
        int position = this.position;
        if (position + len > this.outputCluster.length) {
            super.write(b, off, len);
        } else {
            if (this.isOutputClusterDirty) {
                System.arraycopy(b, off, this.outputCluster, position, len);
                position += len;
            } else {
                while (len > 0) {
                    byte sourceByte = this.outputCluster[position];
                    byte destByte = b[off];
                    if (sourceByte != destByte) {
                        this.outputCluster[position] = destByte;
                        this.isOutputClusterDirty = true;
                    }
                    --len;
                    ++off;
                    ++position;
                }
            }
            this.position = position;
            if (this.position > this.outputClusterSize) {
                this.outputClusterSize = position;
                this.isOutputClusterDirty = true;
            }
        }
    }

    @Override
    public void close() {
        try (ClusterIterator ignore = this.clusterIterator;){
            this.flushCurrentCluster();
        }
    }

    public boolean isOpen() {
        return !this.clusterIterator.isClosed();
    }

    private void flushCurrentCluster() {
        if (this.isOutputClusterDirty) {
            ((StoreImpl)this.contents).putNotifyNoCursors(this.txn, (ByteIterable)ClusterKey.toByteIterable(this.fd, this.currentClusterNumber), Cluster.writeCluster(this.outputCluster, this.vfs.getClusterConverter(), this.outputClusterSize, this.vfs.getConfig().getAccumulateChangesInRAM()));
            if (this.clusterFlushTrigger != null) {
                this.clusterFlushTrigger.run();
            }
        }
    }

    private void loadCurrentCluster(int clusterSize) {
        Cluster currentCluster = this.clusterIterator.getCurrent();
        if (currentCluster == null) {
            this.outputClusterSize = 0;
            this.outputCluster = new byte[clusterSize];
            ++this.currentClusterNumber;
        } else {
            this.outputClusterSize = currentCluster.getSize();
            this.outputCluster = new byte[clusterSize > this.outputClusterSize ? clusterSize : this.outputClusterSize];
            for (int i = 0; i < this.outputClusterSize; ++i) {
                this.outputCluster[i] = currentCluster.next();
            }
            this.currentClusterNumber = currentCluster.getClusterNumber();
        }
        this.position = 0;
        this.isOutputClusterDirty = false;
    }
}

