/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.main;

import java.util.concurrent.ConcurrentHashMap;
import jetbrains.charisma.main.LocalScoped;
import jetbrains.charisma.persistent.queries.YouTrackTransientQueryEngine;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@LocalScoped
@Service(value="issueUpdateMonitoringService")
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u000f\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0007J\u000e\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0007R \u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Ljetbrains/charisma/main/IssueUpdateMonitoringService;", "", "queryEngine", "Ljetbrains/charisma/persistent/queries/YouTrackTransientQueryEngine;", "(Ljetbrains/charisma/persistent/queries/YouTrackTransientQueryEngine;)V", "accessingIssues", "Ljava/util/concurrent/ConcurrentHashMap;", "", "", "getAccessingIssues$youtrack_application", "()Ljava/util/concurrent/ConcurrentHashMap;", "enabled", "getEnabled", "()Z", "issueTypePrefix", "getIssueTypePrefix", "()Ljava/lang/String;", "finishUpdate", "", "issueId", "isUpdating", "Companion", "youtrack-application"})
public final class IssueUpdateMonitoringService {
    private final boolean enabled;
    @NotNull
    private final String issueTypePrefix;
    @NotNull
    private final ConcurrentHashMap<String, Boolean> accessingIssues;
    private final YouTrackTransientQueryEngine queryEngine;
    @NotNull
    private static final String ENABLE_CONCURRENT_UPDATES = "youtrack.feature.enableConcurrentIssueUpdates";
    public static final Companion Companion = new Companion(null);

    public final boolean getEnabled() {
        return this.enabled;
    }

    @NotNull
    public final String getIssueTypePrefix() {
        return this.issueTypePrefix;
    }

    @NotNull
    public final ConcurrentHashMap<String, Boolean> getAccessingIssues$youtrack_application() {
        return this.accessingIssues;
    }

    public final boolean isUpdating(@NotNull String issueId) {
        Intrinsics.checkParameterIsNotNull((Object)issueId, (String)"issueId");
        if (this.enabled) {
            Boolean result2 = this.accessingIssues.putIfAbsent(issueId, true);
            return result2 != null;
        }
        return false;
    }

    public final void finishUpdate(@NotNull String issueId) {
        Intrinsics.checkParameterIsNotNull((Object)issueId, (String)"issueId");
        if (this.enabled) {
            this.accessingIssues.remove(issueId);
        }
    }

    public IssueUpdateMonitoringService(@Autowired @NotNull YouTrackTransientQueryEngine queryEngine) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)((Object)queryEngine), (String)"queryEngine");
        this.queryEngine = queryEngine;
        IssueUpdateMonitoringService issueUpdateMonitoringService = this;
        String string = System.getProperty(ENABLE_CONCURRENT_UPDATES, "false");
        if (string != null) {
            String string2 = string;
            IssueUpdateMonitoringService issueUpdateMonitoringService2 = issueUpdateMonitoringService;
            boolean bl2 = Boolean.parseBoolean(string2);
            issueUpdateMonitoringService = issueUpdateMonitoringService2;
            bl = bl2;
        } else {
            bl = false;
        }
        issueUpdateMonitoringService.enabled = bl;
        this.issueTypePrefix = "" + this.queryEngine.getIssueType() + '-';
        this.accessingIssues = new ConcurrentHashMap();
    }

    static {
        ENABLE_CONCURRENT_UPDATES = ENABLE_CONCURRENT_UPDATES;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Ljetbrains/charisma/main/IssueUpdateMonitoringService$Companion;", "", "()V", "ENABLE_CONCURRENT_UPDATES", "", "getENABLE_CONCURRENT_UPDATES", "()Ljava/lang/String;", "youtrack-application"})
    public static final class Companion {
        @NotNull
        public final String getENABLE_CONCURRENT_UPDATES() {
            return ENABLE_CONCURRENT_UPDATES;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

