/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.maintenance;

import jetbrains.charisma.main.CharismaLicenseCheckerContainer;
import jetbrains.charisma.main.ConfigurationUtil;
import jetbrains.charisma.main.LicenseParamsChangeListener;
import jetbrains.youtrack.api.statistics.StatisticsFeatureDescription;
import jetbrains.youtrack.api.statistics.StatisticsService;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\n\u001a\u00020\u000b2\n\u0010\f\u001a\u00060\rR\u00020\u000e2\n\u0010\u000f\u001a\u00060\rR\u00020\u000eH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u00020\t8\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Ljetbrains/charisma/maintenance/StandaloneLicenseParamsChangeListener;", "Ljetbrains/charisma/main/LicenseParamsChangeListener;", "()V", "decreasedUsers", "Ljetbrains/youtrack/api/statistics/StatisticsFeatureDescription;", "increasedUsers", "movedToStandaloneFromCloud", "newLicenseWithSameUsers", "service", "Ljetbrains/youtrack/api/statistics/StatisticsService;", "handle", "", "old", "Ljetbrains/charisma/main/CharismaLicenseCheckerContainer$LicenseParamsShort;", "Ljetbrains/charisma/main/CharismaLicenseCheckerContainer;", "current", "isActive", "", "newFeature", "feature", "", "youtrack-application"})
public final class StandaloneLicenseParamsChangeListener
implements LicenseParamsChangeListener {
    private final StatisticsFeatureDescription movedToStandaloneFromCloud = this.newFeature("movedToStandaloneFromCloud");
    private final StatisticsFeatureDescription increasedUsers = this.newFeature("increasedUsers");
    private final StatisticsFeatureDescription decreasedUsers = this.newFeature("decreasedUsers");
    private final StatisticsFeatureDescription newLicenseWithSameUsers = this.newFeature("newLicenseWithSameUsers");
    @Autowired
    private StatisticsService service;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isActive() {
        if (ConfigurationUtil.isYoutrackHosted()) return false;
        StatisticsService statisticsService = this.service;
        if (statisticsService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"service");
        }
        Boolean bl = statisticsService.isAllowedToCollectStat();
        Intrinsics.checkExpressionValueIsNotNull((Object)bl, (String)"service.isAllowedToCollectStat");
        if (bl == false) return false;
        return true;
    }

    public void handle(@NotNull CharismaLicenseCheckerContainer.LicenseParamsShort old, @NotNull CharismaLicenseCheckerContainer.LicenseParamsShort current) {
        Intrinsics.checkParameterIsNotNull((Object)old, (String)"old");
        Intrinsics.checkParameterIsNotNull((Object)current, (String)"current");
        if (old.getGenerationTime() == 0L) {
            return;
        }
        if (old.getGenerationTime() < current.getGenerationTime() && !old.getHosted() && old.getUserCount() == current.getUserCount()) {
            StatisticsService statisticsService = this.service;
            if (statisticsService == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"service");
            }
            statisticsService.incForInstance(this.newLicenseWithSameUsers);
        }
        if (old.getHosted()) {
            StatisticsService statisticsService = this.service;
            if (statisticsService == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"service");
            }
            statisticsService.incForInstance(this.movedToStandaloneFromCloud);
        }
        if (old.getUserCount() != current.getUserCount()) {
            if (current.getUserCount() > old.getUserCount()) {
                StatisticsService statisticsService = this.service;
                if (statisticsService == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"service");
                }
                statisticsService.incForInstance(this.increasedUsers);
            } else {
                StatisticsService statisticsService = this.service;
                if (statisticsService == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"service");
                }
                statisticsService.incForInstance(this.decreasedUsers);
            }
        }
    }

    private final StatisticsFeatureDescription newFeature(String feature) {
        return new StatisticsFeatureDescription("standaloneLicense", feature);
    }
}

