/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.service;

import com.jetbrains.teamsys.dnq.database.EntityOperations;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jetbrains.charisma.parser.filter.BaseFieldValue;
import jetbrains.charisma.persistence.security.UserGroupMergeHandler;
import jetbrains.charisma.persistence.security.UserGroupMergeHandlers;
import jetbrains.charisma.service.UserGroupService;
import jetbrains.charisma.service.UserGroupServiceImpl;
import jetbrains.exodus.database.exceptions.ConstraintsValidationException;
import jetbrains.exodus.database.exceptions.DataIntegrityViolationException;
import jetbrains.exodus.database.exceptions.UserConstraintValidationException;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.youtrack.api.l10n.BeansKt;
import jetbrains.youtrack.parser.lexer.CharIterable;
import jetbrains.youtrack.parser.lexer.CharSequenceIterable;
import jetbrains.youtrack.parser.prefixTree.IPredicate;
import jetbrains.youtrack.parser.prefixTree.PrefixIterable;
import jetbrains.youtrack.parser.prefixTree.PrefixIterator;
import jetbrains.youtrack.persistent.XdIssue;
import jetbrains.youtrack.persistent.XdUser;
import jetbrains.youtrack.persistent.XdUserGroup;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlinx.dnq.XdExtensionsKt;
import kotlinx.dnq.query.XdFilteringQueryKt;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="userGroupService")
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0016J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\f0\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001c\u0010\u0012\u001a\u0004\u0018\u00010\f2\b\u0010\u0013\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0014\u001a\u00020\fH\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\fH\u0016J\u0018\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\fH\u0016J\u0016\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u001b2\u0006\u0010\u001a\u001a\u00020\u001bJ\u0014\u0010\u001c\u001a\u00020\u001d*\u00020\u001b2\u0006\u0010\u0013\u001a\u00020\u001eH\u0002R\u001e\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u001f"}, d2={"Ljetbrains/charisma/service/UserGroupServiceImpl;", "Ljetbrains/charisma/service/UserGroupService;", "()V", "userGroupMergeHandlers", "Ljetbrains/charisma/persistence/security/UserGroupMergeHandlers;", "getUserGroupMergeHandlers", "()Ljetbrains/charisma/persistence/security/UserGroupMergeHandlers;", "setUserGroupMergeHandlers", "(Ljetbrains/charisma/persistence/security/UserGroupMergeHandlers;)V", "deleteWithSuccessor", "", "toDelete", "Ljetbrains/exodus/entitystore/Entity;", "successor", "filterGroupsInPrefixTrees", "", "query", "", "getMostRelatedGroup", "issue", "user", "hasUsages", "", "group", "merge", "from", "into", "Ljetbrains/youtrack/persistent/XdUserGroup;", "getRelevance", "", "Ljetbrains/youtrack/persistent/XdIssue;", "youtrack-application"})
public class UserGroupServiceImpl
implements UserGroupService {
    @Autowired
    @NotNull
    public UserGroupMergeHandlers userGroupMergeHandlers;

    @NotNull
    public final UserGroupMergeHandlers getUserGroupMergeHandlers() {
        UserGroupMergeHandlers userGroupMergeHandlers = this.userGroupMergeHandlers;
        if (userGroupMergeHandlers == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"userGroupMergeHandlers");
        }
        return userGroupMergeHandlers;
    }

    public final void setUserGroupMergeHandlers(@NotNull UserGroupMergeHandlers userGroupMergeHandlers) {
        Intrinsics.checkParameterIsNotNull((Object)userGroupMergeHandlers, (String)"<set-?>");
        this.userGroupMergeHandlers = userGroupMergeHandlers;
    }

    public void merge(@NotNull Entity from2, @NotNull Entity into) {
        Intrinsics.checkParameterIsNotNull((Object)from2, (String)"from");
        Intrinsics.checkParameterIsNotNull((Object)into, (String)"into");
        this.merge((XdUserGroup)XdExtensionsKt.toXd((Entity)from2), (XdUserGroup)XdExtensionsKt.toXd((Entity)into));
    }

    public final void merge(@NotNull XdUserGroup from2, @NotNull XdUserGroup into) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)from2), (String)"from");
        Intrinsics.checkParameterIsNotNull((Object)((Object)into), (String)"into");
        if (Intrinsics.areEqual((Object)((Object)from2), (Object)((Object)into))) {
            throw (Throwable)new ConstraintsValidationException((DataIntegrityViolationException)new UserConstraintValidationException("Can't merge group " + into.getName() + " into itself", null, 2, null));
        }
        if (from2.getAllUsersGroup()) {
            throw (Throwable)new ConstraintsValidationException((DataIntegrityViolationException)new UserConstraintValidationException("All Users group can't be merged into the other group", null, 2, null));
        }
        UserGroupMergeHandlers userGroupMergeHandlers = this.userGroupMergeHandlers;
        if (userGroupMergeHandlers == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"userGroupMergeHandlers");
        }
        List list = userGroupMergeHandlers.getHandlers();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"userGroupMergeHandlers.handlers");
        Iterable $receiver$iv = list;
        for (Object element$iv : $receiver$iv) {
            UserGroupMergeHandler it = (UserGroupMergeHandler)element$iv;
            it.groupMerged(from2.getEntity(), into.getEntity());
        }
        from2.delete();
    }

    public void deleteWithSuccessor(@NotNull Entity toDelete, @NotNull Entity successor2) {
        Intrinsics.checkParameterIsNotNull((Object)toDelete, (String)"toDelete");
        Intrinsics.checkParameterIsNotNull((Object)successor2, (String)"successor");
        XdUserGroup xdToDelete = (XdUserGroup)XdExtensionsKt.toXd((Entity)toDelete);
        if (EntityOperations.equals((Entity)toDelete, (Object)successor2)) {
            String string = BeansKt.getLocalizer().localizedMsg("UserGroup.Can_t_merge_with_itself", new Object[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"localizer.localizedMsg(\"\u2026Can_t_merge_with_itself\")");
            throw (Throwable)new ConstraintsValidationException((DataIntegrityViolationException)new UserConstraintValidationException(string, null, 2, null));
        }
        if (xdToDelete.getAllUsersGroup()) {
            String string = BeansKt.getLocalizer().localizedMsg("UserGroup.Can_t_merge_with_All_Users_group", new Object[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"localizer.localizedMsg(\"\u2026ge_with_All_Users_group\")");
            throw (Throwable)new ConstraintsValidationException((DataIntegrityViolationException)new UserConstraintValidationException(string, null, 2, null));
        }
        UserGroupMergeHandlers userGroupMergeHandlers = this.userGroupMergeHandlers;
        if (userGroupMergeHandlers == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"userGroupMergeHandlers");
        }
        List list = userGroupMergeHandlers.getHandlers();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"userGroupMergeHandlers.handlers");
        Iterable $receiver$iv = list;
        for (Object element$iv : $receiver$iv) {
            UserGroupMergeHandler it = (UserGroupMergeHandler)element$iv;
            it.groupDeleted(toDelete, successor2);
        }
        xdToDelete.delete();
    }

    public boolean hasUsages(@NotNull Entity group) {
        boolean bl;
        block4: {
            Intrinsics.checkParameterIsNotNull((Object)group, (String)"group");
            UserGroupMergeHandlers userGroupMergeHandlers = this.userGroupMergeHandlers;
            if (userGroupMergeHandlers == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"userGroupMergeHandlers");
            }
            List list = userGroupMergeHandlers.getHandlers();
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"userGroupMergeHandlers.handlers");
            Iterable $receiver$iv = list;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $receiver$iv) {
                    UserGroupMergeHandler it = (UserGroupMergeHandler)element$iv;
                    if (!it.hasUsages(group)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    public Iterable<Entity> filterGroupsInPrefixTrees(@NotNull String query2) {
        Intrinsics.checkParameterIsNotNull((Object)query2, (String)"query");
        Object object = jetbrains.charisma.keyword.BeansKt.getPrefixTrees().read("GROUP", (_FunctionTypes._return_P1_E0)new _FunctionTypes._return_P1_E0<Iterable<? extends Entity>, PrefixIterable<Object>>(query2){
            final /* synthetic */ String $query;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Iterable<Entity> invoke(PrefixIterable<Object> tree) {
                Iterable iterable;
                PrefixIterator iterator2 = tree.prefixIterator();
                if (iterator2.move((CharIterable)new CharSequenceIterable((CharSequence)this.$query))) {
                    void $receiver$iv$iv;
                    Iterable $receiver$iv;
                    Iterable iterable2 = iterator2.getDescendantValues((IPredicate)filterGroupsInPrefixTrees.1.INSTANCE);
                    Intrinsics.checkExpressionValueIsNotNull((Object)iterable2, (String)"iterator.getDescendantVa\u2026it is BaseFieldValue<*> }");
                    Iterable iterable3 = $receiver$iv = iterable2;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                    Iterator<T> iterator3 = $receiver$iv$iv.iterator();
                    while (iterator3.hasNext()) {
                        void it;
                        T item$iv$iv;
                        T t = item$iv$iv = iterator3.next();
                        Collection collection = destination$iv$iv;
                        void v1 = it;
                        if (v1 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type jetbrains.charisma.parser.filter.BaseFieldValue<jetbrains.youtrack.persistent.XdUserGroup>");
                        }
                        Entity entity2 = ((XdUserGroup)((Object)((BaseFieldValue)v1).getFieldValue())).getEntity();
                        collection.add(entity2);
                    }
                    iterable = (List)destination$iv$iv;
                } else {
                    iterable = CollectionsKt.emptyList();
                }
                return iterable;
            }
            {
                this.$query = string;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"prefixTrees.read(UserSer\u2026)\n            }\n        }");
        return (Iterable)object;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public Entity getMostRelatedGroup(@Nullable Entity issue2, @NotNull Entity user2) {
        Intrinsics.checkParameterIsNotNull((Object)user2, (String)"user");
        XdUser xdUser = (XdUser)XdUser.Companion.wrap(user2);
        Iterable $receiver$iv = XdQueryKt.toList((XdQuery)XdFilteringQueryKt.filter((XdQuery)((XdQuery)xdUser.getGroups()), (Function2)getMostRelatedGroup.groupsByCount.1.INSTANCE));
        Object object = $receiver$iv;
        Comparator comparator = new Comparator<T>(){

            public final int compare(T a, T b) {
                XdUserGroup it = (XdUserGroup)((Object)a);
                Comparable comparable = Integer.valueOf(XdQueryKt.size((XdQuery)((XdQuery)it.getUsers())));
                it = (XdUserGroup)((Object)b);
                Comparable comparable2 = comparable;
                Integer n = XdQueryKt.size((XdQuery)((XdQuery)it.getUsers()));
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
            }
        };
        List groupsByCount2 = CollectionsKt.sortedWith((Iterable)object, (Comparator)comparator);
        if (issue2 != null) {
            Object v0;
            Iterable $receiver$iv$iv;
            void $receiver$iv2;
            void $receiver$iv$iv2;
            XdIssue xdIssue = (XdIssue)XdIssue.Companion.wrap(issue2);
            Object $receiver$iv22 = groupsByCount2;
            int capacity$iv232 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv22, (int)10)), (int)16);
            Iterable $i$f$sortedBy = $receiver$iv22;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv232);
            for (Object e2 : $receiver$iv$iv2) {
                Map map2 = destination$iv$iv;
                XdUserGroup it = (XdUserGroup)((Object)e2);
                Pair pair = new Pair((Object)it, (Object)this.getRelevance(it, xdIssue));
                map2.put(pair.getFirst(), pair.getSecond());
            }
            $receiver$iv22 = destination$iv$iv;
            void capacity$iv232 = $receiver$iv2;
            Object destination$iv$iv2 = new LinkedHashMap();
            Object e = $receiver$iv$iv;
            for (Map.Entry entry : e.entrySet()) {
                Map.Entry it = entry;
                if (((Number)it.getValue()).intValue() == 0) continue;
                destination$iv$iv2.put(entry.getKey(), entry.getValue());
            }
            object = destination$iv$iv2;
            $receiver$iv$iv = object.entrySet();
            if (!(destination$iv$iv2 = $receiver$iv$iv.iterator()).hasNext()) {
                v0 = null;
            } else {
                e = destination$iv$iv2.next();
                Map.Entry it = (Map.Entry)e;
                int n = ((Number)it.getValue()).intValue();
                while (destination$iv$iv2.hasNext()) {
                    Object e2 = destination$iv$iv2.next();
                    Map.Entry it2 = (Map.Entry)e2;
                    int n2 = ((Number)it2.getValue()).intValue();
                    if (n >= n2) continue;
                    e = e2;
                    n = n2;
                }
                v0 = e;
            }
            Map.Entry entry = v0;
            if (entry != null) {
                Object it = object = entry;
                return ((XdUserGroup)((Object)it.getKey())).getEntity();
            }
        }
        XdUserGroup xdUserGroup = (XdUserGroup)((Object)CollectionsKt.lastOrNull((List)groupsByCount2));
        return xdUserGroup != null ? xdUserGroup.getEntity() : null;
    }

    private final int getRelevance(@NotNull XdUserGroup $receiver, XdIssue issue2) {
        Set projects = jetbrains.charisma.persistent.BeansKt.getSecurity().getProjectsWithRoles($receiver.getEntity());
        return projects.contains(issue2.getProject().getEntity()) ? (projects.size() > 1 ? 50 : 100) : 0;
    }
}

