/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.statistics;

import jetbrains.charisma.statistics.DraftStatisticsService;
import jetbrains.youtrack.api.statistics.StatisticsFeatureDescription;
import jetbrains.youtrack.api.statistics.StatisticsService;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="draftStatisticsService")
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0017\u0018\u0000 \u00122\u00020\u0001:\u0002\u0012\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u001e\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u0014"}, d2={"Ljetbrains/charisma/statistics/DraftStatisticsServiceImpl;", "Ljetbrains/charisma/statistics/DraftStatisticsService;", "()V", "statisticsService", "Ljetbrains/youtrack/api/statistics/StatisticsService;", "getStatisticsService", "()Ljetbrains/youtrack/api/statistics/StatisticsService;", "setStatisticsService", "(Ljetbrains/youtrack/api/statistics/StatisticsService;)V", "findTimeBucket", "Ljetbrains/charisma/statistics/DraftStatisticsServiceImpl$TimeBucket;", "interval", "", "reportDraftCreation", "", "time", "newUi", "", "Companion", "TimeBucket", "youtrack-application"})
public class DraftStatisticsServiceImpl
implements DraftStatisticsService {
    @Autowired
    @NotNull
    public StatisticsService statisticsService;
    @NotNull
    private static final String MPS = "mps-new-issue";
    @NotNull
    private static final String ANG = "ang-new-issue";
    @NotNull
    private static final String AVERAGE = "-time";
    @NotNull
    private static final String COUNT = "-count";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final StatisticsService getStatisticsService() {
        StatisticsService statisticsService = this.statisticsService;
        if (statisticsService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"statisticsService");
        }
        return statisticsService;
    }

    public final void setStatisticsService(@NotNull StatisticsService statisticsService) {
        Intrinsics.checkParameterIsNotNull((Object)statisticsService, (String)"<set-?>");
        this.statisticsService = statisticsService;
    }

    @Override
    public void reportDraftCreation(long time, boolean newUi) {
        long seconds = time / (long)1000;
        TimeBucket timeBucket = this.findTimeBucket(seconds);
        if (timeBucket == null) {
            return;
        }
        TimeBucket bucket = timeBucket;
        String category = newUi ? ANG : MPS;
        StatisticsService statisticsService = this.statisticsService;
        if (statisticsService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"statisticsService");
        }
        statisticsService.incForInstance(new StatisticsFeatureDescription(category, bucket.getEventPrefix() + COUNT));
        StatisticsService statisticsService2 = this.statisticsService;
        if (statisticsService2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"statisticsService");
        }
        statisticsService2.incForInstance(new StatisticsFeatureDescription(category, bucket.getEventPrefix() + AVERAGE), seconds);
    }

    private final TimeBucket findTimeBucket(long interval) {
        TimeBucket timeBucket;
        block1: {
            TimeBucket[] $receiver$iv;
            for (TimeBucket element$iv : $receiver$iv = TimeBucket.values()) {
                TimeBucket it = element$iv;
                if (!it.matches(interval)) continue;
                timeBucket = element$iv;
                break block1;
            }
            timeBucket = null;
        }
        return timeBucket;
    }

    static {
        MPS = MPS;
        ANG = ANG;
        AVERAGE = AVERAGE;
        COUNT = COUNT;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\t\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u001f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016\u00a8\u0006\u0017"}, d2={"Ljetbrains/charisma/statistics/DraftStatisticsServiceImpl$TimeBucket;", "", "eventPrefix", "", "from", "", "to", "(Ljava/lang/String;ILjava/lang/String;JJ)V", "getEventPrefix", "()Ljava/lang/String;", "getFrom", "()J", "getTo", "matches", "", "interval", "INT_0_20", "INT_20_1", "INT_1_25", "INT_25_5", "INT_5_10", "INT_10_30", "INT_30", "youtrack-application"})
    public static final class TimeBucket
    extends Enum<TimeBucket> {
        public static final /* enum */ TimeBucket INT_0_20;
        public static final /* enum */ TimeBucket INT_20_1;
        public static final /* enum */ TimeBucket INT_1_25;
        public static final /* enum */ TimeBucket INT_25_5;
        public static final /* enum */ TimeBucket INT_5_10;
        public static final /* enum */ TimeBucket INT_10_30;
        public static final /* enum */ TimeBucket INT_30;
        private static final /* synthetic */ TimeBucket[] $VALUES;
        @NotNull
        private final String eventPrefix;
        private final long from;
        private final long to;

        static {
            TimeBucket[] timeBucketArray = new TimeBucket[7];
            TimeBucket[] timeBucketArray2 = timeBucketArray;
            timeBucketArray[0] = INT_0_20 = new TimeBucket("int-0-20", 0L, 20L);
            timeBucketArray[1] = INT_20_1 = new TimeBucket("int-20-1", 20L, 60L);
            timeBucketArray[2] = INT_1_25 = new TimeBucket("int-1-25", 60L, 150L);
            timeBucketArray[3] = INT_25_5 = new TimeBucket("int-25-5", 150L, 300L);
            timeBucketArray[4] = INT_5_10 = new TimeBucket("int-5-10", 300L, 600L);
            timeBucketArray[5] = INT_10_30 = new TimeBucket("int-10-30", 600L, 1800L);
            timeBucketArray[6] = INT_30 = new TimeBucket("int-30", 1800L, Long.MAX_VALUE);
            $VALUES = timeBucketArray;
        }

        public final boolean matches(long interval) {
            long l = interval;
            return this.from <= l && this.to - 1L >= l;
        }

        @NotNull
        public final String getEventPrefix() {
            return this.eventPrefix;
        }

        public final long getFrom() {
            return this.from;
        }

        public final long getTo() {
            return this.to;
        }

        protected TimeBucket(String eventPrefix, long from2, long to) {
            Intrinsics.checkParameterIsNotNull((Object)eventPrefix, (String)"eventPrefix");
            this.eventPrefix = eventPrefix;
            this.from = from2;
            this.to = to;
        }

        public static TimeBucket[] values() {
            return (TimeBucket[])$VALUES.clone();
        }

        public static TimeBucket valueOf(String string) {
            return Enum.valueOf(TimeBucket.class, string);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0014\u0010\u000b\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006\u00a8\u0006\r"}, d2={"Ljetbrains/charisma/statistics/DraftStatisticsServiceImpl$Companion;", "", "()V", "ANG", "", "getANG", "()Ljava/lang/String;", "AVERAGE", "getAVERAGE", "COUNT", "getCOUNT", "MPS", "getMPS", "youtrack-application"})
    public static final class Companion {
        @NotNull
        public final String getMPS() {
            return MPS;
        }

        @NotNull
        public final String getANG() {
            return ANG;
        }

        @NotNull
        public final String getAVERAGE() {
            return AVERAGE;
        }

        @NotNull
        public final String getCOUNT() {
            return COUNT;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

