/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.logging;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import jetbrains.charisma.main.LocalScoped;
import jetbrains.youtrack.api.misc.LogFile;
import jetbrains.youtrack.api.misc.LogFileService;
import jetbrains.youtrack.logging.Log4j2Factory;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.AppenderRef;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.config.Property;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

@Service(value="logFileService")
@LocalScoped
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0016\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u0012H\u0016J\"\u0010\u0013\u001a\u00020\u0010*\u00020\u00142\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0015\u001a\u00020\bH\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Ljetbrains/youtrack/logging/Log4j2FileService;", "Ljetbrains/youtrack/api/misc/LogFileService;", "()V", "debugCategories", "", "", "sourceCategories", "Ljava/util/concurrent/ConcurrentHashMap;", "Lorg/apache/logging/log4j/Level;", "traceCategories", "getDebugCategories", "getLogFile", "Ljava/io/File;", "logFile", "Ljetbrains/youtrack/api/misc/LogFile;", "setDebugCategories", "", "categories", "", "setLevel", "Lorg/apache/logging/log4j/core/config/Configuration;", "level", "youtrack-application"})
public final class Log4j2FileService
implements LogFileService {
    private final ConcurrentHashMap<String, Level> sourceCategories = new ConcurrentHashMap();
    private volatile List<String> debugCategories;
    private volatile List<String> traceCategories;

    @NotNull
    public File getLogFile(@NotNull LogFile logFile) {
        Intrinsics.checkParameterIsNotNull((Object)logFile, (String)"logFile");
        String string = logFile.name();
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = Log4j2Factory.getLogFolder$default(Log4j2Factory.INSTANCE, null, 1, null);
        String string3 = string;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).toLowerCase()");
        String string5 = string4;
        String string6 = stringBuilder.append(string5).append(".log").toString();
        String string7 = string2;
        return new File(string7, string6);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<String> getDebugCategories() {
        void var3_4;
        Collection<String> collection;
        void $receiver$iv$iv;
        void $receiver$iv;
        Iterable iterable = this.traceCategories;
        Collection collection2 = this.debugCategories;
        void var2_3 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            String string2 = (String)it + ":trace";
            collection.add(string2);
        }
        collection = (List)var3_4;
        return CollectionsKt.plus((Collection)collection2, (Iterable)collection);
    }

    public synchronized void setDebugCategories(@NotNull Iterable<String> categories) {
        String it;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull(categories, (String)"categories");
        Iterable iterable = categories;
        Log4j2FileService log4j2FileService = this;
        void var3_4 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            it = (String)element$iv$iv;
            if (!(!StringsKt.endsWith$default((String)it, (String)":trace", (boolean)false, (int)2, null))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Collection<String> collection = (List)destination$iv$iv;
        log4j2FileService.debugCategories = CollectionsKt.toList((Iterable)collection);
        $receiver$iv = categories;
        log4j2FileService = this;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            it = (String)element$iv$iv;
            if (!StringsKt.endsWith$default((String)it, (String)":trace", (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        collection = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv = (Iterable)collection;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            it = (String)item$iv$iv;
            collection = destination$iv$iv;
            String string = StringsKt.replace$default((String)it, (String)":trace", (String)"", (boolean)false, (int)4, null);
            collection.add(string);
        }
        collection = (List)destination$iv$iv;
        log4j2FileService.traceCategories = CollectionsKt.toList((Iterable)collection);
        org.apache.logging.log4j.spi.LoggerContext loggerContext = LogManager.getContext((boolean)false);
        if (loggerContext == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.apache.logging.log4j.core.LoggerContext");
        }
        LoggerContext ctx = (LoggerContext)loggerContext;
        Configuration config = ctx.getConfiguration();
        this.sourceCategories.forEach(new BiConsumer<String, Level>(config){
            final /* synthetic */ Configuration $config;

            public final void accept(@NotNull String category, @NotNull Level level) {
                Intrinsics.checkParameterIsNotNull((Object)category, (String)"category");
                Intrinsics.checkParameterIsNotNull((Object)level, (String)"level");
                LoggerConfig loggerConfig = this.$config.getLoggerConfig(category);
                Intrinsics.checkExpressionValueIsNotNull((Object)loggerConfig, (String)"config.getLoggerConfig(category)");
                loggerConfig.setLevel(level);
            }
            {
                this.$config = configuration;
            }
        });
        Configuration configuration = config;
        Intrinsics.checkExpressionValueIsNotNull((Object)configuration, (String)"config");
        Level level = Level.DEBUG;
        Intrinsics.checkExpressionValueIsNotNull((Object)level, (String)"Level.DEBUG");
        this.setLevel(configuration, this.debugCategories, level);
        Level level2 = Level.TRACE;
        Intrinsics.checkExpressionValueIsNotNull((Object)level2, (String)"Level.TRACE");
        this.setLevel(config, this.traceCategories, level2);
        ctx.updateLoggers();
    }

    private final void setLevel(@NotNull Configuration $receiver, List<String> categories, Level level) {
        Iterable $receiver$iv = categories;
        for (Object element$iv : $receiver$iv) {
            LoggerConfig loggerConfig;
            String category = (String)element$iv;
            LoggerConfig currentConfig = $receiver.getLoggerConfig(category);
            if ($receiver.getLoggers().containsKey(category)) {
                loggerConfig = currentConfig;
            } else {
                LoggerConfig config;
                Property[] propertyArray;
                AppenderRef[] appenderRefArray;
                Collection thisCollection$iv;
                Collection $receiver$iv2;
                org.apache.logging.log4j.spi.LoggerContext loggerContext = LogManager.getContext((boolean)false);
                if (loggerContext == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.apache.logging.log4j.core.LoggerContext");
                }
                LoggerContext ctx = (LoggerContext)loggerContext;
                LoggerConfig loggerConfig2 = currentConfig;
                Intrinsics.checkExpressionValueIsNotNull((Object)loggerConfig2, (String)"currentConfig");
                Level level2 = loggerConfig2.getLevel();
                String string = String.valueOf(currentConfig.isIncludeLocation());
                List list = currentConfig.getAppenderRefs();
                Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"currentConfig.appenderRefs");
                Collection collection = list;
                String string2 = string;
                String string3 = category;
                Level level3 = level2;
                boolean bl = true;
                if ($receiver$iv2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
                }
                if (thisCollection$iv.toArray(new AppenderRef[0]) == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                boolean bl2 = bl;
                Level level4 = level3;
                String string4 = string3;
                String string5 = string2;
                AppenderRef[] appenderRefArray2 = appenderRefArray;
                List list2 = currentConfig.getPropertyList();
                if (list2 != null) {
                    Property[] propertyArray2;
                    $receiver$iv2 = list2;
                    appenderRefArray = appenderRefArray2;
                    string2 = string5;
                    string3 = string4;
                    level3 = level4;
                    bl = bl2;
                    Collection collection2 = $receiver$iv2;
                    if (collection2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
                    }
                    thisCollection$iv = collection2;
                    if (thisCollection$iv.toArray(new Property[0]) == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                    }
                    bl2 = bl;
                    level4 = level3;
                    string4 = string3;
                    string5 = string2;
                    appenderRefArray2 = appenderRefArray;
                    propertyArray = propertyArray2;
                } else {
                    propertyArray = null;
                }
                LoggerConfig loggerConfig3 = config = LoggerConfig.createLogger((boolean)bl2, (Level)level4, (String)string4, (String)string5, (AppenderRef[])appenderRefArray2, propertyArray, (Configuration)ctx.getConfiguration(), (Filter)currentConfig.getFilter());
                Intrinsics.checkExpressionValueIsNotNull((Object)loggerConfig3, (String)"config");
                loggerConfig3.setParent(currentConfig);
                $receiver.addLogger(category, config);
                loggerConfig = config;
            }
            LoggerConfig config = loggerConfig;
            LoggerConfig loggerConfig4 = currentConfig;
            Intrinsics.checkExpressionValueIsNotNull((Object)loggerConfig4, (String)"currentConfig");
            this.sourceCategories.putIfAbsent(category, loggerConfig4.getLevel());
            LoggerConfig loggerConfig5 = config;
            Intrinsics.checkExpressionValueIsNotNull((Object)loggerConfig5, (String)"config");
            loggerConfig5.setLevel(level);
        }
    }

    public Log4j2FileService() {
        List list;
        Log4j2FileService log4j2FileService = this;
        log4j2FileService.debugCategories = list = CollectionsKt.emptyList();
        log4j2FileService = this;
        log4j2FileService.traceCategories = list = CollectionsKt.emptyList();
    }
}

