/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.logging;

import java.io.File;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import jetbrains.charisma.main.ConfigurationUtil;
import jetbrains.youtrack.logging.Log4j2Factory;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.appender.RollingFileAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import webr.framework.controller.WebLocalScope;

@Plugin(name="MultiplexingFileAppender", category="Core", elementType="appender")
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000 \u001a2\u00020\u0001:\u0002\u001a\u001bB/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u0003H\u0002J\b\u0010\u0019\u001a\u00020\u0014H\u0016R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001c"}, d2={"Ljetbrains/youtrack/logging/MultiplexingFileAppender;", "Lorg/apache/logging/log4j/core/appender/AbstractAppender;", "name", "", "file", "filter", "Lorg/apache/logging/log4j/core/Filter;", "layout", "Lorg/apache/logging/log4j/core/layout/PatternLayout;", "config", "Lorg/apache/logging/log4j/core/config/Configuration;", "(Ljava/lang/String;Ljava/lang/String;Lorg/apache/logging/log4j/core/Filter;Lorg/apache/logging/log4j/core/layout/PatternLayout;Lorg/apache/logging/log4j/core/config/Configuration;)V", "appenders", "", "Lorg/apache/logging/log4j/core/appender/RollingFileAppender;", "getConfig", "()Lorg/apache/logging/log4j/core/config/Configuration;", "getFile", "()Ljava/lang/String;", "append", "", "event", "Lorg/apache/logging/log4j/core/LogEvent;", "createAppender", "domain", "stop", "Companion", "RollingFileAppenderBuilder", "youtrack-application"})
public final class MultiplexingFileAppender
extends AbstractAppender {
    private final Map<String, RollingFileAppender> appenders;
    @NotNull
    private final String file;
    @NotNull
    private final Configuration config;
    private static final Map<String, MultiplexingFileAppender> appenderRegistry;
    @NotNull
    public static final String SERVER_SCOPED_LOGS = "$server-scoped-logs$";
    private static final String DEFAULT_LAYOUT = "%d{dd/MM/yy HH:mm:ss,SSS} %-5p [%X{requestId}@%-15.15t] [%-30.30c{1}] [%X{username}] %m%n";
    public static final Companion Companion;

    public void stop() {
        Iterable $receiver$iv = this.appenders.values();
        for (Object element$iv : $receiver$iv) {
            RollingFileAppender it = (RollingFileAppender)element$iv;
            it.stop();
        }
        this.appenders.clear();
    }

    public void append(@NotNull LogEvent event) {
        String domain2;
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        String mdcContext = (String)event.getContextData().getValue(WebLocalScope.MDC_SERVLET_CONTEXT_KEY);
        String string = (String)event.getContextData().getValue("domain");
        if (string == null) {
            string = domain2 = "local";
        }
        if (Intrinsics.areEqual((Object)SERVER_SCOPED_LOGS, (Object)domain2)) {
            Logger serverScopedLogger = LogManager.getLogger((String)"serverScoped");
            Object object = event.getMessage();
            if (object != null && (object = object.getFormattedMessage()) != null) {
                Object object2;
                Object it = object2 = object;
                serverScopedLogger.log(event.getLevel(), (String)it);
            }
        } else if (mdcContext == null && ConfigurationUtil.isYoutrackHosted()) {
            Logger fallbackLogger = LogManager.getLogger((String)"fallback");
            Object object = event.getMessage();
            if (object != null && (object = object.getFormattedMessage()) != null) {
                Object object3;
                Object it = object3 = object;
                fallbackLogger.log(event.getLevel(), "LOST MESSAGE: " + (String)it);
            }
            fallbackLogger.log(event.getLevel(), "No MDCContext found stacktrace:", (Throwable)new Exception("Stack trace marker:"));
        } else {
            RollingFileAppender appender = this.appenders.get(domain2);
            if (appender == null) {
                appender = this.createAppender(domain2);
            }
            appender.append(event);
        }
    }

    private final RollingFileAppender createAppender(String domain2) {
        String folder2 = Log4j2Factory.INSTANCE.getLogFolder(domain2);
        String filePath = new File(folder2, this.file).getAbsolutePath();
        RollingFileAppenderBuilder rollingFileAppenderBuilder = (RollingFileAppenderBuilder)((RollingFileAppenderBuilder)new RollingFileAppenderBuilder().withName(this.getName() + '@' + domain2)).withFileName(filePath);
        String string = filePath;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"filePath");
        RollingFileAppender appender = ((RollingFileAppenderBuilder)((RollingFileAppenderBuilder)((RollingFileAppenderBuilder)((RollingFileAppenderBuilder)((RollingFileAppenderBuilder)((RollingFileAppenderBuilder)rollingFileAppenderBuilder.withFilePattern(Log4j2Factory.INSTANCE.filePattern(string))).withLayout(this.getLayout())).withFilter(this.getFilter())).withCreateOnDemand(true)).withPolicy(Log4j2Factory.INSTANCE.triggeringPolicy())).withStrategy(Log4j2Factory.INSTANCE.rolloverStrategy(folder2, this.config))).build();
        Map<String, RollingFileAppender> map2 = this.appenders;
        RollingFileAppender rollingFileAppender = appender;
        Intrinsics.checkExpressionValueIsNotNull((Object)rollingFileAppender, (String)"appender");
        RollingFileAppender rollingFileAppender2 = rollingFileAppender;
        map2.put(domain2, rollingFileAppender2);
        return appender;
    }

    @NotNull
    public final String getFile() {
        return this.file;
    }

    @NotNull
    public final Configuration getConfig() {
        return this.config;
    }

    public MultiplexingFileAppender(@NotNull String name2, @NotNull String file, @Nullable Filter filter2, @NotNull PatternLayout layout, @NotNull Configuration config) {
        Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)layout, (String)"layout");
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        super(name2, filter2, (Layout)layout);
        this.file = file;
        this.config = config;
        this.appenders = new ConcurrentHashMap();
    }

    static {
        Companion = new Companion(null);
        appenderRegistry = new ConcurrentHashMap();
    }

    @JvmStatic
    @PluginFactory
    @NotNull
    public static final MultiplexingFileAppender create(@PluginAttribute(value="name") @NotNull String name2, @PluginAttribute(value="file") @NotNull String file, @PluginAttribute(value="layout") @Nullable String layout, @PluginElement(value="filter") @Nullable Filter filter2, @PluginConfiguration @NotNull Configuration configuration) {
        return Companion.create(name2, file, layout, filter2, configuration);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Ljetbrains/youtrack/logging/MultiplexingFileAppender$RollingFileAppenderBuilder;", "Lorg/apache/logging/log4j/core/appender/RollingFileAppender$Builder;", "()V", "youtrack-application"})
    public static final class RollingFileAppenderBuilder
    extends RollingFileAppender.Builder<RollingFileAppenderBuilder> {
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J>\u0010\t\u001a\u00020\b2\b\b\u0001\u0010\n\u001a\u00020\u00042\b\b\u0001\u0010\u000b\u001a\u00020\u00042\n\b\u0001\u0010\f\u001a\u0004\u0018\u00010\u00042\n\b\u0001\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\b\u0001\u0010\u000f\u001a\u00020\u0010H\u0007J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Ljetbrains/youtrack/logging/MultiplexingFileAppender$Companion;", "", "()V", "DEFAULT_LAYOUT", "", "SERVER_SCOPED_LOGS", "appenderRegistry", "", "Ljetbrains/youtrack/logging/MultiplexingFileAppender;", "create", "name", "file", "layout", "filter", "Lorg/apache/logging/log4j/core/Filter;", "configuration", "Lorg/apache/logging/log4j/core/config/Configuration;", "stop", "", "domain", "youtrack-application"})
    public static final class Companion {
        public final void stop(@NotNull String domain2) {
            Intrinsics.checkParameterIsNotNull((Object)domain2, (String)"domain");
            Iterable $receiver$iv = appenderRegistry.values();
            for (Object element$iv : $receiver$iv) {
                MultiplexingFileAppender it = (MultiplexingFileAppender)((Object)element$iv);
                RollingFileAppender rollingFileAppender = (RollingFileAppender)it.appenders.remove(domain2);
                if (rollingFileAppender == null) continue;
                rollingFileAppender.stop();
            }
        }

        @JvmStatic
        @PluginFactory
        @NotNull
        public final MultiplexingFileAppender create(@PluginAttribute(value="name") @NotNull String name2, @PluginAttribute(value="file") @NotNull String file, @PluginAttribute(value="layout") @Nullable String layout, @PluginElement(value="filter") @Nullable Filter filter2, @PluginConfiguration @NotNull Configuration configuration) {
            Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
            String string = layout;
            if (string == null) {
                string = MultiplexingFileAppender.DEFAULT_LAYOUT;
            }
            PatternLayout l = Log4j2Factory.INSTANCE.layout(string);
            MultiplexingFileAppender appender = new MultiplexingFileAppender(name2, file, filter2, l, configuration);
            appenderRegistry.put(name2, appender);
            return appender;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

