/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.markup;

import java.util.LinkedList;
import java.util.List;
import jetbrains.youtrack.markup.MarkdownProvider;
import jetbrains.youtrack.markup.extensions.CheckboxNode;
import jetbrains.youtrack.markup.extensions.ChecklistExtensionKt;
import jetbrains.youtrack.markup.extensions.RegexpExtractionResult;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.commonmark.node.AbstractVisitor;
import org.commonmark.node.Node;
import org.commonmark.node.Text;
import org.commonmark.node.Visitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0002J\u001e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000fJ\u001e\u0010\u0015\u001a\u0004\u0018\u00010\u000b*\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0011H\u0002R\u001e\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u0017"}, d2={"Ljetbrains/youtrack/markup/MarkdownCheckboxesService;", "", "()V", "markdownProvider", "Ljetbrains/youtrack/markup/MarkdownProvider;", "getMarkdownProvider", "()Ljetbrains/youtrack/markup/MarkdownProvider;", "setMarkdownProvider", "(Ljetbrains/youtrack/markup/MarkdownProvider;)V", "extractCheckboxes", "Ljava/util/LinkedList;", "Ljetbrains/youtrack/markup/extensions/CheckboxNode;", "node", "Lorg/commonmark/node/Node;", "updateCheckbox", "", "newState", "", "position", "", "text", "findCheckbox", "state", "youtrack-application"})
public final class MarkdownCheckboxesService {
    @Autowired
    @NotNull
    public MarkdownProvider markdownProvider;

    @NotNull
    public final MarkdownProvider getMarkdownProvider() {
        MarkdownProvider markdownProvider = this.markdownProvider;
        if (markdownProvider == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"markdownProvider");
        }
        return markdownProvider;
    }

    public final void setMarkdownProvider(@NotNull MarkdownProvider markdownProvider) {
        Intrinsics.checkParameterIsNotNull((Object)markdownProvider, (String)"<set-?>");
        this.markdownProvider = markdownProvider;
    }

    @NotNull
    public final String updateCheckbox(boolean newState, int position, @NotNull String text) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        List<RegexpExtractionResult> result2 = ChecklistExtensionKt.getCheckBoxPatternExtractor().extract(text);
        CheckboxNode oldCheckbox = this.findCheckbox(text, position, !newState);
        if (oldCheckbox != null) {
            String replacement = newState ? "[x]" : "[ ]";
            for (int tempPosition = position; tempPosition < result2.size(); ++tempPosition) {
                int n;
                String string = text;
                int n2 = result2.get(tempPosition).getStart();
                String newText = ((Object)StringsKt.replaceRange((CharSequence)string, (int)n2, (int)(n = result2.get(tempPosition).getEnd()), (CharSequence)replacement)).toString();
                CheckboxNode checkbox = this.findCheckbox(newText, position, newState);
                if (checkbox == null) continue;
                return newText;
            }
        }
        return text;
    }

    private final CheckboxNode findCheckbox(@NotNull String $receiver, int position, boolean state2) {
        Object v1;
        block2: {
            MarkdownProvider markdownProvider = this.markdownProvider;
            if (markdownProvider == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"markdownProvider");
            }
            Iterable $receiver$iv = this.extractCheckboxes(markdownProvider.getProcessor().parse($receiver));
            for (Object element$iv : $receiver$iv) {
                CheckboxNode it = (CheckboxNode)((Object)element$iv);
                if (!(it.getPosition() == position && it.getChecked() == state2 && it.getShouldRenderAsCheckbox())) continue;
                v1 = element$iv;
                break block2;
            }
            v1 = null;
        }
        return v1;
    }

    private final LinkedList<CheckboxNode> extractCheckboxes(Node node2) {
        LinkedList<CheckboxNode> checkboxes2 = new LinkedList<CheckboxNode>();
        node2.accept((Visitor)new AbstractVisitor(checkboxes2){
            final /* synthetic */ LinkedList $checkboxes;

            public void visit(@Nullable Text text) {
                if (text instanceof CheckboxNode) {
                    this.$checkboxes.add(text);
                }
            }
            {
                this.$checkboxes = $captured_local_variable$0;
            }
        });
        return checkboxes2;
    }
}

