/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.markup;

import java.util.LinkedList;
import java.util.List;
import jetbrains.youtrack.markup.MarkdownProcessingContextKt;
import jetbrains.youtrack.markup.MarkdownProcessor;
import jetbrains.youtrack.markup.extensions.ChecklistExtension;
import jetbrains.youtrack.markup.extensions.CustomTablesExtension;
import jetbrains.youtrack.markup.extensions.GoogleDocsExtension;
import jetbrains.youtrack.markup.extensions.ImageNameWithQuotesExtension;
import jetbrains.youtrack.markup.extensions.IssueAttachmentExtension;
import jetbrains.youtrack.markup.extensions.IssueLinkExtension;
import jetbrains.youtrack.markup.extensions.StacktraceExtension;
import jetbrains.youtrack.markup.extensions.UserLink;
import jetbrains.youtrack.markup.extensions.UserLinkExtension;
import jetbrains.youtrack.markup.internal.PatchInlineParserFactory;
import jetbrains.youtrack.persistent.XdIssue;
import jetbrains.youtrack.persistent.XdUser;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.commonmark.Extension;
import org.commonmark.ext.autolink.AutolinkExtension;
import org.commonmark.ext.gfm.strikethrough.StrikethroughExtension;
import org.commonmark.node.AbstractVisitor;
import org.commonmark.node.Link;
import org.commonmark.node.Node;
import org.commonmark.node.Visitor;
import org.commonmark.parser.InlineParserFactory;
import org.commonmark.parser.Parser;
import org.commonmark.renderer.html.AttributeProviderFactory;
import org.commonmark.renderer.html.HtmlNodeRendererFactory;
import org.commonmark.renderer.html.HtmlRenderer;
import org.commonmark.renderer.text.TextContentNodeRendererFactory;
import org.commonmark.renderer.text.TextContentRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u0011J:\u0010\u0015\u001a\u00020\u00112\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u0019R\u001c\u0010\u0003\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \u0006*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u0006*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Ljetbrains/youtrack/markup/MarkdownProcessor;", "", "()V", "extensions", "", "Lorg/commonmark/Extension;", "kotlin.jvm.PlatformType", "parser", "Lorg/commonmark/parser/Parser;", "removeMarkupRenderer", "Lorg/commonmark/renderer/text/TextContentRenderer;", "renderer", "Lorg/commonmark/renderer/html/HtmlRenderer;", "getMentionedUsers", "", "Ljetbrains/youtrack/persistent/XdUser;", "rawText", "", "parse", "Lorg/commonmark/node/Node;", "removeMarkup", "render", "issue", "Ljetbrains/youtrack/persistent/XdIssue;", "absoluteLinks", "", "noJs", "noCSS", "expandStacktraces", "youtrack-application"})
public final class MarkdownProcessor {
    private final List<Extension> extensions = CollectionsKt.listOf((Object[])new Extension[]{(Extension)new UserLinkExtension(), AutolinkExtension.create(), (Extension)new ImageNameWithQuotesExtension(), (Extension)new IssueAttachmentExtension(), (Extension)new IssueLinkExtension(), (Extension)new StacktraceExtension(), (Extension)new ChecklistExtension(), (Extension)new CustomTablesExtension(), StrikethroughExtension.create(), (Extension)new GoogleDocsExtension()});
    private final HtmlRenderer renderer;
    private final TextContentRenderer removeMarkupRenderer;
    private final Parser parser;

    @NotNull
    public final String render(@Nullable String rawText, @Nullable XdIssue issue2, boolean absoluteLinks, boolean noJs, boolean noCSS, boolean expandStacktraces) {
        return rawText == null ? "" : (String)MarkdownProcessingContextKt.markdownContext(issue2, absoluteLinks, noJs, noCSS, expandStacktraces, (Function0)new Function0<String>(this, rawText){
            final /* synthetic */ MarkdownProcessor this$0;
            final /* synthetic */ String $rawText;

            @NotNull
            public final String invoke() {
                String string = MarkdownProcessor.access$getRenderer$p(this.this$0).render(MarkdownProcessor.access$getParser$p(this.this$0).parse(this.$rawText));
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"renderer.render(parser.parse(rawText))");
                String renderedHtml = string;
                return "<div class=\"wiki text common-markdown\">" + renderedHtml + "</div>";
            }
            {
                this.this$0 = markdownProcessor;
                this.$rawText = string;
                super(0);
            }
        });
    }

    @NotNull
    public final String removeMarkup(@NotNull String rawText) {
        Intrinsics.checkParameterIsNotNull((Object)rawText, (String)"rawText");
        String string = this.removeMarkupRenderer.render(this.parser.parse(rawText));
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"removeMarkupRenderer.render(parser.parse(rawText))");
        return string;
    }

    @NotNull
    public final Node parse(@NotNull String rawText) {
        Intrinsics.checkParameterIsNotNull((Object)rawText, (String)"rawText");
        Object t = MarkdownProcessingContextKt.markdownContext(null, false, true, true, false, (Function0)new Function0<Node>(this, rawText){
            final /* synthetic */ MarkdownProcessor this$0;
            final /* synthetic */ String $rawText;

            public final Node invoke() {
                Node node2 = MarkdownProcessor.access$getParser$p(this.this$0).parse(this.$rawText);
                Intrinsics.checkExpressionValueIsNotNull((Object)node2, (String)"parser.parse(rawText)");
                return node2;
            }
            {
                this.this$0 = markdownProcessor;
                this.$rawText = string;
                super(0);
            }
        });
        Intrinsics.checkExpressionValueIsNotNull(t, (String)"markdownContext(null, fa\u2026.parse(rawText)\n        }");
        return (Node)t;
    }

    @NotNull
    public final Iterable<XdUser> getMentionedUsers(@NotNull String rawText) {
        Intrinsics.checkParameterIsNotNull((Object)rawText, (String)"rawText");
        Node parseResult = this.parse(rawText);
        LinkedList users2 = new LinkedList();
        parseResult.accept((Visitor)new AbstractVisitor(users2){
            final /* synthetic */ LinkedList $users;

            public void visit(@Nullable Link link) {
                if (link instanceof UserLink) {
                    this.$users.add(((UserLink)link).getEntity());
                }
            }
            {
                this.$users = $captured_local_variable$0;
            }
        });
        return users2;
    }

    public MarkdownProcessor() {
        HtmlRenderer.Builder builder = HtmlRenderer.builder();
        MarkdownProcessor markdownProcessor = this;
        HtmlRenderer.Builder $receiver = builder;
        $receiver.extensions((Iterable)this.extensions);
        $receiver.nodeRendererFactory((HtmlNodeRendererFactory)renderer.1.1.INSTANCE);
        $receiver.nodeRendererFactory((HtmlNodeRendererFactory)renderer.1.2.INSTANCE);
        $receiver.nodeRendererFactory((HtmlNodeRendererFactory)renderer.1.3.INSTANCE);
        $receiver.nodeRendererFactory((HtmlNodeRendererFactory)renderer.1.4.INSTANCE);
        $receiver.nodeRendererFactory((HtmlNodeRendererFactory)renderer.1.5.INSTANCE);
        $receiver.nodeRendererFactory((HtmlNodeRendererFactory)renderer.1.6.INSTANCE);
        $receiver.nodeRendererFactory((HtmlNodeRendererFactory)renderer.1.7.INSTANCE);
        $receiver.attributeProviderFactory((AttributeProviderFactory)renderer.1.8.INSTANCE);
        $receiver.escapeHtml(true);
        $receiver.percentEncodeUrls(true);
        $receiver.softbreak("<br/>");
        HtmlRenderer.Builder builder2 = builder;
        HtmlRenderer htmlRenderer = builder2.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)htmlRenderer, (String)"HtmlRenderer.builder().a\u2026r web pages\n    }.build()");
        markdownProcessor.renderer = htmlRenderer;
        builder = TextContentRenderer.builder();
        markdownProcessor = this;
        $receiver = builder;
        $receiver.stripNewlines(true);
        $receiver.extensions((Iterable)this.extensions);
        $receiver.nodeRendererFactory((TextContentNodeRendererFactory)removeMarkupRenderer.1.1.INSTANCE);
        $receiver.nodeRendererFactory((TextContentNodeRendererFactory)removeMarkupRenderer.1.2.INSTANCE);
        $receiver.nodeRendererFactory((TextContentNodeRendererFactory)removeMarkupRenderer.1.3.INSTANCE);
        builder2 = builder;
        markdownProcessor.removeMarkupRenderer = builder2.build();
        this.parser = Parser.builder().inlineParserFactory((InlineParserFactory)PatchInlineParserFactory.INSTANCE).extensions((Iterable)this.extensions).build();
    }

    @NotNull
    public static final /* synthetic */ HtmlRenderer access$getRenderer$p(MarkdownProcessor $this) {
        return $this.renderer;
    }

    public static final /* synthetic */ Parser access$getParser$p(MarkdownProcessor $this) {
        return $this.parser;
    }
}

