/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.markup.extensions;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jetbrains.youtrack.markup.extensions.GroupedPatternExtractor;
import jetbrains.youtrack.markup.extensions.RegexpExtractionResult;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0010\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J \u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u000fH\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0018"}, d2={"Ljetbrains/youtrack/markup/extensions/RegexpExtractor;", "Ljetbrains/youtrack/markup/extensions/GroupedPatternExtractor;", "pattern", "Ljava/util/regex/Pattern;", "groupIndex", "", "(Ljava/util/regex/Pattern;I)V", "getGroupIndex", "()I", "getPattern", "()Ljava/util/regex/Pattern;", "extract", "", "Ljetbrains/youtrack/markup/extensions/RegexpExtractionResult;", "text", "", "extractFromMatcher", "matcher", "Ljava/util/regex/Matcher;", "isApplicableMatchPosition", "", "start", "end", "inputText", "youtrack-application"})
public class RegexpExtractor
implements GroupedPatternExtractor {
    @NotNull
    private final Pattern pattern;
    private final int groupIndex;

    @Override
    @NotNull
    public List<RegexpExtractionResult> extract(@NotNull String text) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        Matcher matcher = this.pattern.matcher(text);
        LinkedList result2 = new LinkedList();
        while (matcher.find()) {
            if (!this.isApplicableMatchPosition(matcher.start(), matcher.end(), text)) continue;
            Collection collection = result2;
            Matcher matcher2 = matcher;
            Intrinsics.checkExpressionValueIsNotNull((Object)matcher2, (String)"matcher");
            RegexpExtractionResult regexpExtractionResult = this.extractFromMatcher(matcher2);
            collection.add(regexpExtractionResult);
        }
        return result2;
    }

    @NotNull
    protected RegexpExtractionResult extractFromMatcher(@NotNull Matcher matcher) {
        Intrinsics.checkParameterIsNotNull((Object)matcher, (String)"matcher");
        String string = matcher.group(this.groupIndex);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"matcher.group(groupIndex)");
        return new RegexpExtractionResult(string, matcher.start(), matcher.end());
    }

    protected boolean isApplicableMatchPosition(int start2, int end, @NotNull String inputText) {
        Intrinsics.checkParameterIsNotNull((Object)inputText, (String)"inputText");
        return true;
    }

    @NotNull
    public final Pattern getPattern() {
        return this.pattern;
    }

    public final int getGroupIndex() {
        return this.groupIndex;
    }

    public RegexpExtractor(@NotNull Pattern pattern, int groupIndex) {
        Intrinsics.checkParameterIsNotNull((Object)pattern, (String)"pattern");
        this.pattern = pattern;
        this.groupIndex = groupIndex;
    }

    public /* synthetic */ RegexpExtractor(Pattern pattern, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        this(pattern, n);
    }
}

