/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.markup.extensions;

import java.util.regex.Pattern;
import jetbrains.charisma.persistent.security.PrincipalsKt;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.youtrack.core.security.Permission;
import jetbrains.youtrack.markup.extensions.AbstractPostProcessor;
import jetbrains.youtrack.markup.extensions.RegexpExtractionResult;
import jetbrains.youtrack.markup.extensions.RegexpExtractor;
import jetbrains.youtrack.markup.extensions.RegexpLinkPostProcessor;
import jetbrains.youtrack.markup.extensions.UserLink;
import jetbrains.youtrack.markup.extensions.UserLinkExtension;
import jetbrains.youtrack.persistent.XdUser;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.dnq.XdExtensionsKt;
import org.commonmark.node.Node;
import org.commonmark.node.Text;
import org.commonmark.parser.Parser;
import org.commonmark.parser.PostProcessor;
import org.commonmark.renderer.html.HtmlNodeRendererFactory;
import org.commonmark.renderer.html.HtmlRenderer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\nB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Ljetbrains/youtrack/markup/extensions/UserLinkExtension;", "Lorg/commonmark/parser/Parser$ParserExtension;", "Lorg/commonmark/renderer/html/HtmlRenderer$HtmlRendererExtension;", "()V", "extend", "", "parserBuilder", "Lorg/commonmark/parser/Parser$Builder;", "rendererBuilder", "Lorg/commonmark/renderer/html/HtmlRenderer$Builder;", "UserLinkPostProcessor", "youtrack-application"})
public final class UserLinkExtension
implements Parser.ParserExtension,
HtmlRenderer.HtmlRendererExtension {
    public void extend(@NotNull Parser.Builder parserBuilder) {
        Intrinsics.checkParameterIsNotNull((Object)parserBuilder, (String)"parserBuilder");
        parserBuilder.postProcessor((PostProcessor)new UserLinkPostProcessor());
    }

    public void extend(@NotNull HtmlRenderer.Builder rendererBuilder) {
        Intrinsics.checkParameterIsNotNull((Object)rendererBuilder, (String)"rendererBuilder");
        rendererBuilder.nodeRendererFactory((HtmlNodeRendererFactory)extend.1.INSTANCE);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0007\u001a\u00060\bR\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Ljetbrains/youtrack/markup/extensions/UserLinkExtension$UserLinkPostProcessor;", "Ljetbrains/youtrack/markup/extensions/RegexpLinkPostProcessor;", "()V", "extractor", "Ljetbrains/youtrack/markup/extensions/RegexpExtractor;", "getExtractor", "()Ljetbrains/youtrack/markup/extensions/RegexpExtractor;", "replacementOf", "Ljetbrains/youtrack/markup/extensions/AbstractPostProcessor$ReplacementResult;", "Ljetbrains/youtrack/markup/extensions/AbstractPostProcessor;", "result", "Ljetbrains/youtrack/markup/extensions/RegexpExtractionResult;", "visit", "", "text", "Lorg/commonmark/node/Text;", "Companion", "youtrack-application"})
    public static final class UserLinkPostProcessor
    extends RegexpLinkPostProcessor {
        @NotNull
        private final RegexpExtractor extractor;
        private static final Pattern pattern;
        public static final Companion Companion;

        public void visit(@NotNull Text text) {
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            Entity entity2 = jetbrains.charisma.persistent.BeansKt.getLoggedInUserOrNull();
            if (entity2 != null) {
                if (PrincipalsKt.hasPermission(entity2, Permission.READ_PROFILE)) {
                    this.linkify(text);
                }
            }
        }

        @Override
        @NotNull
        public RegexpExtractor getExtractor() {
            return this.extractor;
        }

        @Override
        @NotNull
        public AbstractPostProcessor.ReplacementResult replacementOf(@NotNull RegexpExtractionResult result2) {
            int last;
            Node linkNode;
            XdUser referencedUser;
            Intrinsics.checkParameterIsNotNull((Object)result2, (String)"result");
            String login = result2.getExtracted();
            Entity entity2 = jetbrains.charisma.service.BeansKt.getUserFilterService().searchGreedyByLogin(login);
            XdUser xdUser = referencedUser = entity2 != null ? (XdUser)XdExtensionsKt.toXd((Entity)entity2) : null;
            if (referencedUser != null) {
                UserLink userLink;
                UserLink $receiver = userLink = new UserLink(referencedUser);
                boolean absoluteUrls = BeansKt.getMarkdownProcessingContext().getAbsoluteUrls();
                $receiver.setDestination(absoluteUrls ? jetbrains.charisma.service.BeansKt.getUserProfileService().getAbsoluteProfileUrl(referencedUser) : jetbrains.charisma.service.BeansKt.getUserProfileService().getRelativeProfileUrl(referencedUser));
                $receiver.setTitle(referencedUser.getFullName());
                $receiver.appendChild((Node)new Text("@" + referencedUser.getFullName()));
                linkNode = (Node)userLink;
                last = result2.getEnd() - (login.length() - referencedUser.getLogin().length());
            } else {
                linkNode = (Node)new Text("@" + login);
                last = result2.getEnd();
            }
            return new AbstractPostProcessor.ReplacementResult(last, linkNode);
        }

        public UserLinkPostProcessor() {
            Pattern pattern = UserLinkPostProcessor.pattern;
            Intrinsics.checkExpressionValueIsNotNull((Object)pattern, (String)"pattern");
            this.extractor = new RegexpExtractor(pattern, 2){

                protected boolean isApplicableMatchPosition(int start2, int end, @NotNull String inputText) {
                    char c;
                    Intrinsics.checkParameterIsNotNull((Object)inputText, (String)"inputText");
                    if (start2 == 0) {
                        return true;
                    }
                    Character prevChar = this.symbolAtPosition(start2 - 1, inputText);
                    return prevChar == null || !Character.isLetterOrDigit(c = prevChar.charValue());
                }

                private final Character symbolAtPosition(int symbolPosition, String text) {
                    return symbolPosition >= text.length() ? null : Character.valueOf(text.charAt(symbolPosition));
                }
            };
        }

        static {
            Companion = new Companion(null);
            pattern = Pattern.compile("([@])(([\\p{IsAlphabetic}0-9]|[+.|\\-=@_]){2,40})");
        }

        @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Ljetbrains/youtrack/markup/extensions/UserLinkExtension$UserLinkPostProcessor$Companion;", "", "()V", "pattern", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "youtrack-application"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

