/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.markup.renderer;

import java.util.Set;
import jetbrains.charisma.main.GapUrlUtilsKt;
import jetbrains.youtrack.markup.extensions.VideoNode;
import jetbrains.youtrack.persistent.XdIssue;
import jetbrains.youtrack.persistent.XdIssueAttachment;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.dnq.query.FilteringContext;
import kotlinx.dnq.query.XdFilteringQueryKt;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import org.commonmark.node.Node;
import org.commonmark.renderer.NodeRenderer;
import org.commonmark.renderer.html.HtmlNodeRendererContext;
import org.commonmark.renderer.html.HtmlWriter;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\bH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\nH\u0002J\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\nH\u0002J\u0010\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\nH\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Ljetbrains/youtrack/markup/renderer/VideoNodeRenderer;", "Lorg/commonmark/renderer/NodeRenderer;", "context", "Lorg/commonmark/renderer/html/HtmlNodeRendererContext;", "(Lorg/commonmark/renderer/html/HtmlNodeRendererContext;)V", "html", "Lorg/commonmark/renderer/html/HtmlWriter;", "getNodeTypes", "", "Ljava/lang/Class;", "Ljetbrains/youtrack/markup/extensions/VideoNode;", "render", "", "node", "Lorg/commonmark/node/Node;", "renderLink", "video", "renderVideo", "renderYouTubeVideo", "tryCurrentIssueAttachments", "", "destination", "youtrack-application"})
public final class VideoNodeRenderer
implements NodeRenderer {
    private final HtmlWriter html;
    private final HtmlNodeRendererContext context;

    @NotNull
    public Set<Class<VideoNode>> getNodeTypes() {
        return SetsKt.setOf(VideoNode.class);
    }

    public void render(@NotNull Node node2) {
        Intrinsics.checkParameterIsNotNull((Object)node2, (String)"node");
        VideoNode video = (VideoNode)node2;
        if (BeansKt.getMarkdownProcessingContext().getAbsoluteUrls()) {
            this.renderLink(video);
        } else if (video.isYouTubeVideo()) {
            this.renderYouTubeVideo(video);
        } else {
            this.renderVideo(video);
        }
    }

    private final void renderLink(VideoNode video) {
        String string = video.getDestination();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"video.destination");
        String href = this.tryCurrentIssueAttachments(string);
        this.html.tag("a", MapsKt.mapOf((Pair)TuplesKt.to((Object)"href", (Object)this.context.encodeUrl(href))));
        this.html.text(video.getTitle());
        this.html.tag("/a");
    }

    private final void renderVideo(VideoNode video) {
        this.html.tag("video", MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"controls", (Object)"true"), TuplesKt.to((Object)"allowfullscreen", (Object)"true"), TuplesKt.to((Object)"class", (Object)"width100")}));
        Pair[] pairArray = new Pair[2];
        String string = video.getDestination();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"video.destination");
        pairArray[0] = TuplesKt.to((Object)"src", (Object)this.context.encodeUrl(this.tryCurrentIssueAttachments(string)));
        pairArray[1] = TuplesKt.to((Object)"type", (Object)video.getMime());
        this.html.tag("source", MapsKt.mapOf((Pair[])pairArray));
        this.html.tag("/video");
    }

    private final void renderYouTubeVideo(VideoNode video) {
        this.html.tag("iframe", MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"src", (Object)this.context.encodeUrl("https://youtube.com/embed/" + video.getYouTubeVideoId())), TuplesKt.to((Object)"allowfullscreen", (Object)"true"), TuplesKt.to((Object)"frameborder", (Object)"0"), TuplesKt.to((Object)"width", (Object)"560"), TuplesKt.to((Object)"height", (Object)"315")}));
        this.html.tag("/iframe");
    }

    private final String tryCurrentIssueAttachments(String destination) {
        block1: {
            XdIssue xdIssue;
            XdIssue xdIssue2 = BeansKt.getMarkdownProcessingContext().getIssue();
            if (xdIssue2 == null) break block1;
            XdIssue issue2 = xdIssue = xdIssue2;
            XdIssueAttachment xdIssueAttachment = (XdIssueAttachment)XdQueryKt.firstOrNull((XdQuery)XdFilteringQueryKt.filter((XdQuery)((XdQuery)issue2.getAttachments()), (Function2)((Function2)new Function2<FilteringContext, XdIssueAttachment, Unit>(destination){
                final /* synthetic */ String $destination$inlined;
                {
                    this.$destination$inlined = string;
                    super(2);
                }

                public final void invoke(@NotNull FilteringContext $receiver, @NotNull XdIssueAttachment it) {
                    Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    $receiver.eq((Comparable)((Object)it.getName()), (Comparable)((Object)this.$destination$inlined));
                }
            })));
            if (xdIssueAttachment != null) {
                XdIssueAttachment xdIssueAttachment2;
                XdIssueAttachment it = xdIssueAttachment2 = xdIssueAttachment;
                return GapUrlUtilsKt.fileUrl$default(it, null, null, !BeansKt.getMarkdownProcessingContext().getAbsoluteUrls(), 3, null);
            }
        }
        return destination;
    }

    public VideoNodeRenderer(@NotNull HtmlNodeRendererContext context2) {
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        this.context = context2;
        HtmlWriter htmlWriter = this.context.getWriter();
        Intrinsics.checkExpressionValueIsNotNull((Object)htmlWriter, (String)"context.writer");
        this.html = htmlWriter;
    }
}

