/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.commands.impl;

import java.util.Locale;
import jetbrains.charisma.service.UserProfileService;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.baseLanguage.dates.runtime.DateTimeOperations;
import jetbrains.mps.internationalization.runtime.Localizer;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.youtrack.api.parser.Suggestion;
import jetbrains.youtrack.api.parser.SuggestionType;
import jetbrains.youtrack.core.dates.DateFormats;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormatter;

public class CachedRecentCommand
extends Suggestion {
    private final String comment;
    private final Iterable<Entity> visibleGroups;
    private final Iterable<Entity> visibleUsers;

    public CachedRecentCommand(CachedRecentCommand item) {
        super((Suggestion)item);
        this.comment = item.comment;
        this.visibleGroups = item.visibleGroups;
        this.visibleUsers = item.visibleUsers;
    }

    public CachedRecentCommand(Entity author, String command, String comment2, Iterable<Entity> groups, Iterable<Entity> users) {
        super(command, null, 0, 0, 0, 0, SuggestionType.CATEGORY_VALUE);
        this.setDescription(this.formatTimestamp(System.currentTimeMillis(), author));
        this.comment = comment2;
        this.visibleGroups = groups;
        this.visibleUsers = users;
    }

    public CachedRecentCommand(Entity author, String command, String comment2, Iterable<Entity> groups, Iterable<Entity> users, Long timestamp) {
        super(command, null, 0, 0, 0, 0, SuggestionType.CATEGORY_VALUE);
        this.setDescription(this.formatTimestamp(timestamp, author));
        this.comment = comment2;
        this.visibleGroups = groups;
        this.visibleUsers = users;
    }

    public String getComment() {
        return this.comment;
    }

    public Iterable<Entity> getVisibleGroups() {
        return this.visibleGroups;
    }

    public Iterable<Entity> getVisibleUsers() {
        return this.visibleUsers;
    }

    private String formatTimestamp(Long timestamp, Entity author) {
        return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("jetbrains.charisma.main.humanTimeWithPreposition", new Object[0]) + DateTimeOperations.print((DateTime)DateTimeOperations.convert((Long)timestamp, (DateTimeZone)((UserProfileService)ServiceLocator.getBean((String)"userProfileService")).getGeneralUserProfile(author).getTimeZone()), (DateTimeFormatter)DateFormats.INSTANCE.getFormatter("gmailLike"), (Locale)((Localizer)ServiceLocator.getBean((String)"localizer")).getLocale());
    }
}

