/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.commands.impl;

import com.jetbrains.teamsys.dnq.database.EntityOperations;
import java.util.ArrayList;
import java.util.List;
import jetbrains.charisma.persistent.IssueImpl;
import jetbrains.charisma.smartui.parser.date.DateFieldService;
import jetbrains.charisma.smartui.parser.date.DatePeriod;
import jetbrains.charisma.smartui.parser.filterCreator.BaseFieldNode;
import jetbrains.charisma.smartui.parser.filterCreator.IBaseFieldValue;
import jetbrains.charisma.smartui.parser.filterCreator.WriteableFieldNode;
import jetbrains.charisma.timeTracking.TimeTrackingProvider;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.baseLanguage.tuples.runtime.MultiTuple;
import jetbrains.mps.baseLanguage.tuples.runtime.Tuples;
import jetbrains.mps.internal.collections.runtime.IListSequence;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.internationalization.runtime.Localizer;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.api.commands.ICell;
import jetbrains.youtrack.api.commands.ICommand;
import jetbrains.youtrack.api.commands.ICommandExecutor;
import jetbrains.youtrack.api.commands.ICommandExecutorFactory;
import jetbrains.youtrack.api.commands.ICommandList;
import jetbrains.youtrack.api.commands.ICommandParser;
import jetbrains.youtrack.api.commands.ICommandParserPredicate;
import jetbrains.youtrack.api.commands.PredefinedCommandType;
import jetbrains.youtrack.api.parser.IContext;
import jetbrains.youtrack.api.parser.IField;
import jetbrains.youtrack.api.parser.IFieldValue;
import jetbrains.youtrack.api.parser.IPrefixTreesData;
import jetbrains.youtrack.commands.impl.AbstractCell;
import jetbrains.youtrack.commands.impl.AbstractTokensCell;
import jetbrains.youtrack.commands.impl.AddCommentCommandExecutor;
import jetbrains.youtrack.commands.impl.AddNewTagCommandExecutor;
import jetbrains.youtrack.commands.impl.AddWorkItemCommand;
import jetbrains.youtrack.commands.impl.AnyIssueIdCell;
import jetbrains.youtrack.commands.impl.Command;
import jetbrains.youtrack.commands.impl.CommandList;
import jetbrains.youtrack.commands.impl.CommandPrefixTreeUtil;
import jetbrains.youtrack.commands.impl.CommandType;
import jetbrains.youtrack.commands.impl.CommandTypeCell;
import jetbrains.youtrack.commands.impl.DeleteIssueCommandExecutor;
import jetbrains.youtrack.commands.impl.EofCell;
import jetbrains.youtrack.commands.impl.FieldCell;
import jetbrains.youtrack.commands.impl.FieldValueCell;
import jetbrains.youtrack.commands.impl.FieldValueRetriever;
import jetbrains.youtrack.commands.impl.HasIssuePermissionPredicate;
import jetbrains.youtrack.commands.impl.IIssueIdCell;
import jetbrains.youtrack.commands.impl.LinkCommandExecutor;
import jetbrains.youtrack.commands.impl.LinkedIssueIdCell;
import jetbrains.youtrack.commands.impl.NewTagCell;
import jetbrains.youtrack.commands.impl.OneCellCommand;
import jetbrains.youtrack.commands.impl.RemoveLinkCommandExecutor;
import jetbrains.youtrack.commands.impl.SpaceCell;
import jetbrains.youtrack.commands.impl.UnexpectedCell;
import jetbrains.youtrack.commands.impl.UnexpectedEofCell;
import jetbrains.youtrack.commands.impl.UnexpectedIssueIdCell;
import jetbrains.youtrack.commands.impl.UnexpectedIssueIdEofCell;
import jetbrains.youtrack.commands.impl.UnexpectedLinkedIssueIdCell;
import jetbrains.youtrack.commands.impl.UnexpectedLinkedIssueIdEofCell;
import jetbrains.youtrack.commands.impl.UnexpectedWorkItemDateOrDurationCell;
import jetbrains.youtrack.commands.impl.UnexpectedWorkItemDateOrDurationEofCell;
import jetbrains.youtrack.commands.impl.UnvoteIssueCommandExecutor;
import jetbrains.youtrack.commands.impl.VoteIssueCommandExecutor;
import jetbrains.youtrack.commands.impl.WorkItemDateOrDurationCell;
import jetbrains.youtrack.commands.impl.WorkItemDescriptionCell;
import jetbrains.youtrack.commands.impl.WorkTypeCell;
import jetbrains.youtrack.core.security.Operation;
import jetbrains.youtrack.parser.lexer.CharIterable;
import jetbrains.youtrack.parser.lexer.CharSequenceIterable;
import jetbrains.youtrack.parser.lexer.Tokenizer;
import jetbrains.youtrack.parser.lexer.Word;
import jetbrains.youtrack.parser.prefixTree.IPredicate;
import jetbrains.youtrack.parser.prefixTree.OrPredicate;
import jetbrains.youtrack.parser.prefixTree.PrefixIterable;
import jetbrains.youtrack.parser.prefixTree.PrefixIterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.Period;

public class CommandParser
implements ICommandParser {
    public static final String COLON = ":";
    public static final Iterable<String> PERIOD_TREE_KEY_SEQ = ListSequence.fromListAndArray(new ArrayList(), (Object[])new String[]{"PERIODS"});
    List<Word> tokens;
    IPrefixTreesData prefixGarden;
    IPredicate keywordPredicate;
    IPredicate fieldPredicate;
    IPredicate<IFieldValue> hasIssuePermissionPredicate;
    IPredicate everythingPredicate;
    CommandType currentCommandType;
    CommandType currentLinkType;
    CommandTypeCell currentCommandTypeCell;
    CommandTypeCell currentLinkTypeCell;
    IField currentField;
    FieldCell currentFieldCell;
    ICommandExecutorFactory currentCommandFactory;
    ICell currentFieldValueCell;
    ICell currentWorkDateCell;
    Long currentWorkDate;
    ICell currentWorkDurationCell;
    int currentWorkDuration;
    ICell currentWorkTypeCell;
    Entity currentWorkItemType;
    IIssueIdCell currentIssueIdCell;
    int currentToken = 0;
    ICommandList commandList;
    @NotNull
    IContext context;
    int commentStartToken;
    boolean hasAddTagCommandAtTheEnd;
    private IPrefixTreesData data;
    private State state;

    public CommandParser() {
        this.START_enter();
        this.state = State.START;
    }

    public ICommandList parse(IPrefixTreesData data, String command, @NotNull IContext ctx) {
        IContext.Activity oldActivity = ctx.getCurrentActivity();
        ctx.setCurrentActivity(null);
        this.init(data, command, ctx);
        this.parse();
        ctx.setCurrentActivity(oldActivity);
        return this.commandList;
    }

    private void init(IPrefixTreesData data, String command, @NotNull IContext ctx) {
        if (command == null) {
            command = "";
        }
        this.prefixGarden = data;
        this.data = data;
        this.context = ctx;
        this.keywordPredicate = new FieldValuePredicate(this);
        this.fieldPredicate = new FieldPredicate(this);
        this.hasIssuePermissionPredicate = new HasIssuePermissionPredicate();
        this.everythingPredicate = new OrPredicate(new IPredicate[]{this.keywordPredicate, this.fieldPredicate});
        this.tokens = Tokenizer.toWords((String)command, (boolean)false, (boolean)false);
        this.commandList = new CommandList(command, this.tokens, data, ctx);
    }

    private void parse() {
        while (this.currentToken < ListSequence.fromList(this.tokens).count()) {
            this.token();
        }
        this.eof();
    }

    String getCurrent() {
        return ((Word)ListSequence.fromList(this.tokens).getElement(this.currentToken)).getWord();
    }

    boolean isSpace() {
        return CommandParser.eq_75xrbp_a0a0e(this.getCurrent(), " ");
    }

    boolean isColon() {
        return CommandParser.eq_75xrbp_a0a0f(this.getCurrent(), COLON);
    }

    void createSpace() {
        ICell lastCell = this.commandList.getLastCell();
        if (lastCell instanceof UnexpectedCell) {
            ((UnexpectedCell)lastCell).getOneMoreToken();
        } else {
            Tuples._2<CommandType, IField> addForFieldAndType = this.getAddForFieldAndType();
            SpaceCell sc = new SpaceCell(this.currentToken, this.currentCommandType, this.currentField, (CommandType)addForFieldAndType._0(), (IField)addForFieldAndType._1());
            OneCellCommand c = new OneCellCommand(this.commandList, sc, null);
            this.commandList.addCommand((ICommand)c);
        }
        ++this.currentToken;
    }

    private Tuples._2<CommandType, IField> getAddForFieldAndType() {
        ICell lastCell = this.commandList.getLastCell();
        IField addForField = null;
        CommandType type2 = null;
        if (lastCell instanceof AbstractTokensCell) {
            AbstractTokensCell cell = (AbstractTokensCell)lastCell;
            addForField = cell.field;
            type2 = cell.commandType;
            if (addForField == null && cell instanceof SpaceCell) {
                addForField = cell.addForField;
                type2 = cell.commandType;
            }
        }
        return MultiTuple.from(type2, addForField);
    }

    private AbstractCell createUnexpectedCell(String whatIsExpected) {
        AbstractTokensCell errorCell;
        if (this.currentToken >= ListSequence.fromList(this.tokens).count()) {
            errorCell = new UnexpectedEofCell(ListSequence.fromList(this.tokens).count() - 1, ListSequence.fromList(this.tokens).isEmpty() ? 0 : ((Word)ListSequence.fromList(this.tokens).last()).getEndOffset(), this.currentCommandType, this.currentField, whatIsExpected);
        } else {
            Tuples._2<CommandType, IField> addForFieldAndType = this.getAddForFieldAndType();
            errorCell = new UnexpectedCell(this.currentToken, this.currentCommandType, this.currentField, whatIsExpected, (CommandType)addForFieldAndType._0(), (IField)addForFieldAndType._1());
        }
        return errorCell;
    }

    private AbstractCell creteEofCell() {
        Tuples._2<CommandType, IField> addForFieldAndType = this.getAddForFieldAndType();
        return new EofCell(ListSequence.fromList(this.tokens).count() - 1, ListSequence.fromList(this.tokens).isEmpty() ? 0 : ((Word)ListSequence.fromList(this.tokens).last()).getEndOffset(), (CommandType)addForFieldAndType._0(), (IField)addForFieldAndType._1());
    }

    void unexpectedEverything() {
        ICell lastCell = this.commandList.getLastCell();
        if (lastCell instanceof UnexpectedCell) {
            ((UnexpectedCell)lastCell).getOneMoreToken();
        } else {
            this.commandList.addCommand((ICommand)new Command(this.commandList, null, this.createUnexpectedCell(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("CommandParser.unknown_command", new Object[0]))));
        }
        ++this.currentToken;
    }

    void createEof() {
        this.commandList.addCommand((ICommand)new Command(this.commandList, null, this.creteEofCell()));
        ++this.currentToken;
    }

    void unexpectedFieldOrValue() {
        ICell lastCell = this.commandList.getLastCell();
        if (lastCell instanceof UnexpectedCell) {
            ((UnexpectedCell)lastCell).getOneMoreToken();
        } else {
            this.commandList.addCommand((ICommand)new Command(this.commandList, null, this.currentCommandTypeCell, this.currentLinkTypeCell, this.createUnexpectedCell(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("CommandParser.field_name_or_field_value_expected", new Object[0]))));
        }
        ++this.currentToken;
    }

    void unexpectedValueForField() {
        String whatIsExpected = null;
        if (this.isStarUnstar()) {
            this.currentField = (IField)ServiceLocator.getBean((String)"predefinedFieldStar");
            whatIsExpected = this.context.isSelectedIssuesAccessible(Operation.UPDATE_WATCHES) ? ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("CommandParser.User_login_expected", new Object[0]) : ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("CommandParser.You_have_no_permissions_to_update_issue_watchers", new Object[0]);
        } else {
            whatIsExpected = ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("CommandParser.{field_value}_expected", new Object[]{this.currentField.getPresentation()});
        }
        ICell lastCell = this.commandList.getLastCell();
        if (lastCell instanceof UnexpectedCell) {
            ((UnexpectedCell)lastCell).getOneMoreToken();
            ++this.currentToken;
        } else {
            Command command = new Command(this.commandList, null, this.currentCommandTypeCell, this.currentLinkTypeCell, this.currentFieldCell, this.createUnexpectedCell(whatIsExpected));
            this.commandList.addCommand((ICommand)command);
        }
        ++this.currentToken;
    }

    void unexpectedWorkDateOrPeriod() {
        this.unexpectedWorkDateOrPeriod(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("CommandParser.Work_item_date_or_period_is_expected", new Object[0]), (Iterable<String>)ListSequence.fromListAndArray(new ArrayList(), (Object[])new String[]{"DATE_TIME", "DATE_PERIOD", "PERIODS"}));
    }

    void unexpectedWorkTypeOrDateOrPeriod() {
        this.unexpectedWorkDateOrPeriod(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("CommandParser.Work_item_type_date_or_period_is_expected", new Object[0]), ((IField)ServiceLocator.getBean((String)"predefinedFieldWork")).getCommandTreeKeys());
    }

    void unexpectedWorkPeriod() {
        this.unexpectedWorkDateOrPeriod(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("CommandParser.Work_item_period_is_expected", new Object[0]), PERIOD_TREE_KEY_SEQ);
    }

    void unexpectedWorkDateOrPeriod(String expected, Iterable<String> trees) {
        AbstractTokensCell errorCell = null;
        if (this.currentToken >= ListSequence.fromList(this.tokens).count()) {
            errorCell = new UnexpectedWorkItemDateOrDurationEofCell(ListSequence.fromList(this.tokens).count() - 1, ListSequence.fromList(this.tokens).isEmpty() ? 0 : ((Word)ListSequence.fromList(this.tokens).last()).getEndOffset(), expected, trees, this.context);
        } else {
            ICell lastCell = this.commandList.getLastCell();
            if (lastCell instanceof UnexpectedCell) {
                ((UnexpectedCell)lastCell).getOneMoreToken();
            } else {
                errorCell = new UnexpectedWorkItemDateOrDurationCell(this.currentToken, expected, trees, this.context);
            }
        }
        if (errorCell != null) {
            this.commandList.addCommand((ICommand)new Command(this.commandList, null, this.currentCommandTypeCell, this.currentLinkTypeCell, this.currentFieldCell, this.currentWorkTypeCell, this.currentWorkDateCell, this.currentWorkDurationCell, errorCell));
        }
        ++this.currentToken;
    }

    private String getIssueIdExpectedText() {
        return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("CommandParser.issue_id_expected", new Object[0]);
    }

    void unexpectedIssueId(boolean afterAdd) {
        AbstractTokensCell errorCell = null;
        if (this.currentToken >= ListSequence.fromList(this.tokens).count()) {
            errorCell = new UnexpectedIssueIdEofCell(ListSequence.fromList(this.tokens).count() - 1, ListSequence.fromList(this.tokens).isEmpty() ? 0 : ((Word)ListSequence.fromList(this.tokens).last()).getEndOffset(), afterAdd ? this.currentLinkType : this.currentCommandType, this.currentField, this.getIssueIdExpectedText());
        } else {
            ICell lastCell = this.commandList.getLastCell();
            if (lastCell instanceof UnexpectedIssueIdCell) {
                ((UnexpectedIssueIdCell)lastCell).getOneMoreToken();
            } else {
                errorCell = new UnexpectedIssueIdCell(this.currentToken, afterAdd ? this.currentLinkType : this.currentCommandType, this.currentField, this.getIssueIdExpectedText());
            }
        }
        if (errorCell != null) {
            this.commandList.addCommand((ICommand)new Command(this.commandList, null, this.currentCommandTypeCell, this.currentLinkTypeCell, this.currentFieldCell, this.currentFieldValueCell, errorCell));
        }
        ++this.currentToken;
    }

    void unexpectedLinkedIssueId() {
        AbstractTokensCell errorCell = null;
        if (this.currentToken >= ListSequence.fromList(this.tokens).count()) {
            errorCell = new UnexpectedLinkedIssueIdEofCell(ListSequence.fromList(this.tokens).count() - 1, ListSequence.fromList(this.tokens).isEmpty() ? 0 : ((Word)ListSequence.fromList(this.tokens).last()).getEndOffset(), this.currentLinkType, this.currentField, this.getIssueIdExpectedText());
        } else {
            ICell lastCell = this.commandList.getLastCell();
            if (lastCell instanceof UnexpectedIssueIdCell) {
                ((UnexpectedIssueIdCell)lastCell).getOneMoreToken();
            } else {
                errorCell = new UnexpectedLinkedIssueIdCell(this.currentToken, this.currentLinkType, this.currentField, this.getIssueIdExpectedText());
            }
        }
        if (errorCell != null) {
            this.commandList.addCommand((ICommand)new Command(this.commandList, null, this.currentCommandTypeCell, this.currentLinkTypeCell, this.currentFieldCell, this.currentFieldValueCell, errorCell));
        }
        ++this.currentToken;
    }

    boolean tryCommandType() {
        int[] index = new int[]{this.currentToken};
        PrefixIterable<CommandType> tree = this.getCommandsTree();
        CommandType ct = (CommandType)ListSequence.fromList(this.getDeepestValue(tree, this.tokens, index, null)).first();
        if (ct != null) {
            this.currentCommandType = ct;
            this.currentCommandTypeCell = new CommandTypeCell(this.currentToken, index[0] - 1, ct);
            this.currentToken = index[0];
        }
        return this.currentCommandType != null;
    }

    boolean tryLinkType() {
        int[] index = new int[]{this.currentToken};
        PrefixIterable<CommandType> tree = this.getCommandsTree();
        CommandType ct = (CommandType)ListSequence.fromList(this.getDeepestValue(tree, this.tokens, index, null)).first();
        if (ct != null && ct.isLink()) {
            this.currentLinkType = ct;
            this.currentLinkTypeCell = new CommandTypeCell(this.currentToken, index[0] - 1, ct);
            this.currentToken = index[0];
        }
        return this.currentLinkType != null;
    }

    private PrefixIterable<CommandType> getCommandsTree() {
        return this.prefixGarden.getTree(CommandPrefixTreeUtil.COMMANDS_TREE_KEY);
    }

    boolean tryCommentCommandType() {
        if (this.currentCommandType.isPredefined() && this.currentCommandType.getPredefinedCommandType() == PredefinedCommandType.comment) {
            this.createCommentCommand();
            return true;
        }
        return false;
    }

    boolean tryDeleteCommandType() {
        if (this.currentCommandType.isPredefined() && this.currentCommandType.getPredefinedCommandType() == PredefinedCommandType.delete) {
            this.createCommandFromExecutor(new DeleteIssueCommandExecutor());
            return true;
        }
        return false;
    }

    boolean tryVoteCommandType() {
        if (this.currentCommandType.isPredefined() && (this.currentCommandType.getPredefinedCommandType() == PredefinedCommandType.vote || this.currentCommandType.getPredefinedCommandType() == PredefinedCommandType.plusOne)) {
            this.createCommandFromExecutor(new VoteIssueCommandExecutor());
            return true;
        }
        return false;
    }

    boolean tryUnvoteCommandType() {
        if (this.currentCommandType.isPredefined() && this.currentCommandType.getPredefinedCommandType() == PredefinedCommandType.unvote) {
            this.createCommandFromExecutor(new UnvoteIssueCommandExecutor());
            return true;
        }
        return false;
    }

    boolean tryFieldNameOrFieldValue() {
        Tuples._2<BaseFieldNode, int[]> field = this.getFieldIfExist();
        Tuples._2<ICommandExecutorFactory, int[]> keyword = this.getFieldValueIfExists();
        if ((keyword._1() != null && field._1() != null && ((int[])field._1())[0] >= ((int[])keyword._1())[0] || keyword._1() == null) && field._0() != null && this.isFieldValueSeparatorEnclosed(this.currentToken, ((int[])field._1())[0])) {
            this.fieldFound((BaseFieldNode)field._0(), (int[])field._1());
            this.field();
            return true;
        }
        if (keyword._0() != null && this.isFieldValueSeparatorEnclosed(this.currentToken, ((int[])keyword._1())[0])) {
            this.fieldValueFound((ICommandExecutorFactory)keyword._0(), (int[])keyword._1());
            this.fieldValue();
            return true;
        }
        return false;
    }

    private void fieldFound(BaseFieldNode field, int[] index) {
        this.currentField = field.getField();
        this.currentFieldCell = new FieldCell(this.currentToken, index[0] - 1, this.currentCommandType, this.currentField);
        this.currentToken = index[0];
        if (this.isCurrentPredefinedCommand(PredefinedCommandType.add)) {
            this.currentCommandFactory = this.currentField.getAddValueCommandExecutorFactory(this.context);
        } else if (this.isCurrentPredefinedCommand(PredefinedCommandType.remove)) {
            this.currentCommandFactory = this.currentField.getRemoveValueCommandExecutorFactory(this.context);
        }
    }

    Tuples._2<BaseFieldNode, int[]> getFieldIfExist() {
        int[] index = new int[]{this.currentToken};
        List<BaseFieldNode> fieldNodes = this.getDeepestValue(this.getCategoryTree(), this.tokens, index, this.fieldPredicate);
        BaseFieldNode f = (BaseFieldNode)this.data.min("CATEGORY", fieldNodes);
        return MultiTuple.from((Object)f, (Object)index);
    }

    private PrefixIterable<BaseFieldNode> getCategoryTree() {
        return this.prefixGarden.getTree("CATEGORY");
    }

    boolean tryFieldValue() {
        Tuples._2<ICommandExecutorFactory, int[]> pair = this.getFieldValueIfExists();
        if (pair._0() != null && this.isFieldValueSeparatorEnclosed(this.currentToken, ((int[])pair._1())[0])) {
            this.fieldValueFound((ICommandExecutorFactory)pair._0(), (int[])pair._1());
            return true;
        }
        return false;
    }

    private boolean isFieldValueSeparatorEnclosed(int startToken, int endToken) {
        return !(startToken != 0 && !this.isFieldValueSeparator(startToken - 1) || endToken != this.tokens.size() && !this.isFieldValueSeparator(endToken));
    }

    private boolean isFieldValueSeparator(int token) {
        Word word = this.tokens.get(token);
        return word.getType().equals((Object)Word.Type.SPACE) || word.getWord().equals(COLON);
    }

    boolean tryWorkDateOrDurationValue() {
        return this.tryWorkDurationFieldValue(((IField)ServiceLocator.getBean((String)"predefinedFieldWork")).getTreeKeys());
    }

    boolean tryWorkDurationValue() {
        return this.tryWorkDurationFieldValue(PERIOD_TREE_KEY_SEQ);
    }

    boolean tryWorkDurationFieldValue(Iterable<String> trees) {
        Tuples._2<ICommandExecutorFactory, int[]> pair = this.getFieldValueIfExists(trees, null);
        if (pair._0() != null) {
            this.workItemFieldValueFound((ICommandExecutorFactory)pair._0(), (int[])pair._1(), trees);
            return true;
        }
        return false;
    }

    boolean isStarUnstar() {
        return ((IField)ServiceLocator.getBean((String)"predefinedFieldStar")).equals(this.currentField) || this.currentCommandType != null && PredefinedCommandType.unstar.equals((Object)this.currentCommandType.getPredefinedCommandType());
    }

    boolean isWorkField() {
        return ((IField)ServiceLocator.getBean((String)"predefinedFieldWork")).equals(this.currentField);
    }

    boolean tryIssueId(boolean linked) {
        int[] index = new int[]{this.currentToken};
        PrefixIterable tree = this.prefixGarden.getTree("ISSUE_ID");
        IFieldValue i = (IFieldValue)ListSequence.fromList(this.getDeepestValue(tree, this.tokens, index, this.hasIssuePermissionPredicate)).first();
        if (i != null) {
            int endToken = index[0] >= ListSequence.fromList(this.tokens).count() ? index[0] - 1 : index[0];
            this.currentIssueIdCell = linked ? new LinkedIssueIdCell(this.currentToken, endToken, (IFieldValue<Entity>)i, this.currentLinkType.getLinkPrototype(), this.currentLinkType.getOuward()) : new AnyIssueIdCell(this.currentToken, endToken, (IFieldValue<Entity>)i);
            this.currentToken = index[0];
            return true;
        }
        return false;
    }

    boolean tryWorkItemType() {
        Tuples._2<ICommandExecutorFactory, int[]> pair = this.getFieldValueIfExists((Iterable<String>)Sequence.singleton((Object)"WORK_ITEM_TYPES"), ((TimeTrackingProvider)ServiceLocator.getBean((String)"timeTrackingProvider")).createWorkTypeFieldValuePredicate(this.context));
        ICommandExecutorFactory i = (ICommandExecutorFactory)pair._0();
        int[] index = (int[])pair._1();
        if (i != null) {
            this.currentCommandFactory = i;
            this.currentFieldValueCell = new WorkTypeCell(this.currentToken, index[0] - 1, (Iterable<String>)Sequence.singleton((Object)"WORK_ITEM_TYPES"));
            this.currentToken = index[0];
            return true;
        }
        return false;
    }

    Tuples._2<ICommandExecutorFactory, int[]> getFieldValueIfExists() {
        Iterable treeKeys = this.currentField != null ? this.currentField.getCommandTreeKeys() : this.data.getFilterTreeKeys();
        return this.getFieldValueIfExists(treeKeys, this.keywordPredicate);
    }

    Tuples._2<ICommandExecutorFactory, int[]> getFieldValueIfExists(Iterable<String> treeKeys, @Nullable IPredicate predicate) {
        int[] index = new int[1];
        int longest = this.currentToken;
        ICommandExecutorFactory globalFactory = null;
        for (String treeKey : Sequence.fromIterable(treeKeys)) {
            index[0] = this.currentToken;
            PrefixIterable tree = this.prefixGarden.getTree(treeKey);
            ICommandExecutorFactory localFactory = (ICommandExecutorFactory)ListSequence.fromList(this.getDeepestValue(tree, this.tokens, index, predicate)).first();
            if (localFactory == null || index[0] <= longest) continue;
            longest = index[0];
            globalFactory = localFactory;
        }
        if (globalFactory != null) {
            index[0] = longest;
            return MultiTuple.from(globalFactory, (Object)index);
        }
        return MultiTuple.from((Object)null, (Object)null);
    }

    private <T> List<T> getDeepestValue(PrefixIterable<T> tree, List<Word> tokens, int[] start2, @Nullable IPredicate predicate) {
        boolean exists;
        IListSequence lastValues = null;
        int lastValueIndex = -1;
        PrefixIterator iterator = tree.prefixIterator();
        for (int i = start2[0]; i < ListSequence.fromList(tokens).count() && (exists = iterator.move((CharIterable)new CharSequenceIterable((CharSequence)((Word)ListSequence.fromList(tokens).getElement(i)).getWord()))); ++i) {
            IListSequence values = Sequence.fromIterable((Iterable)iterator.getValues(predicate)).toListSequence();
            if (!ListSequence.fromList((List)values).isNotEmpty()) continue;
            lastValues = values;
            lastValueIndex = i;
        }
        if (lastValues != null) {
            start2[0] = lastValueIndex + 1;
        }
        return lastValues;
    }

    void fieldValueFound(ICommandExecutorFactory factory, int[] index) {
        this.currentCommandFactory = factory;
        this.currentFieldValueCell = new FieldValueCell(this.currentToken, index[0] - 1, this.currentCommandType, this.currentField);
        this.currentToken = index[0];
    }

    void workItemFieldValueFound(ICommandExecutorFactory fieldValue, int[] index, Iterable<String> trees) {
        this.currentCommandFactory = fieldValue;
        this.currentFieldValueCell = new WorkItemDateOrDurationCell(this.currentToken, index[0] - 1, trees);
        this.currentToken = index[0];
    }

    void createEmptyCommand() {
        Command c = new Command(this.commandList, null, this.currentCommandTypeCell, this.currentLinkTypeCell, this.currentFieldCell, this.currentFieldValueCell);
        this.commandList.addCommand((ICommand)c);
        this.reset();
    }

    void createCommentCommand() {
        Command c = new Command(this.commandList, new AddCommentCommandExecutor(), this.currentCommandTypeCell, this.currentLinkTypeCell, this.currentFieldCell, this.currentFieldValueCell);
        this.commandList.addCommand((ICommand)c);
        this.reset();
    }

    void createCommandFromExecutor(ICommandExecutor executor) {
        Command c = new Command(this.commandList, executor, this.currentCommandTypeCell);
        this.commandList.addCommand((ICommand)c);
        this.reset();
    }

    void createCommand() {
        this.hasAddTagCommandAtTheEnd = this.currentCommandIsAddTag();
        if (this.isStarUnstar()) {
            this.currentField = (IField)ServiceLocator.getBean((String)"predefinedFieldStar");
        }
        Command command = new Command(this.commandList, this.currentCommandFactory.create(this.commandList, this.currentCommandType == null ? null : this.currentCommandType.getPredefinedCommandType(), this.currentField, this.context), this.currentCommandTypeCell, this.currentLinkTypeCell, this.currentFieldCell, this.currentFieldValueCell);
        this.commandList.addCommand((ICommand)command);
        this.reset();
    }

    boolean currentCommandIsAddTag() {
        return (this.isCurrentPredefinedCommand(PredefinedCommandType.add) || this.currentCommandType == null) && this.isCurrentField((IField)ServiceLocator.getBean((String)"predefinedFieldTag"));
    }

    void createLinkCommand() {
        LinkCommandExecutor executor = null;
        if (!EntityOperations.equals((Entity)this.currentIssueIdCell.getIssue(), null)) {
            executor = new LinkCommandExecutor(this.context, this.currentCommandType.getLinkPrototype(), this.currentCommandType.getOuward(), this.currentIssueIdCell.getIssue());
        }
        Command c = new Command(this.commandList, executor, this.currentCommandTypeCell, this.currentLinkTypeCell, this.currentFieldCell, this.currentFieldValueCell, this.currentIssueIdCell);
        this.commandList.addCommand((ICommand)c);
        this.reset();
    }

    void createAddLinkCommand() {
        LinkCommandExecutor executor = null;
        if (!EntityOperations.equals((Entity)this.currentIssueIdCell.getIssue(), null)) {
            executor = new LinkCommandExecutor(this.context, this.currentLinkType.getLinkPrototype(), this.currentLinkType.getOuward(), this.currentIssueIdCell.getIssue());
        }
        Command c = new Command(this.commandList, executor, this.currentCommandTypeCell, this.currentLinkTypeCell, this.currentFieldCell, this.currentFieldValueCell, this.currentIssueIdCell);
        this.commandList.addCommand((ICommand)c);
        this.reset();
    }

    void createRemoveLinkCommand() {
        RemoveLinkCommandExecutor executor = null;
        if (!EntityOperations.equals((Entity)this.currentIssueIdCell.getIssue(), null)) {
            executor = new RemoveLinkCommandExecutor(this.context, this.currentLinkType.getLinkPrototype(), this.currentLinkType.getOuward(), this.currentIssueIdCell.getIssue());
        }
        Command c = new Command(this.commandList, executor, this.currentCommandTypeCell, this.currentLinkTypeCell, this.currentFieldCell, this.currentFieldValueCell, this.currentIssueIdCell);
        this.commandList.addCommand((ICommand)c);
        this.reset();
    }

    void createNewTagCommand() {
        this.hasAddTagCommandAtTheEnd = true;
        AddNewTagCommandExecutor executor = new AddNewTagCommandExecutor(this.commandList.getText().substring(((Word)ListSequence.fromList(this.tokens).getElement(this.currentToken)).getStartOffset(), ((Word)ListSequence.fromList(this.tokens).getElement(this.currentToken)).getEndOffset()));
        NewTagCell cell = new NewTagCell(this.currentToken, this.currentToken, this.currentCommandType, this.currentField);
        Command c = new Command(this.commandList, executor, this.currentCommandTypeCell, this.currentLinkTypeCell, this.currentFieldCell, cell);
        this.commandList.addCommand((ICommand)c);
        this.reset();
        ++this.currentToken;
    }

    void updateLastTagCommand() {
        ICell lastCell = this.commandList.getLastCell();
        while (lastCell.getCommand().getCommandExecutor() == null) {
            this.commandList.removeCommand(lastCell.getCommand());
            lastCell = this.commandList.getLastCell();
        }
        ICommand command = lastCell.getCommand();
        int startToken = command.getLastCell().getStartToken();
        int endStringPosition = this.currentToken < this.tokens.size() - 1 ? ((Word)ListSequence.fromList(this.tokens).getElement(this.currentToken)).getEndOffset() : this.commandList.getText().length();
        AddNewTagCommandExecutor executor = new AddNewTagCommandExecutor(this.commandList.getText().substring(((Word)ListSequence.fromList(this.tokens).getElement(startToken)).getStartOffset(), endStringPosition));
        AbstractTokensCell firstCell = CommandParser.as_75xrbp_a0a6a65(Sequence.fromIterable((Iterable)command.getCells()).first(), AbstractTokensCell.class);
        CommandType commandType = firstCell == null ? new CommandType(PredefinedCommandType.add) : firstCell.commandType;
        FieldValueCell newCell = new FieldValueCell(startToken, this.currentToken, commandType, command.getCommandExecutor().getField());
        ICell[] cells = (ICell[])Sequence.fromIterable((Iterable)command.getCells()).toGenericArray(ICell.class);
        cells[cells.length - 1] = newCell;
        Command newCommand = new Command(this.commandList, executor, cells);
        this.commandList.removeCommand(command);
        this.commandList.addCommand((ICommand)newCommand);
        this.reset();
        ++this.currentToken;
    }

    void createAddWorkItemCommand() {
        String description2 = this.currentToken < ListSequence.fromList(this.tokens).count() ? CommandParser.trim_75xrbp_a0a0b0fc(this.commandList.getText().substring(((Word)ListSequence.fromList(this.tokens).getElement(this.currentToken)).getStartOffset())) : null;
        ICommandExecutor executor = ((TimeTrackingProvider)ServiceLocator.getBean((String)"timeTrackingProvider")).createWorkItemCommandExecutor(this.currentWorkItemType, this.currentWorkDate, this.currentWorkDuration, description2);
        WorkItemDescriptionCell descriptionCell = null;
        if (this.currentToken < ListSequence.fromList(this.tokens).count()) {
            int firstDescriptionToken;
            for (firstDescriptionToken = this.currentToken; firstDescriptionToken < ListSequence.fromList(this.tokens).count() && CommandParser.isEmpty_75xrbp_a0a1a5a75(CommandParser.trim_75xrbp_a0a0b0f0fc(((Word)ListSequence.fromList(this.tokens).getElement(firstDescriptionToken)).getWord())); ++firstDescriptionToken) {
            }
            if (firstDescriptionToken != ListSequence.fromList(this.tokens).count()) {
                descriptionCell = new WorkItemDescriptionCell(firstDescriptionToken, this.tokens.size() - 1);
            }
        }
        AddWorkItemCommand c = new AddWorkItemCommand(this.commandList, executor, this.currentCommandTypeCell, this.currentFieldCell, this.currentWorkTypeCell, this.currentWorkDateCell, this.currentWorkDurationCell, descriptionCell);
        this.commandList.addCommand((ICommand)c);
        if (descriptionCell != null) {
            this.currentToken = this.tokens.size();
        }
    }

    void processWorkItemPeriod() {
        this.currentWorkDurationCell = this.currentFieldValueCell;
        Period period = (Period)((IFieldValue)this.currentCommandFactory).getFieldValue();
        this.currentWorkDuration = ((TimeTrackingProvider)ServiceLocator.getBean((String)"timeTrackingProvider")).getMinutes(period);
        this.createAddWorkItemCommand();
    }

    void processWorkItemDuration() {
        this.currentWorkDateCell = this.currentFieldValueCell;
        this.currentWorkDate = ((DatePeriod)((IFieldValue)this.currentCommandFactory).getFieldValue()).getFrom();
    }

    void reset() {
        this.currentField = null;
        this.currentCommandType = null;
        this.currentLinkType = null;
        this.currentLinkTypeCell = null;
        this.currentFieldCell = null;
        this.currentCommandTypeCell = null;
        this.currentFieldValueCell = null;
        this.currentCommandFactory = null;
        this.currentIssueIdCell = null;
        this.currentWorkTypeCell = null;
        this.currentWorkDate = System.currentTimeMillis();
    }

    boolean isCompositeCommandType() {
        CommandType type2 = this.currentCommandType;
        if (type2.isPredefined() && type2.getPredefinedCommandType().isComposite()) {
            PredefinedCommandType predefinedType = type2.getPredefinedCommandType();
            this.currentCommandType = new CommandType(predefinedType.getCommand());
            this.currentField = predefinedType.getCategory();
            return true;
        }
        return false;
    }

    public void token() {
        switch (this.state) {
            case START: {
                if (this.isSpace()) {
                    this.createSpace();
                    break;
                }
                if (this.tryCommandType()) {
                    this.state = State.COMMAND_TYPE;
                    break;
                }
                if (this.tryFieldNameOrFieldValue()) break;
                if (this.hasAddTagCommandAtTheEnd) {
                    this.updateLastTagCommand();
                    this.state = State.START;
                    this.START_enter();
                    break;
                }
                this.unexpectedEverything();
                this.state = State.START;
                this.START_enter();
                break;
            }
            case COMMAND_TYPE: {
                if (this.tryCommentCommandType()) {
                    this.state = State.START;
                    this.START_enter();
                    break;
                }
                if (this.isCompositeCommandType()) {
                    this.state = State.COLON_AFTER_FIELD_NAME;
                    break;
                }
                if (this.tryDeleteCommandType()) {
                    this.state = State.START;
                    this.START_enter();
                    break;
                }
                if (this.tryVoteCommandType()) {
                    this.state = State.START;
                    this.START_enter();
                    break;
                }
                if (this.tryUnvoteCommandType()) {
                    this.state = State.START;
                    this.START_enter();
                    break;
                }
                this.state = State.COLON_AFTER_COMMAND_TYPE;
                break;
            }
            case SPACE_OR_COLON_AFTER_COMMAND_TYPE: {
                if (this.isSpace() && this.currentCommandType.isPredefined()) {
                    ++this.currentToken;
                    this.state = State.FIELD_NAME_OR_FIELD_VALUE;
                    break;
                }
                if (this.isSpace() && this.currentCommandType.isLink()) {
                    ++this.currentToken;
                    this.state = State.ISSUE_ID;
                    break;
                }
                if (this.currentCommandType.isPredefined()) {
                    this.unexpectedFieldOrValue();
                    this.state = State.START;
                    this.START_enter();
                    break;
                }
                if (!this.currentCommandType.isLink()) break;
                this.unexpectedIssueId(false);
                this.state = State.START;
                this.START_enter();
                break;
            }
            case COLON_AFTER_COMMAND_TYPE: {
                if (this.isColon() && this.currentCommandType.isLink()) {
                    ++this.currentToken;
                    this.state = State.SPACE_AFTER_COMMAND_TYPE;
                    break;
                }
                if (this.isSpace() && this.currentCommandType.isPredefined()) {
                    ++this.currentToken;
                    this.state = State.FIELD_NAME_OR_FIELD_VALUE;
                    break;
                }
                if (this.isSpace() && this.currentCommandType.isLink()) {
                    ++this.currentToken;
                    this.state = State.ISSUE_ID;
                    break;
                }
                if (this.currentCommandType.isPredefined()) {
                    this.unexpectedFieldOrValue();
                    this.state = State.START;
                    this.START_enter();
                    break;
                }
                if (!this.currentCommandType.isLink()) break;
                this.unexpectedIssueId(false);
                this.state = State.START;
                this.START_enter();
                break;
            }
            case SPACE_AFTER_COMMAND_TYPE: {
                if (this.isSpace() && this.currentCommandType.isPredefined()) {
                    ++this.currentToken;
                    this.state = State.FIELD_NAME_OR_FIELD_VALUE;
                    break;
                }
                if (this.isSpace() && this.currentCommandType.isLink()) {
                    ++this.currentToken;
                    this.state = State.ISSUE_ID;
                    break;
                }
                if (this.currentCommandType.isPredefined()) {
                    this.unexpectedFieldOrValue();
                    this.state = State.START;
                    this.START_enter();
                    break;
                }
                if (!this.currentCommandType.isLink()) break;
                this.unexpectedIssueId(false);
                this.state = State.START;
                this.START_enter();
                break;
            }
            case FIELD_NAME_OR_FIELD_VALUE: {
                if (this.tryLinkType()) {
                    this.state = State.COLON_AFTER_LINK_TYPE;
                    break;
                }
                if (this.tryFieldNameOrFieldValue()) break;
                this.unexpectedFieldOrValue();
                this.state = State.START;
                this.START_enter();
                break;
            }
            case SPACE_OR_COLON_AFTER_FIELD_NAME: {
                if (this.isSpace() && this.isWorkField()) {
                    ++this.currentToken;
                    this.state = State.WORK_ITEM_TYPE_OR_DATE_OR_PERIOD;
                    break;
                }
                if (this.isSpace() && this.isWorkField()) {
                    ++this.currentToken;
                    this.state = State.WORK_ITEM_DATE_OR_PERIOD;
                    break;
                }
                if (this.isSpace()) {
                    ++this.currentToken;
                    this.state = State.FIELD_VALUE;
                    break;
                }
                this.unexpectedValueForField();
                this.state = State.START;
                this.START_enter();
                break;
            }
            case COLON_AFTER_FIELD_NAME: {
                if (this.isColon()) {
                    ++this.currentToken;
                    this.state = State.SPACE_AFTER_FIELD_NAME;
                    break;
                }
                if (this.isSpace() && this.isWorkField()) {
                    ++this.currentToken;
                    this.state = State.WORK_ITEM_TYPE_OR_DATE_OR_PERIOD;
                    break;
                }
                if (this.isSpace() && this.isWorkField()) {
                    ++this.currentToken;
                    this.state = State.WORK_ITEM_DATE_OR_PERIOD;
                    break;
                }
                if (this.isSpace()) {
                    ++this.currentToken;
                    this.state = State.FIELD_VALUE;
                    break;
                }
                this.unexpectedValueForField();
                this.state = State.START;
                this.START_enter();
                break;
            }
            case SPACE_AFTER_FIELD_NAME: {
                if (this.isSpace() && this.isWorkField()) {
                    ++this.currentToken;
                    this.state = State.WORK_ITEM_TYPE_OR_DATE_OR_PERIOD;
                    break;
                }
                if (this.isSpace() && this.isWorkField()) {
                    ++this.currentToken;
                    this.state = State.WORK_ITEM_DATE_OR_PERIOD;
                    break;
                }
                if (this.isSpace()) {
                    ++this.currentToken;
                    this.state = State.FIELD_VALUE;
                    break;
                }
                this.unexpectedValueForField();
                this.state = State.START;
                this.START_enter();
                break;
            }
            case COLON_OR_SPACE_AFTER_LINK_TYPE: {
                if (this.isSpace() && this.currentCommandType.getPredefinedCommandType() == PredefinedCommandType.remove) {
                    ++this.currentToken;
                    this.state = State.ISSUE_ID_TO_REMOVE;
                    break;
                }
                if (this.isSpace() && this.currentCommandType.getPredefinedCommandType() == PredefinedCommandType.add) {
                    ++this.currentToken;
                    this.state = State.ISSUE_ID_TO_ADD;
                    break;
                }
                this.unexpectedLinkedIssueId();
                this.state = State.START;
                this.START_enter();
                break;
            }
            case COLON_AFTER_LINK_TYPE: {
                if (this.isColon()) {
                    ++this.currentToken;
                    this.state = State.SPACE_AFTER_LINK_TYPE;
                    break;
                }
                if (this.isSpace() && this.currentCommandType.getPredefinedCommandType() == PredefinedCommandType.remove) {
                    ++this.currentToken;
                    this.state = State.ISSUE_ID_TO_REMOVE;
                    break;
                }
                if (this.isSpace() && this.currentCommandType.getPredefinedCommandType() == PredefinedCommandType.add) {
                    ++this.currentToken;
                    this.state = State.ISSUE_ID_TO_ADD;
                    break;
                }
                this.unexpectedLinkedIssueId();
                this.state = State.START;
                this.START_enter();
                break;
            }
            case SPACE_AFTER_LINK_TYPE: {
                if (this.isSpace() && this.currentCommandType.getPredefinedCommandType() == PredefinedCommandType.remove) {
                    ++this.currentToken;
                    this.state = State.ISSUE_ID_TO_REMOVE;
                    break;
                }
                if (this.isSpace() && this.currentCommandType.getPredefinedCommandType() == PredefinedCommandType.add) {
                    ++this.currentToken;
                    this.state = State.ISSUE_ID_TO_ADD;
                    break;
                }
                this.unexpectedLinkedIssueId();
                this.state = State.START;
                this.START_enter();
                break;
            }
            case FIELD_VALUE: {
                if (this.tryFieldValue()) {
                    this.createCommand();
                    this.state = State.START;
                    this.START_enter();
                    break;
                }
                if (this.currentCommandIsAddTag()) {
                    this.createNewTagCommand();
                    this.state = State.START;
                    this.START_enter();
                    break;
                }
                if (this.currentCommandFactory != null) {
                    this.createCommand();
                    --this.currentToken;
                    this.state = State.START;
                    this.START_enter();
                    break;
                }
                this.unexpectedValueForField();
                this.state = State.START;
                this.START_enter();
                break;
            }
            case ISSUE_ID: {
                if (this.tryIssueId(false) && this.currentCommandType != null && this.currentCommandType.isLink()) {
                    this.createLinkCommand();
                    this.state = State.START;
                    this.START_enter();
                    break;
                }
                this.unexpectedIssueId(false);
                this.state = State.START;
                this.START_enter();
                break;
            }
            case ISSUE_ID_TO_ADD: {
                if (this.tryIssueId(false) && this.currentLinkType != null && this.currentLinkType.isLink()) {
                    this.createAddLinkCommand();
                    this.state = State.START;
                    this.START_enter();
                    break;
                }
                if (this.currentCommandFactory != null) {
                    this.createCommand();
                    this.state = State.START;
                    this.START_enter();
                    break;
                }
                this.unexpectedIssueId(true);
                this.state = State.START;
                this.START_enter();
                break;
            }
            case ISSUE_ID_TO_REMOVE: {
                if (this.tryIssueId(true)) {
                    this.createRemoveLinkCommand();
                    this.state = State.START;
                    this.START_enter();
                    break;
                }
                if (this.currentCommandFactory != null) {
                    this.createCommand();
                    this.state = State.START;
                    this.START_enter();
                    break;
                }
                this.unexpectedLinkedIssueId();
                this.state = State.START;
                this.START_enter();
                break;
            }
            case WORK_ITEM_TYPE_OR_DATE_OR_PERIOD: {
                if (this.tryWorkItemType()) {
                    this.currentWorkItemType = ((FieldValueRetriever)ServiceLocator.getBean((String)"fieldValueRetriever")).getFieldValueEntity(this.currentCommandFactory);
                    this.currentWorkTypeCell = this.currentFieldValueCell;
                    this.state = State.SPACE_BEFORE_WORK_ITEM_DATE_OR_PERIOD;
                    break;
                }
                if (this.tryWorkDateOrDurationValue() && this.currentCommandFactory instanceof IFieldValue && ((DateFieldService)ServiceLocator.getBean((String)"dateFieldService")).isDatePeriodFieldValue((IFieldValue)this.currentCommandFactory)) {
                    this.processWorkItemDuration();
                    this.state = State.SPACE_BEFORE_WORK_ITEM_PERIOD;
                    break;
                }
                if (((TimeTrackingProvider)ServiceLocator.getBean((String)"timeTrackingProvider")).isWorkItemCommandExecutorFactory(this.currentCommandFactory)) {
                    this.processWorkItemPeriod();
                    this.state = State.START;
                    this.START_enter();
                    break;
                }
                this.unexpectedWorkTypeOrDateOrPeriod();
                this.state = State.START;
                this.START_enter();
                break;
            }
            case SPACE_BEFORE_WORK_ITEM_DATE_OR_PERIOD: {
                if (this.isSpace()) {
                    ++this.currentToken;
                    this.state = State.WORK_ITEM_DATE_OR_PERIOD;
                    break;
                }
                this.unexpectedWorkDateOrPeriod();
                this.state = State.START;
                this.START_enter();
                break;
            }
            case WORK_ITEM_DATE_OR_PERIOD: {
                if (this.tryWorkDateOrDurationValue() && this.currentCommandFactory instanceof IFieldValue && ((DateFieldService)ServiceLocator.getBean((String)"dateFieldService")).isDatePeriodFieldValue((IFieldValue)this.currentCommandFactory)) {
                    this.processWorkItemDuration();
                    this.state = State.SPACE_BEFORE_WORK_ITEM_PERIOD;
                    break;
                }
                if (((TimeTrackingProvider)ServiceLocator.getBean((String)"timeTrackingProvider")).isWorkItemCommandExecutorFactory(this.currentCommandFactory)) {
                    this.processWorkItemPeriod();
                    this.state = State.START;
                    this.START_enter();
                    break;
                }
                this.unexpectedWorkDateOrPeriod();
                this.state = State.START;
                this.START_enter();
                break;
            }
            case SPACE_BEFORE_WORK_ITEM_PERIOD: {
                if (this.isSpace()) {
                    ++this.currentToken;
                    this.state = State.WORK_ITEM_PERIOD;
                    break;
                }
                this.unexpectedWorkPeriod();
                this.state = State.START;
                this.START_enter();
                break;
            }
            case WORK_ITEM_PERIOD: {
                if (this.tryWorkDurationValue() && ((TimeTrackingProvider)ServiceLocator.getBean((String)"timeTrackingProvider")).isWorkItemCommandExecutorFactory(this.currentCommandFactory)) {
                    this.processWorkItemPeriod();
                    this.state = State.START;
                    this.START_enter();
                    break;
                }
                this.unexpectedWorkPeriod();
                this.state = State.START;
                this.START_enter();
                break;
            }
        }
    }

    public void field() {
        switch (this.state) {
            case START: {
                this.state = State.COLON_AFTER_FIELD_NAME;
                break;
            }
            case COMMAND_TYPE: {
                break;
            }
            case SPACE_OR_COLON_AFTER_COMMAND_TYPE: {
                break;
            }
            case COLON_AFTER_COMMAND_TYPE: {
                break;
            }
            case SPACE_AFTER_COMMAND_TYPE: {
                break;
            }
            case FIELD_NAME_OR_FIELD_VALUE: {
                this.state = State.COLON_AFTER_FIELD_NAME;
                break;
            }
            case SPACE_OR_COLON_AFTER_FIELD_NAME: {
                break;
            }
            case COLON_AFTER_FIELD_NAME: {
                break;
            }
            case SPACE_AFTER_FIELD_NAME: {
                break;
            }
            case COLON_OR_SPACE_AFTER_LINK_TYPE: {
                break;
            }
            case COLON_AFTER_LINK_TYPE: {
                break;
            }
            case SPACE_AFTER_LINK_TYPE: {
                break;
            }
            case FIELD_VALUE: {
                break;
            }
            case ISSUE_ID: {
                break;
            }
            case ISSUE_ID_TO_ADD: {
                break;
            }
            case ISSUE_ID_TO_REMOVE: {
                break;
            }
            case WORK_ITEM_TYPE_OR_DATE_OR_PERIOD: {
                break;
            }
            case SPACE_BEFORE_WORK_ITEM_DATE_OR_PERIOD: {
                break;
            }
            case WORK_ITEM_DATE_OR_PERIOD: {
                break;
            }
            case SPACE_BEFORE_WORK_ITEM_PERIOD: {
                break;
            }
            case WORK_ITEM_PERIOD: {
                break;
            }
        }
    }

    public void fieldValue() {
        switch (this.state) {
            case START: {
                if (this.isStarUnstar()) {
                    this.state = State.COLON_AFTER_FIELD_NAME;
                    break;
                }
                this.createCommand();
                this.state = State.START;
                this.START_enter();
                break;
            }
            case COMMAND_TYPE: {
                break;
            }
            case SPACE_OR_COLON_AFTER_COMMAND_TYPE: {
                break;
            }
            case COLON_AFTER_COMMAND_TYPE: {
                break;
            }
            case SPACE_AFTER_COMMAND_TYPE: {
                break;
            }
            case FIELD_NAME_OR_FIELD_VALUE: {
                this.createCommand();
                this.state = State.START;
                this.START_enter();
                break;
            }
            case SPACE_OR_COLON_AFTER_FIELD_NAME: {
                break;
            }
            case COLON_AFTER_FIELD_NAME: {
                break;
            }
            case SPACE_AFTER_FIELD_NAME: {
                break;
            }
            case COLON_OR_SPACE_AFTER_LINK_TYPE: {
                break;
            }
            case COLON_AFTER_LINK_TYPE: {
                break;
            }
            case SPACE_AFTER_LINK_TYPE: {
                break;
            }
            case FIELD_VALUE: {
                break;
            }
            case ISSUE_ID: {
                break;
            }
            case ISSUE_ID_TO_ADD: {
                break;
            }
            case ISSUE_ID_TO_REMOVE: {
                break;
            }
            case WORK_ITEM_TYPE_OR_DATE_OR_PERIOD: {
                break;
            }
            case SPACE_BEFORE_WORK_ITEM_DATE_OR_PERIOD: {
                break;
            }
            case WORK_ITEM_DATE_OR_PERIOD: {
                break;
            }
            case SPACE_BEFORE_WORK_ITEM_PERIOD: {
                break;
            }
            case WORK_ITEM_PERIOD: {
                break;
            }
        }
    }

    public void eof() {
        switch (this.state) {
            case START: {
                if (!Sequence.fromIterable((Iterable)this.commandList.getCommands()).isEmpty()) break;
                this.unexpectedEverything();
                break;
            }
            case COMMAND_TYPE: {
                if (this.tryCommentCommandType() || this.tryDeleteCommandType() || this.tryVoteCommandType() || this.tryUnvoteCommandType()) break;
                this.unexpectedFieldOrValue();
                break;
            }
            case SPACE_OR_COLON_AFTER_COMMAND_TYPE: {
                if (!this.currentCommandType.isLink()) break;
                this.unexpectedIssueId(false);
                break;
            }
            case COLON_AFTER_COMMAND_TYPE: {
                if (!this.currentCommandType.isLink()) break;
                this.unexpectedIssueId(false);
                break;
            }
            case SPACE_AFTER_COMMAND_TYPE: {
                if (!this.currentCommandType.isLink()) break;
                this.unexpectedIssueId(false);
                break;
            }
            case FIELD_NAME_OR_FIELD_VALUE: {
                this.unexpectedFieldOrValue();
                break;
            }
            case SPACE_OR_COLON_AFTER_FIELD_NAME: {
                if (this.currentCommandFactory != null) {
                    this.createCommand();
                    break;
                }
                this.unexpectedValueForField();
                break;
            }
            case COLON_AFTER_FIELD_NAME: {
                if (this.currentCommandFactory != null) {
                    this.createCommand();
                    break;
                }
                this.unexpectedValueForField();
                break;
            }
            case SPACE_AFTER_FIELD_NAME: {
                if (this.currentCommandFactory != null) {
                    this.createCommand();
                    break;
                }
                this.unexpectedValueForField();
                break;
            }
            case COLON_OR_SPACE_AFTER_LINK_TYPE: {
                if (this.currentCommandFactory != null) {
                    this.createCommand();
                    break;
                }
                this.unexpectedLinkedIssueId();
                break;
            }
            case COLON_AFTER_LINK_TYPE: {
                if (this.currentCommandFactory != null) {
                    this.createCommand();
                    break;
                }
                this.unexpectedLinkedIssueId();
                break;
            }
            case SPACE_AFTER_LINK_TYPE: {
                if (this.currentCommandFactory != null) {
                    this.createCommand();
                    break;
                }
                this.unexpectedLinkedIssueId();
                break;
            }
            case FIELD_VALUE: {
                if (this.currentCommandFactory != null) {
                    this.createCommand();
                    this.createEof();
                    this.state = State.START;
                    this.START_enter();
                    break;
                }
                this.unexpectedValueForField();
                break;
            }
            case ISSUE_ID: {
                this.unexpectedIssueId(false);
                break;
            }
            case ISSUE_ID_TO_ADD: {
                if (this.currentCommandFactory != null) {
                    this.createCommand();
                    break;
                }
                this.unexpectedIssueId(true);
                break;
            }
            case ISSUE_ID_TO_REMOVE: {
                if (this.currentCommandFactory != null) {
                    this.createCommand();
                    this.createEof();
                    this.state = State.START;
                    this.START_enter();
                    break;
                }
                this.unexpectedLinkedIssueId();
                break;
            }
            case WORK_ITEM_TYPE_OR_DATE_OR_PERIOD: {
                this.unexpectedWorkTypeOrDateOrPeriod();
                break;
            }
            case SPACE_BEFORE_WORK_ITEM_DATE_OR_PERIOD: {
                this.unexpectedWorkDateOrPeriod();
                break;
            }
            case WORK_ITEM_DATE_OR_PERIOD: {
                this.unexpectedWorkDateOrPeriod();
                break;
            }
            case SPACE_BEFORE_WORK_ITEM_PERIOD: {
                this.unexpectedWorkPeriod();
                break;
            }
            case WORK_ITEM_PERIOD: {
                this.unexpectedWorkPeriod();
                break;
            }
        }
    }

    protected boolean isCurrentField(IField c) {
        return this.currentField == c;
    }

    protected boolean isCurrentPredefinedCommand(PredefinedCommandType c) {
        return this.currentCommandType != null && this.currentCommandType.getPredefinedCommandType() == c;
    }

    public boolean isInState(State state) {
        if (this.state == state) {
            return true;
        }
        switch (state) {
            case SPACE_OR_COLON_AFTER_COMMAND_TYPE: {
                switch (this.state) {
                    case COLON_AFTER_COMMAND_TYPE: {
                        return true;
                    }
                    case SPACE_AFTER_COMMAND_TYPE: {
                        return true;
                    }
                }
                return false;
            }
            case SPACE_OR_COLON_AFTER_FIELD_NAME: {
                switch (this.state) {
                    case COLON_AFTER_FIELD_NAME: {
                        return true;
                    }
                    case SPACE_AFTER_FIELD_NAME: {
                        return true;
                    }
                }
                return false;
            }
            case COLON_OR_SPACE_AFTER_LINK_TYPE: {
                switch (this.state) {
                    case COLON_AFTER_LINK_TYPE: {
                        return true;
                    }
                    case SPACE_AFTER_LINK_TYPE: {
                        return true;
                    }
                }
                return false;
            }
        }
        return false;
    }

    public State _state() {
        return this.state;
    }

    private void START_enter() {
        this.reset();
    }

    private static boolean eq_75xrbp_a0a0e(Object a, Object b) {
        return a != null ? a.equals(b) : a == b;
    }

    private static boolean eq_75xrbp_a0a0f(Object a, Object b) {
        return a != null ? a.equals(b) : a == b;
    }

    private static <T> T as_75xrbp_a0a6a65(Object o, Class<T> type2) {
        return (T)(type2.isInstance(o) ? o : null);
    }

    public static String trim_75xrbp_a0a0b0fc(String str) {
        return str == null ? null : str.trim();
    }

    public static boolean isEmpty_75xrbp_a0a1a5a75(String str) {
        return str == null || str.length() == 0;
    }

    public static String trim_75xrbp_a0a0b0f0fc(String str) {
        return str == null ? null : str.trim();
    }

    public static enum State {
        START,
        COMMAND_TYPE,
        SPACE_OR_COLON_AFTER_COMMAND_TYPE,
        COLON_AFTER_COMMAND_TYPE,
        SPACE_AFTER_COMMAND_TYPE,
        FIELD_NAME_OR_FIELD_VALUE,
        SPACE_OR_COLON_AFTER_FIELD_NAME,
        COLON_AFTER_FIELD_NAME,
        SPACE_AFTER_FIELD_NAME,
        COLON_OR_SPACE_AFTER_LINK_TYPE,
        COLON_AFTER_LINK_TYPE,
        SPACE_AFTER_LINK_TYPE,
        FIELD_VALUE,
        ISSUE_ID,
        ISSUE_ID_TO_ADD,
        ISSUE_ID_TO_REMOVE,
        WORK_ITEM_TYPE_OR_DATE_OR_PERIOD,
        SPACE_BEFORE_WORK_ITEM_DATE_OR_PERIOD,
        WORK_ITEM_DATE_OR_PERIOD,
        SPACE_BEFORE_WORK_ITEM_PERIOD,
        WORK_ITEM_PERIOD;

    }

    static class SuggestFieldValuePredicate
    extends BaseFieldValuePredicate {
        private IContext ctx;
        private PredefinedCommandType type;
        private IField field;
        private ICommandList commandList;

        SuggestFieldValuePredicate(@NotNull IContext ctx, PredefinedCommandType type2, IField field, ICommandList commandList2) {
            this.ctx = ctx;
            this.type = type2;
            this.field = field;
            this.commandList = commandList2;
        }

        public boolean onlyPrimary() {
            return false;
        }

        public IField getField() {
            return this.field;
        }

        public PredefinedCommandType getCommandType() {
            return this.type;
        }

        public IContext getContext() {
            return this.ctx;
        }

        public ICommandList getCommandList() {
            return this.commandList;
        }

        public boolean isSuggest() {
            return true;
        }
    }

    static class FieldValuePredicate
    extends BaseFieldValuePredicate {
        private CommandParser cp;

        FieldValuePredicate(CommandParser cp) {
            this.cp = cp;
        }

        public IField getField() {
            return this.cp.currentField;
        }

        public boolean onlyPrimary() {
            return true;
        }

        public boolean isSuggest() {
            return false;
        }

        public PredefinedCommandType getCommandType() {
            return this.cp.currentCommandType == null ? null : this.cp.currentCommandType.getPredefinedCommandType();
        }

        public IContext getContext() {
            return this.cp.context;
        }

        public ICommandList getCommandList() {
            return this.cp.commandList;
        }
    }

    static abstract class BaseFieldValuePredicate
    implements ICommandParserPredicate {
        BaseFieldValuePredicate() {
        }

        public boolean matches(Object it) {
            if (it instanceof IBaseFieldValue) {
                IBaseFieldValue baseFieldValue = (IBaseFieldValue)it;
                if (this.onlyPrimary() && !baseFieldValue.isPrimary() || this.isSuggest() && !baseFieldValue.shouldSuggest(this.getCommandType())) {
                    return false;
                }
            }
            if (it instanceof ICommandExecutorFactory) {
                ICommandExecutorFactory commandFactory = (ICommandExecutorFactory)it;
                return commandFactory.canCreateExecutor((ICommandParserPredicate)this);
            }
            return false;
        }
    }

    static class SuggestFieldPredicate
    extends BaseFieldPredicate {
        private PredefinedCommandType type;
        private IContext context;

        SuggestFieldPredicate(@NotNull IContext context2, PredefinedCommandType type2) {
            this.type = type2;
            this.context = context2;
        }

        public PredefinedCommandType getCommandType() {
            return this.type;
        }

        public IContext getContext() {
            return this.context;
        }

        public boolean onlyPrimary() {
            return false;
        }

        public ICommandList getCommandList() {
            return null;
        }

        public boolean isSuggest() {
            return true;
        }
    }

    static class FieldPredicate
    extends BaseFieldPredicate {
        private CommandParser cp;

        FieldPredicate(CommandParser cp) {
            this.cp = cp;
        }

        public PredefinedCommandType getCommandType() {
            return this.cp.currentCommandType == null ? null : this.cp.currentCommandType.getPredefinedCommandType();
        }

        public IContext getContext() {
            return this.cp.context;
        }

        public boolean onlyPrimary() {
            return true;
        }

        public ICommandList getCommandList() {
            return this.cp.commandList;
        }

        public boolean isSuggest() {
            return false;
        }
    }

    static abstract class BaseFieldPredicate
    implements ICommandParserPredicate {
        BaseFieldPredicate() {
        }

        public boolean matches(Object it) {
            if (!(it instanceof BaseFieldNode)) {
                return false;
            }
            BaseFieldNode fieldNode = (BaseFieldNode)it;
            if (this.onlyPrimary() && !fieldNode.isPrimary()) {
                return false;
            }
            if (!fieldNode.getFieldAlias().isCommand()) {
                return false;
            }
            WriteableFieldNode writeableNode = BaseFieldPredicate.as_75xrbp_a0a7a0a(fieldNode, WriteableFieldNode.class);
            if (writeableNode != null && !writeableNode.isWriteAccessibleInProjects(this.getContext())) {
                return false;
            }
            if (fieldNode.getField() == (IField)ServiceLocator.getBean((String)"predefinedFieldProject")) {
                return this.getContext().allSelectedIssues((_FunctionTypes._return_P1_E0)new _FunctionTypes._return_P1_E0<Boolean, Entity>(){

                    public Boolean invoke(Entity it) {
                        return ((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)it, (String)"Issue")).canChangeProject(it);
                    }
                });
            }
            return fieldNode.getField().matchesCommandType(this.getCommandType());
        }

        public IField getField() {
            return null;
        }

        private static <T> T as_75xrbp_a0a7a0a(Object o, Class<T> type2) {
            return (T)(type2.isInstance(o) ? o : null);
        }
    }
}

