/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.commands.impl;

import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import java.util.Collections;
import java.util.List;
import jetbrains.charisma.persistence.user.CurrentUserProvider;
import jetbrains.charisma.persistence.user.UserImpl;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.api.commands.ICell;
import jetbrains.youtrack.api.commands.ICommand;
import jetbrains.youtrack.api.commands.ICommandExecutor;
import jetbrains.youtrack.api.commands.ICommandList;
import jetbrains.youtrack.api.commands.ICommandParser;
import jetbrains.youtrack.api.parser.IContext;
import jetbrains.youtrack.api.parser.IField;
import jetbrains.youtrack.api.parser.IPrefixTreesData;
import jetbrains.youtrack.commands.impl.CommandParser;
import jetbrains.youtrack.commands.impl.ErrorCell;
import jetbrains.youtrack.parser.base.SuggestItem;
import jetbrains.youtrack.parser.lexer.Tokenizer;
import jetbrains.youtrack.parser.lexer.Word;
import org.jetbrains.annotations.NotNull;

public class CommandsParserFactory {
    private CommandsParserFactory() {
    }

    public static ICommandParser create() {
        return ((UserImpl)DnqUtils.getPersistentClassInstance((Entity)((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get(), (String)"User")).isBanned(((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get()) ? new NoAccessParser() : new CommandParser();
    }

    private static class NoAccessCommandList
    implements ICommandList {
        private String text;
        private List<Word> tokens;
        private ICell errorCell;
        private Entity author;
        private IPrefixTreesData prefixTrees;
        private IContext context;

        public NoAccessCommandList(String command, IPrefixTreesData data, @NotNull IContext context2) {
            this.text = command;
            this.author = ((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get();
            this.tokens = Tokenizer.toWords((String)command, (boolean)false, (boolean)false);
            this.prefixTrees = data;
            this.context = context2;
            this.errorCell = new ErrorCell(0, ListSequence.fromList(this.tokens).count() - 1, this.getDebugDescription());
        }

        public String getText() {
            return this.text;
        }

        @NotNull
        public List<Word> getTokens() {
            return this.tokens;
        }

        public ICell getCell(int index) {
            if (index == 0) {
                return this.errorCell;
            }
            throw new ArrayIndexOutOfBoundsException(index);
        }

        public int getCellIndex(ICell cell) {
            if (cell == this.errorCell) {
                return 0;
            }
            throw new IllegalArgumentException("Cell not found");
        }

        public ICell getLastCell() {
            return this.errorCell;
        }

        public void addCommand(ICommand command) {
        }

        public void removeCommand(ICommand command) {
        }

        public Iterable<ICommand> getCommands() {
            return Sequence.fromIterable(Collections.emptyList());
        }

        public ICommandExecutor getCommandExecutor(IField category) {
            return null;
        }

        public Iterable<ICell> getCells() {
            return Sequence.singleton((Object)this.errorCell);
        }

        public void execute() {
            this.execute(true);
        }

        public void execute(boolean flushPages) {
            throw new SecurityException(this.getDebugDescription());
        }

        public IContext getContext() {
            return this.context;
        }

        public IPrefixTreesData getPrefixTrees() {
            return this.prefixTrees;
        }

        public String getDebugDescription() {
            return "User " + (String)PrimitiveAssociationSemantics.get((Entity)this.author, (String)"login", String.class, (Object)"<no user>") + " has no access to commands";
        }

        public Iterable<SuggestItem> getSuggestions(int cursorPos) {
            return Sequence.fromIterable(Collections.emptyList());
        }

        public boolean hasDeleteIssueCommand() {
            return false;
        }

        public boolean hasErrors() {
            return true;
        }
    }

    private static class NoAccessParser
    implements ICommandParser {
        private NoAccessParser() {
        }

        public ICommandList parse(IPrefixTreesData data, String command, @NotNull IContext ctx) {
            return new NoAccessCommandList(command, data, ctx);
        }
    }
}

