/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.commands.impl;

import java.util.Collection;
import jetbrains.mps.internationalization.runtime.Localizer;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.youtrack.api.commands.CommandQuickFix;
import jetbrains.youtrack.api.parser.IField;
import jetbrains.youtrack.commands.impl.AbstractTokensCell;
import jetbrains.youtrack.commands.impl.CommandQuickFixService;
import jetbrains.youtrack.commands.impl.CommandType;
import jetbrains.youtrack.parser.lexer.Word;

public class UnexpectedCell
extends AbstractTokensCell {
    private String whatIsExpected;

    public UnexpectedCell(int tokenNum, CommandType type2, IField field, String description2) {
        super(tokenNum, tokenNum, type2, field);
        this.whatIsExpected = description2;
    }

    public UnexpectedCell(int tokenNum, CommandType type2, IField field, String description2, CommandType addForType, IField addForField) {
        super(tokenNum, tokenNum, type2, field, addForType, addForField);
        this.whatIsExpected = description2;
    }

    void getOneMoreToken() {
        ++this.stopToken;
    }

    public String getDebugDescription() {
        return "<" + this.getText() + ">";
    }

    @Override
    public boolean isError() {
        return true;
    }

    @Override
    public String getText() {
        StringBuilder s = new StringBuilder(this.whatIsExpected);
        String t = super.getText();
        if (t != null && t.length() > 0) {
            s.append(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("UnexpectedCell.", new Object[0])).append(t);
        }
        return s.toString();
    }

    public String getUnderlineStyle() {
        return "error";
    }

    @Override
    public Collection<CommandQuickFix> getQuickFix() {
        String text = Word.toString(this.getTokens(), (int)this.startToken, (int)this.stopToken);
        return ((CommandQuickFixService)ServiceLocator.getBean((String)"commandQuickFixService")).provideQuickFixes(this.field, text, this.command.getCommandList().getContext());
    }
}

