/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.commands.rest;

import com.jetbrains.teamsys.dnq.association.AssociationSemantics;
import com.jetbrains.teamsys.dnq.database.EntityOperations;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import jetbrains.charisma.persistence.user.CurrentUserProvider;
import jetbrains.charisma.persistent.IssueFolderUtil;
import jetbrains.charisma.rest.IsLoggedInSecurityConstraint;
import jetbrains.charisma.restInternal.JaxbCommands;
import jetbrains.charisma.restInternal.JaxbSuggest;
import jetbrains.charisma.restInternal.JaxbUnderline;
import jetbrains.charisma.restInternal.JaxbUnderlineAndSuggest;
import jetbrains.charisma.restInternal.JaxbUnderlineAndSuggestAndCommands;
import jetbrains.charisma.smartui.filter.FilterData;
import jetbrains.charisma.smartui.persistent.Context;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.ISelector;
import jetbrains.mps.internal.collections.runtime.ISequence;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.webr.htmlComponent.bl.Range;
import jetbrains.mps.webr.rpc.rest.filter.runtime.Transactional;
import jetbrains.mps.webr.rpc.rest.runtime.Resource;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.api.commands.CommandService;
import jetbrains.youtrack.api.commands.ICell;
import jetbrains.youtrack.api.commands.ICommandList;
import jetbrains.youtrack.api.parser.IContext;
import jetbrains.youtrack.commands.facade.CommandUtil;
import jetbrains.youtrack.commands.impl.RecentCommandsCache;
import jetbrains.youtrack.commands.rest.CommandRestUtil;
import jetbrains.youtrack.core.persistent.IssueFolderImpl;
import jetbrains.youtrack.core.persistent.ProjectImpl;
import jetbrains.youtrack.parser.base.SuggestItem;

@Path(value="/command")
@Produces(value={"application/xml;charset=UTF-8", "application/json;charset=UTF-8"})
@Transactional
public class CommandResource
implements Resource {
    @GET
    @Path(value="/suggest")
    @Produces(value={"application/x-javascript;charset=UTF-8", "application/xml;charset=UTF-8", "application/json;charset=UTF-8"})
    public JaxbSuggest get_Suggest(@QueryParam(value="issueIds") String issueIds, @QueryParam(value="folder") String folder, @QueryParam(value="query") String query, @QueryParam(value="command") String command, @QueryParam(value="caret") Integer caret2, @QueryParam(value="optionsLimit") Integer optionsLimit, @QueryParam(value="noIssuesContext") boolean noIssuesContext) {
        IsLoggedInSecurityConstraint.check();
        IsLoggedInSecurityConstraint.check();
        ICommandList commandList2 = this.parse(IssueFolderUtil.findById((String)folder), query, issueIds, command, noIssuesContext);
        return this.getSuggests(commandList2, command, caret2, optionsLimit);
    }

    @GET
    @Path(value="/underline")
    @Produces(value={"application/x-javascript;charset=UTF-8", "application/xml;charset=UTF-8", "application/json;charset=UTF-8"})
    public JaxbUnderline get_Underline(@QueryParam(value="issueIds") String issueIds, @QueryParam(value="folder") String folder, @QueryParam(value="query") String query, @QueryParam(value="command") String command, @QueryParam(value="noIssuesContext") boolean noIssuesContext) {
        IsLoggedInSecurityConstraint.check();
        IsLoggedInSecurityConstraint.check();
        ICommandList commandList2 = this.parse(IssueFolderUtil.findById((String)folder), query, issueIds, command, noIssuesContext);
        return this.getUnderline(command, commandList2);
    }

    @GET
    @Path(value="/underlineAndSuggest")
    @Produces(value={"application/x-javascript;charset=UTF-8", "application/xml;charset=UTF-8", "application/json;charset=UTF-8"})
    public JaxbUnderlineAndSuggest get_UnderlineAndSuggest(@QueryParam(value="issueIds") String issueIds, @QueryParam(value="folder") String folder, @QueryParam(value="query") String query, @QueryParam(value="command") String command, @QueryParam(value="caret") Integer caret2, @QueryParam(value="optionsLimit") Integer optionsLimit, @QueryParam(value="noIssuesContext") boolean noIssuesContext) {
        IsLoggedInSecurityConstraint.check();
        IsLoggedInSecurityConstraint.check();
        ICommandList commandList2 = this.parse(IssueFolderUtil.findById((String)folder), query, issueIds, command, noIssuesContext);
        return new JaxbUnderlineAndSuggest(this.getUnderline(command, commandList2), this.getSuggests(commandList2, command, caret2, optionsLimit));
    }

    @GET
    @Path(value="/underlineAndSuggestAndCommands")
    @Produces(value={"application/x-javascript;charset=UTF-8", "application/xml;charset=UTF-8", "application/json;charset=UTF-8"})
    public JaxbUnderlineAndSuggestAndCommands get_UnderlineAndSuggestAndCommands(@QueryParam(value="issueIds") String issueIds, @QueryParam(value="folder") String folder, @QueryParam(value="query") String query, @QueryParam(value="command") String command, @QueryParam(value="caret") Integer caret2, @QueryParam(value="optionsLimit") Integer optionsLimit, @QueryParam(value="noIssuesContext") boolean noIssuesContext) {
        IsLoggedInSecurityConstraint.check();
        IsLoggedInSecurityConstraint.check();
        ICommandList commandList2 = this.parse(ProjectImpl.findReadableProject((String)folder, (Entity)((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get()), query, issueIds, command, noIssuesContext);
        return new JaxbUnderlineAndSuggestAndCommands(this.getUnderline(command, commandList2), this.getSuggests(commandList2, command, caret2, optionsLimit), this.getCommands(commandList2));
    }

    protected JaxbCommands getCommands(ICommandList commandList2) {
        return new JaxbCommands(CommandUtil.getValidCommands(commandList2));
    }

    private ICommandList parse(Entity folder, String query, String issueIds, String command, boolean noIssuesContext) {
        if (EntityOperations.equals((Entity)folder, null)) {
            folder = AssociationSemantics.getToOne((Entity)AssociationSemantics.getToOne((Entity)((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get(), (String)"profile"), (String)"filterFolder");
        }
        Context context2 = new Context();
        if (!noIssuesContext) {
            if (query != null && query.length() > 0 || issueIds == null || issueIds.length() == 0) {
                FilterData filterData = FilterData.create((String)query, (Entity)folder, (Entity)((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get(), (int)Integer.MAX_VALUE);
                context2.setSelectedIssues(filterData.getIssues(true, false));
            } else {
                context2.setSelectedIssues(CommandRestUtil.toIssues(issueIds));
            }
        } else if (!EntityOperations.equals((Entity)folder, null)) {
            context2.setSelectedProjects(((IssueFolderImpl)DnqUtils.getPersistentClassInstance((Entity)folder, (String)"IssueFolder")).getQueryProjects(folder));
        }
        return CommandUtil.parse(command, (IContext)context2);
    }

    private JaxbSuggest getSuggests(ICommandList commandList2, String command, Integer caret2, Integer limit) {
        if (command == null) {
            command = "";
        }
        if (caret2 == null) {
            caret2 = command.length();
        }
        if (limit == null || limit < 1) {
            limit = 15;
        }
        Iterable<SuggestItem> recentCommands2 = RecentCommandsCache.get(((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get()).getSuggests(command, caret2);
        ISequence suggestItems = Sequence.fromIterable((Iterable)((CommandService)ServiceLocator.getBean((String)"commandService")).suggest(commandList2, caret2.intValue(), limit.intValue())).concat(Sequence.fromIterable(recentCommands2));
        return new JaxbSuggest(command, caret2.intValue(), (Iterable)suggestItems);
    }

    private JaxbUnderline getUnderline(String command, ICommandList commandList2) {
        if (command == null) {
            command = "";
        }
        return new JaxbUnderline(command, (Iterable)Sequence.fromIterable((Iterable)commandList2.getCells()).select((_FunctionTypes._return_P1_E0)new ISelector<ICell, Range>(){

            public Range select(ICell it) {
                return it;
            }
        }));
    }
}

