/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.commands.rest;

import com.jetbrains.teamsys.dnq.association.AssociationSemantics;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import jetbrains.charisma.persistence.user.CurrentUserProvider;
import jetbrains.charisma.persistence.user.UserImpl;
import jetbrains.charisma.rest.IntelliSense;
import jetbrains.charisma.rest.IsIssueAccessibleSecurityConstraint;
import jetbrains.charisma.rest.IsLoggedInSecurityConstraint;
import jetbrains.charisma.rest.IsNotGuestSecurityConstraint;
import jetbrains.charisma.rest.RestUtil;
import jetbrains.charisma.rest.TokenStyleUtil;
import jetbrains.charisma.smartadmin.rest.ResponseUtil;
import jetbrains.charisma.smartui.persistent.Context;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.ISelector;
import jetbrains.mps.internal.collections.runtime.ISequence;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.webr.rpc.rest.filter.runtime.Transactional;
import jetbrains.mps.webr.rpc.rest.provider.exception.BadRequestException;
import jetbrains.mps.webr.rpc.rest.provider.exception.ForbiddenException;
import jetbrains.mps.webr.rpc.rest.runtime.Resource;
import jetbrains.mps.webr.rpc.rest.runtime.Transformer;
import jetbrains.mps.webr.runtime.templateComponent.LocalizedLogicException;
import jetbrains.mps.webr.userManagement.runtime.PrincipalManager;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.api.commands.CommandService;
import jetbrains.youtrack.api.commands.ICell;
import jetbrains.youtrack.api.commands.ICommandList;
import jetbrains.youtrack.api.parser.IContext;
import jetbrains.youtrack.commands.impl.RecentCommandsCache;
import jetbrains.youtrack.core.security.Operation;
import jetbrains.youtrack.core.security.Permission;
import jetbrains.youtrack.parser.base.StyleRange;
import jetbrains.youtrack.parser.base.SuggestItem;

@Path(value="/issue")
@Produces(value={"application/xml;charset=UTF-8", "application/json;charset=UTF-8"})
@Transactional
public class IssueResource
implements Resource {
    @POST
    @Path(value="/execute/{issue}")
    public String post_ExecuteIssue(@Transformer(value="issueById") @PathParam(value="issue") Entity issue, @QueryParam(value="command") String command, @QueryParam(value="comment") String comment2, @QueryParam(value="group") String group, @QueryParam(value="disableNotifications") boolean disableNotifications) {
        IsLoggedInSecurityConstraint.check();
        IsNotGuestSecurityConstraint.check();
        IsIssueAccessibleSecurityConstraint.check((Entity)issue, (Operation)Operation.READ);
        try {
            ((CommandService)ServiceLocator.getBean((String)"commandService")).execute(issue, command, comment2, group, disableNotifications);
        }
        catch (LocalizedLogicException e) {
            throw new BadRequestException(e.getLocalizedMessage().replaceAll("\n", ""));
        }
        return "Command applied: " + command;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="/{issue}/execute")
    public Response post_IssueExecute(@Transformer(value="issueById") @PathParam(value="issue") Entity issue, @QueryParam(value="command") String command, @QueryParam(value="comment") String comment2, @QueryParam(value="group") String group, @QueryParam(value="disableNotifications") boolean disableNotifications, @QueryParam(value="runAs") String runAs2) {
        block7: {
            IsLoggedInSecurityConstraint.check();
            IsNotGuestSecurityConstraint.check();
            IsIssueAccessibleSecurityConstraint.check((Entity)issue, (Operation)Operation.READ);
            try {
                if (runAs2 != null && runAs2.length() > 0) {
                    if (!((UserImpl)DnqUtils.getPersistentClassInstance((Entity)((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get(), (String)"User")).hasPermission(Permission.ADMIN_UPDATE_APP, AssociationSemantics.getToOne((Entity)issue, (String)"project"), ((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get())) {
                        throw new ForbiddenException(RestUtil.createSecurityErrorMessage((Permission)Permission.ADMIN_UPDATE_APP));
                    }
                    Entity asUser = UserImpl.findUser((String)runAs2);
                    ResponseUtil.assertExist((String)"No such user", (Object)asUser, (String)"User", (boolean)true);
                    try {
                        ((PrincipalManager)ServiceLocator.getBean((String)"principalManager")).setTemporaryServerPrincipal((Object)asUser);
                        ((CommandService)ServiceLocator.getBean((String)"commandService")).execute(issue, command, comment2, group, disableNotifications);
                        break block7;
                    }
                    finally {
                        ((PrincipalManager)ServiceLocator.getBean((String)"principalManager")).unsetTemporaryServerPrincipal();
                    }
                }
                ((CommandService)ServiceLocator.getBean((String)"commandService")).execute(issue, command, comment2, group, disableNotifications);
            }
            catch (LocalizedLogicException e) {
                throw new BadRequestException(e.getLocalizedMessage().replaceAll("\n", ""));
            }
        }
        return Response.ok().build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/{issue}/execute/intellisense")
    public IntelliSense get_IssueExecuteIntellisense(@Transformer(value="issueById") @PathParam(value="issue") Entity issue, @QueryParam(value="command") String command, @QueryParam(value="runAs") String runAs2, @QueryParam(value="caret") Integer caret2, @QueryParam(value="optionsLimit") Integer optionsLimit) {
        IntelliSense intelliSense;
        IsLoggedInSecurityConstraint.check();
        IsNotGuestSecurityConstraint.check();
        IsIssueAccessibleSecurityConstraint.check((Entity)issue, (Operation)Operation.READ);
        if (runAs2 != null && runAs2.length() > 0) {
            if (!((UserImpl)DnqUtils.getPersistentClassInstance((Entity)((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get(), (String)"User")).hasPermission(Permission.ADMIN_READ_APP, ((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get())) {
                throw new ForbiddenException(RestUtil.createSecurityErrorMessage((Permission)Permission.ADMIN_READ_APP));
            }
            Entity asUser = UserImpl.findUser((String)runAs2);
            ResponseUtil.assertExist((String)"No such user", (Object)asUser, (String)"User", (boolean)true);
            try {
                ((PrincipalManager)ServiceLocator.getBean((String)"principalManager")).setTemporaryServerPrincipal((Object)asUser);
                intelliSense = this.suggestCommand(issue, command, caret2, optionsLimit);
            }
            finally {
                ((PrincipalManager)ServiceLocator.getBean((String)"principalManager")).unsetTemporaryServerPrincipal();
            }
        } else {
            intelliSense = this.suggestCommand(issue, command, caret2, optionsLimit);
        }
        return intelliSense;
    }

    private IntelliSense suggestCommand(Entity issue, String command, Integer caret2, Integer optionsLimit) {
        Context context2 = new Context();
        Iterable selectedIssues = QueryOperations.singleton((Entity)issue);
        context2.setSelectedIssues(selectedIssues);
        if (command == null || command.length() == 0) {
            command = " ";
        }
        if (optionsLimit == null) {
            optionsLimit = 15;
        }
        if (caret2 == null) {
            caret2 = command.length();
        }
        ICommandList commandList2 = ((CommandService)ServiceLocator.getBean((String)"commandService")).parse(command, (IContext)context2);
        Iterable items = ((CommandService)ServiceLocator.getBean((String)"commandService")).suggest(commandList2, caret2.intValue(), optionsLimit.intValue());
        Iterable<SuggestItem> recent = RecentCommandsCache.get(((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get()).getSuggests(command, caret2);
        ISequence ranges = Sequence.fromIterable((Iterable)commandList2.getCells()).select((_FunctionTypes._return_P1_E0)new ISelector<ICell, StyleRange>(){

            public StyleRange select(ICell it) {
                return new StyleRange(it.getStart(), it.getEnd() - it.getStart(), TokenStyleUtil.getStyle((ICell)it), null);
            }
        });
        return new IntelliSense(items, recent, (Iterable)ranges);
    }
}

