/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.core.persistent.order;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Iterator;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.entitystore.EntityId;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010(\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bJ\u001c\u0010\f\u001a\u00020\b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u000bJ\u001c\u0010\f\u001a\u00020\b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00112\u0006\u0010\u0010\u001a\u00020\u000bJ\u001c\u0010\u0012\u001a\u00020\b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u000bJ\u001e\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0016\u00a8\u0006\u0017"}, d2={"Ljetbrains/youtrack/core/persistent/order/EntityIdsSerializer;", "", "()V", "deserializeId", "", "inputStream", "Ljava/io/InputStream;", "resetOrder", "", "id", "out", "Ljava/io/OutputStream;", "serialize1", "entities", "", "Ljetbrains/exodus/entitystore/Entity;", "os", "", "serialize2", "serializeId", "l", "buf", "", "youtrack-core"})
public final class EntityIdsSerializer {
    public static final EntityIdsSerializer INSTANCE;

    public final void serialize1(@NotNull Iterable<? extends Entity> entities, @NotNull OutputStream os) throws IOException {
        Intrinsics.checkParameterIsNotNull(entities, (String)"entities");
        Intrinsics.checkParameterIsNotNull((Object)os, (String)"os");
        byte[] buf = new byte[9];
        Iterator iterator2 = Sequence.fromIterable(entities).iterator();
        while (iterator2.hasNext()) {
            Entity e;
            Entity entity = e = (Entity)iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)entity, (String)"e");
            EntityId entityId = entity.getId();
            Intrinsics.checkExpressionValueIsNotNull((Object)entityId, (String)"e.id");
            this.serializeId(entityId.getLocalId(), os, buf);
        }
    }

    public final void serialize1(@NotNull Iterator<? extends Entity> entities, @NotNull OutputStream os) throws IOException {
        Intrinsics.checkParameterIsNotNull(entities, (String)"entities");
        Intrinsics.checkParameterIsNotNull((Object)os, (String)"os");
        byte[] buf = new byte[9];
        while (entities.hasNext()) {
            EntityId entityId = entities.next().getId();
            Intrinsics.checkExpressionValueIsNotNull((Object)entityId, (String)"entities.next().id");
            this.serializeId(entityId.getLocalId(), os, buf);
        }
    }

    public final void serialize2(@NotNull Iterable<? extends Entity> entities, @NotNull OutputStream os) throws IOException {
        Intrinsics.checkParameterIsNotNull(entities, (String)"entities");
        Intrinsics.checkParameterIsNotNull((Object)os, (String)"os");
        long[] ids = new long[QueryOperations.getSize(entities)];
        int count = 0;
        for (Entity entity : Sequence.fromIterable(entities)) {
            int n = count++;
            Entity entity2 = entity;
            Intrinsics.checkExpressionValueIsNotNull((Object)entity2, (String)"entity");
            EntityId entityId = entity2.getId();
            Intrinsics.checkExpressionValueIsNotNull((Object)entityId, (String)"entity.id");
            ids[n] = entityId.getLocalId();
        }
        ObjectOutputStream oos = new ObjectOutputStream(os);
        oos.writeObject(ids);
        oos.close();
    }

    public final void serializeId(long l, @NotNull OutputStream out, @NotNull byte[] buf) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)out, (String)"out");
        Intrinsics.checkParameterIsNotNull((Object)buf, (String)"buf");
        long lo = l;
        int count = 0;
        do {
            buf[++count] = (byte)lo;
        } while ((lo >>>= 8) != 0L);
        buf[0] = (byte)count;
        out.write(buf, 0, count + 1);
    }

    public final long deserializeId(@NotNull InputStream inputStream) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)inputStream, (String)"inputStream");
        int size = inputStream.read();
        if (size == -1) {
            return -1L;
        }
        long l = 0L;
        int count = 0;
        while (count < size) {
            l |= (long)(inputStream.read() << 8 * count++);
        }
        return l;
    }

    public final void resetOrder(long id, @NotNull InputStream inputStream, @NotNull OutputStream out) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)inputStream, (String)"inputStream");
        Intrinsics.checkParameterIsNotNull((Object)out, (String)"out");
        long nextId = this.deserializeId(inputStream);
        byte[] buf = new byte[9];
        while (nextId != -1L) {
            if (nextId != id) {
                this.serializeId(nextId, out, buf);
            }
            nextId = this.deserializeId(inputStream);
        }
    }

    private EntityIdsSerializer() {
    }

    static {
        EntityIdsSerializer entityIdsSerializer;
        INSTANCE = entityIdsSerializer = new EntityIdsSerializer();
    }
}

