/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.notifications.analyzer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jetbrains.charisma.persistent.CharismaJob;
import jetbrains.charisma.service.BeansKt;
import jetbrains.exodus.database.TransientEntityStore;
import jetbrains.exodus.database.TransientStoreSession;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.notifications.ReadOnlyModeAware;
import jetbrains.youtrack.notifications.analyzer.CompositeReason;
import jetbrains.youtrack.notifications.analyzer.NotificationTasks;
import jetbrains.youtrack.notifications.sending.NotificationJob;
import jetbrains.youtrack.persistent.XdUser;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\b&\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\n\u0010\r\u001a\u0004\u0018\u00010\u000eH$J&\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H$J\u0018\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u000eH\u0002J\b\u0010\u001a\u001a\u00020\u0010H\u0014J\u0016\u0010\u001b\u001a\u00020\u00102\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0018H\u0014J\u001b\u0010\u001c\u001a\u00020\u00102\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0018H\u0000\u00a2\u0006\u0002\b\u001dJ\u0010\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020\u0016H\u0014J\u0010\u0010 \u001a\u00020!2\u0006\u0010\u0011\u001a\u00020\u0005H\u0002R\u0012\u0010\u0007\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006#"}, d2={"Ljetbrains/youtrack/notifications/analyzer/AbstractAnalyzerJob;", "Ljetbrains/charisma/persistent/CharismaJob;", "id", "", "sender", "Ljetbrains/youtrack/persistent/XdUser;", "(Ljava/lang/Object;Ljetbrains/youtrack/persistent/XdUser;)V", "logInfo", "", "getLogInfo", "()Ljava/lang/String;", "getSender", "()Ljetbrains/youtrack/persistent/XdUser;", "analyze", "Ljetbrains/youtrack/notifications/analyzer/NotificationTasks;", "appendSendJobs", "", "recipient", "reason", "Ljetbrains/youtrack/notifications/analyzer/CompositeReason;", "parcel", "", "Ljetbrains/youtrack/notifications/sending/NotificationJob;", "envelop", "", "tasks", "execute", "register", "schedule", "schedule$youtrack_custom_notifications", "scheduleSingleSendJob", "job", "shouldNotify", "", "Companion", "youtrack-custom-notifications"})
public abstract class AbstractAnalyzerJob
extends CharismaJob {
    @NotNull
    private final XdUser sender;
    @NotNull
    public static final String ID_BLOCK_DELIMITER = ":";
    @NotNull
    public static final String ID_ENTITY_DELIMITER = "#";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public abstract String getLogInfo();

    protected void execute() {
        if (ReadOnlyModeAware.INSTANCE.shouldSkipJob()) {
            Companion.getLogger().info((Function0)new Function0<String>(this){
                final /* synthetic */ AbstractAnalyzerJob this$0;

                @NotNull
                public final String invoke() {
                    return this.this$0.getLogInfo() + " skipped due to read only mode activation";
                }
                {
                    this.this$0 = abstractAnalyzerJob;
                    super(0);
                }
            });
            return;
        }
        NotificationTasks tasks = this.analyze();
        TransientEntityStore.DefaultImpls.transactional$default((TransientEntityStore)DnqUtils.getTransientStore(), (boolean)false, null, (boolean)false, (Function1)((Function1)new Function1<TransientStoreSession, Unit>(this, tasks){
            final /* synthetic */ AbstractAnalyzerJob this$0;
            final /* synthetic */ NotificationTasks $tasks$inlined;
            {
                this.this$0 = abstractAnalyzerJob;
                this.$tasks$inlined = notificationTasks;
                super(1);
            }

            public final Unit invoke(@NotNull TransientStoreSession it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                this.this$0.schedule$youtrack_custom_notifications(AbstractAnalyzerJob.access$envelop(this.this$0, this.$tasks$inlined));
                return Unit.INSTANCE;
            }
        }), (int)7, null);
    }

    private final List<NotificationJob> envelop(NotificationTasks tasks) {
        List list;
        if (tasks != null && tasks.isNotEmpty()) {
            ArrayList parcel = new ArrayList(tasks.getTasks().size());
            Map $receiver$iv = tasks.getTasks();
            LinkedHashMap<XdUser, CompositeReason> result$iv = new LinkedHashMap<XdUser, CompositeReason>();
            Object object = $receiver$iv;
            for (Map.Entry<XdUser, CompositeReason> entry$iv : object.entrySet()) {
                XdUser recipient = entry$iv.getKey();
                if (!this.shouldNotify(recipient)) continue;
                result$iv.put(entry$iv.getKey(), entry$iv.getValue());
            }
            $receiver$iv = result$iv;
            Map map2 = $receiver$iv;
            object = map2.entrySet().iterator();
            while (object.hasNext()) {
                Map.Entry element$iv;
                Map.Entry it = element$iv = (Map.Entry)object.next();
                this.appendSendJobs((XdUser)it.getKey(), (CompositeReason)it.getValue(), parcel);
            }
            list = parcel;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    public final void schedule$youtrack_custom_notifications(@NotNull List<? extends NotificationJob> parcel) {
        Intrinsics.checkParameterIsNotNull(parcel, (String)"parcel");
        this.register(parcel);
        Collection collection = parcel;
        if (!collection.isEmpty()) {
            Iterable $receiver$iv = parcel;
            for (Object element$iv : $receiver$iv) {
                NotificationJob job = (NotificationJob)((Object)element$iv);
                this.scheduleSingleSendJob(job);
                Companion.getLogger().info((Function0)new Function0<String>(job, this){
                    final /* synthetic */ NotificationJob $job;
                    final /* synthetic */ AbstractAnalyzerJob this$0;
                    {
                        this.$job = notificationJob;
                        this.this$0 = abstractAnalyzerJob;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return this.this$0.getLogInfo() + " created " + this.$job.getContentInfo() + " due to " + this.$job.getReasonInfo();
                    }
                });
            }
        } else {
            Companion.getLogger().info((Function0)new Function0<String>(this){
                final /* synthetic */ AbstractAnalyzerJob this$0;

                @NotNull
                public final String invoke() {
                    return this.this$0.getLogInfo() + " didn't create any notification job";
                }
                {
                    this.this$0 = abstractAnalyzerJob;
                    super(0);
                }
            });
        }
    }

    protected void scheduleSingleSendJob(@NotNull NotificationJob job) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)job), (String)"job");
        job.schedule();
    }

    protected void register(@NotNull List<? extends NotificationJob> parcel) {
        Intrinsics.checkParameterIsNotNull(parcel, (String)"parcel");
    }

    private final boolean shouldNotify(XdUser recipient) {
        return !recipient.getBanned() && (Intrinsics.areEqual((Object)recipient, (Object)this.sender) ^ true || BeansKt.getUserProfileService().getNotificationsProfile(recipient).isNotifyOnOwnChanges());
    }

    @Nullable
    protected abstract NotificationTasks analyze();

    protected abstract void appendSendJobs(@NotNull XdUser var1, @NotNull CompositeReason var2, @NotNull List<NotificationJob> var3);

    @NotNull
    protected final XdUser getSender() {
        return this.sender;
    }

    public AbstractAnalyzerJob(@NotNull Object id, @NotNull XdUser sender) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        Intrinsics.checkParameterIsNotNull((Object)sender, (String)"sender");
        super(id);
        this.sender = sender;
    }

    @NotNull
    public static final /* synthetic */ List access$envelop(AbstractAnalyzerJob $this, @Nullable NotificationTasks tasks) {
        return $this.envelop(tasks);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Ljetbrains/youtrack/notifications/analyzer/AbstractAnalyzerJob$Companion;", "Lmu/KLogging;", "()V", "ID_BLOCK_DELIMITER", "", "ID_ENTITY_DELIMITER", "youtrack-custom-notifications"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

