/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.notifications.analyzer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import jetbrains.exodus.util.ByteUtil;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.youtrack.api.events.EventCategory;
import jetbrains.youtrack.api.events.EventNotificationAdapter;
import jetbrains.youtrack.api.notifications.NotificationReason;
import jetbrains.youtrack.api.notifications.Reason;
import jetbrains.youtrack.core.watchFolder.RuleType;
import jetbrains.youtrack.notifications.analyzer.MentionReason;
import jetbrains.youtrack.notifications.analyzer.WatchFolderReason;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u001aJ\u000e\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u001aJ\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001dH\u0016J\u000e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001dH\u0016J\u000e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001dH\u0016J\u000e\u0010 \u001a\u00020\u00152\u0006\u0010!\u001a\u00020\"J\u000e\u0010#\u001a\u00020\u00192\u0006\u0010$\u001a\u00020\u0000J\b\u0010%\u001a\u00020&H\u0016J\u0010\u0010'\u001a\u0004\u0018\u00010\u00002\u0006\u0010(\u001a\u00020)J\u0010\u0010*\u001a\u00020\u00152\u0006\u0010!\u001a\u00020\"H\u0002R\u0014\u0010\u0003\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Ljetbrains/youtrack/notifications/analyzer/CompositeReason;", "Ljetbrains/youtrack/api/notifications/NotificationReason;", "()V", "commentTextCategory", "Ljetbrains/youtrack/api/events/EventCategory;", "getCommentTextCategory", "()Ljetbrains/youtrack/api/events/EventCategory;", "descriptionCategory", "getDescriptionCategory", "mentionReasons", "", "Ljetbrains/youtrack/api/notifications/Reason;", "savedSearchReasons", "subreasons", "", "getSubreasons", "()Ljava/lang/Iterable;", "tagsReasons", "watchFolderCumulativeMask", "", "addMentionReason", "", "reason", "Ljetbrains/youtrack/notifications/analyzer/MentionReason;", "addSavedSearchReason", "", "Ljetbrains/youtrack/notifications/analyzer/WatchFolderReason;", "addTagReason", "getMentionReasons", "", "getSavedSearchReasons", "getTagReasons", "match", "adapter", "Ljetbrains/youtrack/api/events/EventNotificationAdapter;", "merge", "other", "toString", "", "truncate", "type", "Ljetbrains/youtrack/core/watchFolder/RuleType;", "withUserMention", "youtrack-custom-notifications"})
public final class CompositeReason
implements NotificationReason {
    private final Set<Reason> savedSearchReasons;
    private final Set<Reason> tagsReasons;
    private final Set<Reason> mentionReasons;
    private int watchFolderCumulativeMask;

    private final EventCategory getCommentTextCategory() {
        String name$iv = "commentTextCategory";
        Object object = ServiceLocator.getBean((String)name$iv);
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type jetbrains.youtrack.api.events.EventCategory");
        }
        return (EventCategory)object;
    }

    private final EventCategory getDescriptionCategory() {
        String name$iv = "descriptionCategory";
        Object object = ServiceLocator.getBean((String)name$iv);
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type jetbrains.youtrack.api.events.EventCategory");
        }
        return (EventCategory)object;
    }

    public final void addSavedSearchReason(@NotNull WatchFolderReason reason) {
        Intrinsics.checkParameterIsNotNull((Object)reason, (String)"reason");
        this.savedSearchReasons.add(reason);
        this.watchFolderCumulativeMask = ByteUtil.or((int)this.watchFolderCumulativeMask, (int)reason.getMask());
    }

    public final void addTagReason(@NotNull WatchFolderReason reason) {
        Intrinsics.checkParameterIsNotNull((Object)reason, (String)"reason");
        this.tagsReasons.add(reason);
        this.watchFolderCumulativeMask = ByteUtil.or((int)this.watchFolderCumulativeMask, (int)reason.getMask());
    }

    public final boolean addMentionReason(@NotNull MentionReason reason) {
        Intrinsics.checkParameterIsNotNull((Object)reason, (String)"reason");
        return this.mentionReasons.add(reason);
    }

    public final void merge(@NotNull CompositeReason other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        this.savedSearchReasons.addAll((Collection<Reason>)other.savedSearchReasons);
        this.tagsReasons.addAll((Collection<Reason>)other.tagsReasons);
        this.mentionReasons.addAll((Collection<Reason>)other.mentionReasons);
    }

    public final boolean match(@NotNull EventNotificationAdapter adapter) {
        Intrinsics.checkParameterIsNotNull((Object)adapter, (String)"adapter");
        return adapter.getTriggeredRuleType().is(this.watchFolderCumulativeMask) || this.withUserMention(adapter);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean withUserMention(EventNotificationAdapter adapter) {
        Reason reason;
        Collection collection = this.mentionReasons;
        if (collection.isEmpty()) return false;
        boolean bl = true;
        if (!bl) return false;
        collection = adapter.getAdaptedEventCategory();
        Collection it = collection;
        if (it != this.getCommentTextCategory()) {
            if (it != this.getDescriptionCategory()) return false;
        }
        boolean bl2 = true;
        if (!bl2) return false;
        Iterable $receiver$iv = this.mentionReasons;
        if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $receiver$iv.iterator();
        do {
            Reason it2;
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            reason = it2 = (Reason)element$iv;
            if (reason != null) continue;
            throw new TypeCastException("null cannot be cast to non-null type jetbrains.youtrack.notifications.analyzer.MentionReason");
        } while (!((MentionReason)reason).match(adapter));
        return true;
    }

    @Nullable
    public final CompositeReason truncate(@NotNull RuleType type) {
        Object that;
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        Object result = null;
        Object object = this.mentionReasons;
        if (!object.isEmpty()) {
            Object object2;
            that = object = new CompositeReason();
            ((CompositeReason)that).mentionReasons.addAll((Collection<Reason>)this.mentionReasons);
            result = object2 = object;
        }
        if (type.is(this.watchFolderCumulativeMask)) {
            Object $receiver;
            Object it;
            Reason it2;
            Object element$iv$iv;
            Iterable $receiver$iv$iv;
            Iterable $receiver$iv = this.savedSearchReasons;
            that = $receiver$iv;
            Collection destination$iv$iv = new ArrayList();
            Iterator iterator = $receiver$iv$iv.iterator();
            while (iterator.hasNext()) {
                element$iv$iv = iterator.next();
                Reason reason = it2 = (Reason)element$iv$iv;
                if (reason == null) {
                    throw new TypeCastException("null cannot be cast to non-null type jetbrains.youtrack.notifications.analyzer.WatchFolderReason");
                }
                if (!((WatchFolderReason)reason).has(type)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            for (Object element$iv : $receiver$iv) {
                it = (Reason)element$iv;
                Object object3 = result;
                if (object3 == null) {
                    object3 = new CompositeReason();
                }
                $receiver = element$iv$iv = object3;
                ((CompositeReason)$receiver).savedSearchReasons.add((Reason)it);
                Object $i$f$filterTo = element$iv$iv;
                result = $i$f$filterTo;
            }
            $receiver$iv = this.tagsReasons;
            $receiver$iv$iv = $receiver$iv;
            destination$iv$iv = new ArrayList();
            it = $receiver$iv$iv.iterator();
            while (it.hasNext()) {
                element$iv$iv = it.next();
                Reason reason = it2 = (Reason)element$iv$iv;
                if (reason == null) {
                    throw new TypeCastException("null cannot be cast to non-null type jetbrains.youtrack.notifications.analyzer.WatchFolderReason");
                }
                if (!((WatchFolderReason)reason).has(type)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            for (Object element$iv : $receiver$iv) {
                Object object4;
                it = (Reason)element$iv;
                Object object5 = result;
                if (object5 == null) {
                    object5 = new CompositeReason();
                }
                Object object6 = object5;
                $receiver = object6;
                ((CompositeReason)$receiver).tagsReasons.add((Reason)it);
                result = object4 = object6;
            }
        }
        return result;
    }

    @NotNull
    public Set<Reason> getSavedSearchReasons() {
        return this.savedSearchReasons;
    }

    @NotNull
    public Set<Reason> getTagReasons() {
        return this.tagsReasons;
    }

    @NotNull
    public Set<Reason> getMentionReasons() {
        return this.mentionReasons;
    }

    @NotNull
    public String toString() {
        return CollectionsKt.joinToString$default(this.getSubreasons(), (CharSequence)":", null, null, (int)0, null, null, (int)62, null);
    }

    @NotNull
    public final Iterable<Reason> getSubreasons() {
        return SetsKt.plus((Set)SetsKt.plus(this.mentionReasons, (Iterable)this.savedSearchReasons), (Iterable)this.tagsReasons);
    }

    public CompositeReason() {
        Set set;
        CompositeReason compositeReason = this;
        compositeReason.savedSearchReasons = set = (Set)new LinkedHashSet();
        compositeReason = this;
        compositeReason.tagsReasons = set = (Set)new LinkedHashSet();
        compositeReason = this;
        compositeReason.mentionReasons = set = (Set)new LinkedHashSet();
    }
}

