/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.notifications.analyzer;

import com.jetbrains.teamsys.dnq.database.EntityOperations;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import jetbrains.exodus.core.execution.Job;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.youtrack.api.events.Event;
import jetbrains.youtrack.api.events.EventCategory;
import jetbrains.youtrack.api.events.EventMerge;
import jetbrains.youtrack.api.events.EventNotificationAdapter;
import jetbrains.youtrack.core.watchFolder.RuleType;
import jetbrains.youtrack.notifications.analyzer.AnalyzerJobFactory;
import jetbrains.youtrack.notifications.analyzer.BeansKt;
import jetbrains.youtrack.notifications.persistence.XdNotificationManagement;
import jetbrains.youtrack.persistent.XdIssue;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.dnq.XdExtensionsKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

@Service(value="eventMergeAnalyzer")
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nR\u0014\u0010\u0003\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\u000e"}, d2={"Ljetbrains/youtrack/notifications/analyzer/EventMergeAnalyzer;", "", "()V", "digestJobFactory", "Ljetbrains/youtrack/notifications/analyzer/AnalyzerJobFactory;", "getDigestJobFactory", "()Ljetbrains/youtrack/notifications/analyzer/AnalyzerJobFactory;", "granularJobFactory", "getGranularJobFactory", "analyze", "", "merge", "Ljetbrains/youtrack/api/events/EventMerge;", "durable", "youtrack-custom-notifications"})
public final class EventMergeAnalyzer {
    private final AnalyzerJobFactory getGranularJobFactory() {
        String name$iv = "granularJobFactory";
        Object object = ServiceLocator.getBean((String)name$iv);
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type jetbrains.youtrack.notifications.analyzer.AnalyzerJobFactory");
        }
        return (AnalyzerJobFactory)object;
    }

    private final AnalyzerJobFactory getDigestJobFactory() {
        String name$iv = "digestJobFactory";
        Object object = ServiceLocator.getBean((String)name$iv);
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type jetbrains.youtrack.notifications.analyzer.AnalyzerJobFactory");
        }
        return (AnalyzerJobFactory)object;
    }

    public final boolean analyze(@NotNull EventMerge merge, boolean durable) {
        Iterable tag;
        boolean deprecated;
        Iterator iterator;
        Intrinsics.checkParameterIsNotNull((Object)merge, (String)"merge");
        XdIssue issue = (XdIssue)XdExtensionsKt.toXd((Entity)merge.getIssue());
        Event tagEvent = null;
        boolean created = false;
        int cumulativeMask = 0;
        List adapters = new ArrayList();
        byte silentMarker = jetbrains.charisma.persistent.BeansKt.getSilentApplyEventMarker().getId();
        byte systemMarker = jetbrains.charisma.persistent.BeansKt.getSystemApplyEventMarker().getId();
        Iterable $receiver$iv = merge.getUnsafeEvents();
        for (Object element$iv : $receiver$iv) {
            EventNotificationAdapter it;
            EventCategory category;
            Event event2 = (Event)element$iv;
            byte marker = event2.getMarker();
            boolean shouldAnalyze = marker != silentMarker && marker != systemMarker;
            if (!shouldAnalyze) continue;
            Intrinsics.checkExpressionValueIsNotNull((Object)event2.getCategory(), (String)"event.category");
            if (!created && category == jetbrains.youtrack.event.category.BeansKt.getIssueCreatedCategory()) {
                created = true;
            }
            if (category == jetbrains.youtrack.event.category.BeansKt.getTagsCategory()) {
                tagEvent = event2;
            }
            if (category.createAdapter(category.createProxyEvent(event2)) == null) continue;
            EventNotificationAdapter eventNotificationAdapter = it = iterator;
            Intrinsics.checkExpressionValueIsNotNull((Object)eventNotificationAdapter, (String)"it");
            RuleType ruleType = eventNotificationAdapter.getTriggeredRuleType();
            cumulativeMask = ruleType != null ? ruleType.set(cumulativeMask, true) : cumulativeMask;
            adapters.add(it);
        }
        if (adapters.isEmpty() && tagEvent == null) {
            return false;
        }
        if (created) {
            cumulativeMask = RuleType.NOTIFY_ON_ISSUE_UPDATE.set(cumulativeMask, false);
        }
        AnalyzerJobFactory factory = (deprecated = ((XdNotificationManagement)XdNotificationManagement.Companion.get()).getUseDeprecatedNotificationScheme()) ? this.getGranularJobFactory() : this.getDigestJobFactory();
        Job issueChangeAnalyzerJob = factory.createIssueJob(merge, adapters, created, cumulativeMask, durable);
        BeansKt.getNotifyingAnalyzerJobProcessor().queue(issueChangeAnalyzerJob);
        if (created) {
            Iterator $receiver$iv$iv;
            Iterable $receiver$iv2;
            Entity author = merge.getAuthor();
            Iterable shouldAnalyze = $receiver$iv2 = issue.getTags().getEntityIterable();
            Collection destination$iv$iv = new ArrayList();
            iterator = $receiver$iv$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv$iv = iterator.next();
                Entity it = (Entity)element$iv$iv;
                if (!(!EntityOperations.isRemoved((Entity)it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $receiver$iv2 = (List)destination$iv$iv;
            for (Object element$iv : $receiver$iv2) {
                tag = (Entity)element$iv;
                Job addedTagOnCreationAnalyzerJob = factory.createTagJob(merge, (Entity)tag, author, false);
                BeansKt.getNotifyingAnalyzerJobProcessor().queue(addedTagOnCreationAnalyzerJob);
            }
        }
        Event event3 = tagEvent;
        if (event3 != null) {
            Object tag2;
            Entity it;
            Object element$iv$iv;
            Iterable $receiver$iv$iv;
            Iterable $receiver$iv3;
            Event event4;
            Event it2 = event4 = event3;
            Entity author = merge.getAuthor();
            Iterable iterable = it2.getAddedLinks();
            Intrinsics.checkExpressionValueIsNotNull((Object)iterable, (String)"it.addedLinks");
            tag = $receiver$iv3 = iterable;
            Collection destination$iv$iv = new ArrayList();
            Iterator $i$a$3$forEach = $receiver$iv$iv.iterator();
            while ($i$a$3$forEach.hasNext()) {
                element$iv$iv = $i$a$3$forEach.next();
                it = (Entity)element$iv$iv;
                if (!(!EntityOperations.isRemoved((Entity)it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $receiver$iv3 = (List)destination$iv$iv;
            for (Object element$iv : $receiver$iv3) {
                tag2 = (Entity)element$iv;
                Entity entity = tag2;
                Intrinsics.checkExpressionValueIsNotNull((Object)entity, (String)"tag");
                Job addedTagAnalyzerJob = factory.createTagJob(merge, entity, author, false);
                BeansKt.getNotifyingAnalyzerJobProcessor().queue(addedTagAnalyzerJob);
            }
            Iterable iterable2 = it2.getRemovedLinks();
            Intrinsics.checkExpressionValueIsNotNull((Object)iterable2, (String)"it.removedLinks");
            $receiver$iv3 = iterable2;
            $receiver$iv$iv = $receiver$iv3;
            destination$iv$iv = new ArrayList();
            tag2 = $receiver$iv$iv.iterator();
            while (tag2.hasNext()) {
                element$iv$iv = tag2.next();
                it = (Entity)element$iv$iv;
                if (!(!EntityOperations.isRemoved((Entity)it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $receiver$iv3 = (List)destination$iv$iv;
            for (Object element$iv : $receiver$iv3) {
                Object object = tag2 = (Entity)element$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"tag");
                Job removedTagAnalyzerJob = factory.createTagJob(merge, (Entity)object, author, true);
                BeansKt.getNotifyingAnalyzerJobProcessor().queue(removedTagAnalyzerJob);
            }
        }
        return true;
    }
}

